unit Act;

interface

Uses
	WinTypes, Forms, SysUtils, Globals, LocStuff, GameStuf, FlagDef, ObjStuff,
	MesStuff, Graphics, Dialogs;

Procedure DoDropAll;
Function DoAutog : Boolean;
Function DoAutod : Boolean;
Function DoAutow : Boolean;
Function DoAutor : Boolean;
Function DoWHATO(Data1, Data2 : Word) : Word;
Procedure DoTurns;
Procedure DoScore;
Procedure DoCLS;
Procedure DoNewLine;
Procedure DoListObj;
Function DoInven : Word;
Function DoDesc : Word;
Function DoEnd : Boolean;
Function DoDone(Data1, Data2 : Word) : Word;
Function DoNotDone(Data1, Data2 : Word) : Word;
Function DoSAVE(Data1, Data2 : Word) : Word;
Function DoLOAD(Data1, Data2 : Word) : Word;
Procedure DoAnyKey;
Function DoNewText : Word;
Function DoGet(Data1 : Word) : Boolean;
Function DoDrop(Data1 : Word) : Boolean;
Function DoWear(Data1 : Word) : Boolean;
Function DoRemove(Data1 : Word) : Boolean;
Function DoCreate(Data1 : Word) : Word;
Procedure DoDestroy(Data1 : Word);
Function DoPUTO(Data1, Data2 : Word) : Word;
Function DoAutop(Data1 : Word) : Boolean;
Function DoAutot(Data1 : Word) : Boolean;
Procedure DoSet(Data1 : Word);
Procedure DoClear(Data1 : Word);
Procedure DoTurnOn(Data1 : Word);
Procedure DoTurnOff(Data1 : Word);
Procedure DoRandom(Data1 : Word);
Function DoMove(Data1 : Word) : Boolean;
Procedure DoGoto(Data1 : Word);
Procedure DoWeight(Data1 : Word);
Procedure DoPrint(Data1 : Word);
Procedure DoMes(Data1 : Word);
Procedure DoMessage(Data1 : Word);
Function DoIntMess(Data1 : Word) : Word;
Procedure DoBG(Data1 : Word);
Procedure DoFG(Data1 : Word);
Procedure DoListAt(Data1 : Word);
Procedure DoPause(Data1 : Word);
Function DoTable(Data1, Data2 : Word) : Word;
Function DoDoAll(Data1 : Word) : Boolean;
Function DoSwap(Data1, Data2 : Word) : Word;
Function DoPlace(Data1, Data2 : Word) : Word;
Function DoPutIn(Data1, Data2 : Word) : Boolean;
Function DoTakeOut(Data1, Data2 : Word) : Boolean;
Function DoCopyOO(Data1, Data2 : Word) : Word;
Function DoCopyOF(Data1, Data2 : Word) : Word;
Function DoCopyFO(Data1, Data2 : Word) : Word;
Function DoPlus(Data1, Data2 : Word) : Word;
Function DoMinus(Data1, Data2 : Word) : Word;
Function DoAdd(Data1, Data2 : Word) : Word;
Function DoSub(Data1, Data2 : Word) : Word;
Function DoCopyFF(Data1, Data2 : Word) : Word;
Procedure DoBeep;
Function DoAbility(Data1, Data2 : Word) : Word;
Function DoExamine(Data1 : Word) : Boolean;
Function DoAutoE : Boolean;
Procedure DoLet(Data1, Data2 : Word);

implementation

Uses
	Test, LocMenu, IntDlg, Condit;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoDropAll;
Var
	Index : Integer;
	PlayerLoc : Word;
	ThisObj : GameObject;
Begin
	PlayerLoc := Flags.GetFlagValue(_PlayerLocation);
	For Index := 1 To Objects.NumObjects Do
	Begin
		ThisObj := Objects.GetObjectAtIndex(Index);
		If (ThisObj.ObjCurrentLocation = _WornLoc) Then
			Objects.SetObjectLocation(ThisObj.ObjNumber, PlayerLoc)
	End;	{For}
End;	{DoDropAll}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoAutog : Boolean;
Var
	ObjNum : Word;
	RetCode : Boolean;
Begin
	If Flags.GetFlagValue(_PhraseNoun1) <> 0 Then
	Begin
		ObjNum := Objects.GetObjectFromNnAndAdj(Flags.GetFlagValue(_PhraseNoun1),
										Flags.GetFlagValue(_PhraseAdjective1));
		If ((ObjNum > 0) And (ObjNum < 65501)) Then	{valid object number}
		Begin
			RetCode := DoGet(ObjNum);
			DoAutog := RetCode;
		End Else Begin
			If (Objects.NumObjects > 0) Then
			Begin
				DoIntMess(_IsntOneHereMessage);
				DoAutog := _Failed
			End Else Begin
				DoIntMess(_CantDoMessage);
				DoAutog := _Failed;
			End
		End;
	End Else Begin
		DoIntMess(_ObjNotKnownMessage);
		DoAutog := _Failed;
	End;	{if phrase has noun}
End;	{DoAutog}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoAutod : Boolean;
Var
	ObjNum : Word;
	RetCode : Boolean;
Begin
	If Flags.GetFlagValue(_PhraseNoun1) <> 0 Then
	Begin
		ObjNum := Objects.GetObjectFromNnAndAdj(Flags.GetFlagValue(_PhraseNoun1),
										Flags.GetFlagValue(_PhraseAdjective1));
		If ((ObjNum > 0) And (ObjNum < 65501)) Then	{valid object number}
		Begin
			RetCode := DoDrop(ObjNum);
			DoAutod := RetCode;
		End Else Begin
			If (Objects.NumObjects > 0) Then
			Begin
				DoIntMess(_DontHaveOnemessage);
				DoAutod := _Failed
			End Else Begin
				DoIntMess(_CantDoMessage);
				DoAutod := _Failed;
			End;
		End;
	End Else Begin
		DoIntMess(_ObjNotKnownMessage);
		DoAutod := _Failed;
	End;	{if phrase has noun}
End;	{DoAutod}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoAutow : Boolean;
Var
	ObjNum : Word;
	RetCode : Boolean;
Begin
	If Flags.GetFlagValue(_PhraseNoun1) <> 0 Then
	Begin
		ObjNum := Objects.GetObjectFromNnAndAdj(Flags.GetFlagValue(_PhraseNoun1),
										Flags.GetFlagValue(_PhraseAdjective1));
		If ((ObjNum > 0) And (ObjNum < 65501)) Then	{valid object number}
		Begin
			RetCode := DoWear(ObjNum);
			DoAutow := RetCode;
		End Else Begin
			If (Objects.NumObjects > 0) Then
			Begin
				DoIntMess(_DontHaveOnemessage);
				DoAutow := _Failed
			End Else Begin
				DoIntMess(_CantDoMessage);
				DoAutow := _Failed;
			End;
		End;
	End Else Begin
		DoIntMess(_ObjNotKnownMessage);
		DoAutow := _Failed;
	End;	{if phrase has noun}
End;	{DoAutow}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoAutor : Boolean;
Var
	ObjNum : Word;
	RetCode : Boolean;
Begin
	If Flags.GetFlagValue(_PhraseNoun1) <> 0 Then
	Begin
		ObjNum := Objects.GetObjectFromNnAndAdj(Flags.GetFlagValue(_PhraseNoun1),
										Flags.GetFlagValue(_PhraseAdjective1));
		If ((ObjNum > 0) And (ObjNum < 65501)) Then	{valid object number}
		Begin
			RetCode := DoRemove(ObjNum);
			DoAutor := RetCode;
		End Else Begin
			If (Objects.NumObjects > 0) Then
			Begin
				DoIntMess(_DontHaveOnemessage);
				DoAutor := _Failed
			End Else Begin
				DoIntMess(_CantDoMessage);
				DoAutor := _Failed;
			End;
		End;
	End Else Begin
		DoIntMess(_ObjNotKnownMessage);
		DoAutor := _Failed;
	End;
End;	{DoAutor}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoWhatO(Data1, Data2 : Word) : Word;
Begin
{protect}
End;	{DoWhatO}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoTurns;
Var
	TuMes1, TuMes2, TuMes3, TuMes4 : String;
	P : Pchar;
	Turns : Word;
Begin
	TuMes1 := IntMessages.GetMessage(_TurnsMessage1);
	TuMes2 := IntMessages.GetMessage(_TurnsMessage2);
	TuMes3 := IntMessages.GetMessage(_TurnsMessage3);
	TuMes4 := IntMessages.GetMessage(_TurnsMessage4);
	Turns := Flags.GetFlagValue(_GameTurns);

	If Turns <> 1 Then TuMes2 := TuMes2+TuMes3+TuMes4
	Else TuMes2 := TuMes2+TuMes4;

	GetMem(P, 1030);

	StrPCopy(P, TuMes1+IntToStr(Turns)+TuMes2);
	TestUnit.AddText(P, True);
	FreeMem(P, 1030);
End;	{DoTurns}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoScore;
Var
	ScMes1, ScMes2 : String;
	P : Pchar;
	Score : Word;
Begin
	ScMes1 := IntMessages.GetMessage(_ScoreMessage1);
	ScMes2 := IntMessages.GetMessage(_ScoreMessage2);
	Score := Flags.GetFlagValue(_PlayerScore);

	GetMem(P, 514);

	StrPCopy(P, ScMes1+IntToStr(Score)+ScMes2);
	TestUnit.AddText(P, True);
	FreeMem(P, 514);
End;	{DoScore}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoCLS;
Begin
	TestUnit.CLS;
End;	{DoCLS}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoNewLine;
Begin
	TestUnit.AddText('^^^^^', True);
End;	{DoNewLine}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoListObj;
Var
	PlayerLoc : Word;
	First : Boolean;
	Index : Word;
	ThisObject : GameObject;
	P : PChar;
Begin
	PlayerLoc := Flags.GetFlagValue(_PlayerLocation);

	Getmem(P, 51);

	First := True;	{to see if it is the first object printed}
	For Index := 0 To Objects.NumObjects -1 Do
	Begin
		ThisObject := Objects.GetObjectAtIndex(Index);
		If ((ThisObject.ObjCurrentLocation = PlayerLoc) And
			(ThisObject.ObjInvisible = False)) Then
		Begin
			If First = True Then
			Begin
				First := False;
				DoIntMess(_ObjsPresentMessage);
			End;

			StrPCopy(P, ThisObject.ObjShortName);
			TestUnit.AddText(P, True);
		End;	{is object here}
	End;	{For}

	FreeMem(P, 51);
End;	{DoListObj}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoInven : Word;
Var
	Objectscarried, ObjectsWorn : Word;
	ThisObject : GameObject;
	Index : Word;
	P : PChar;
Begin
	ObjectsCarried := Flags.GetFlagValue(_ObjectsCarried);
	ObjectsWorn := Flags.GetFlagValue(_ObjectsWorn);

	GetMem(P, 51);

	DoIntMess(_CarryingMessage1);
	If ObjectsCarried = 0 Then
	Begin
		DoIntMess(_CarryingMessage2);
	End Else Begin
		For Index := 0 to Objects.NumObjects -1 Do
		Begin
			ThisObject:=Objects.GetObjectAtIndex(Index);
			If ThisObject.ObjCurrentLocation = _CarriedLoc Then
			Begin
				StrPCopy(P, ThisObject.ObjShortName);
				TestUnit.AddText(P, True);
			End;
		End;	{For}
	End;

	DoIntMess(_WearingMessage);
	If ObjectsWorn = 0 Then
	Begin
		DoIntMess(_CarryingMessage2);
	End Else Begin
		For Index := 0 to Objects.NumObjects -1 Do
		Begin
			ThisObject:=Objects.GetObjectAtIndex(Index);
			If ThisObject.ObjCurrentLocation = _WornLoc Then
			Begin
				StrPCopy(P, ThisObject.ObjShortName);
				TestUnit.AddText(P, True);
			End;
		End;	{For}
	End;

	FreeMem(P, 51);
	DoInven := _AllOKCode;
End;	{DoInven}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoDesc : Word;
{put the description of the current location on the screen for the user to see}
Var
	Location : Word;
	ThisLocation : MGameLocation;
	ListIndex : Word;
Begin
	DoAllLoop := False;
	NewText := True;
	Location := Flags.GetFlagValue(_PlayerLocation);

	Listindex := FindLocation(Location);

	ThisLocation := LocationList.Items[ListIndex];

	TestUnit.AddText(ThisLocation.Location.Description, True);
	ProcessActionTables(1,False);
End;	{DoDesc}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoEnd : Boolean;
Var
	ErrorString : PChar;
	Button : Integer;
Begin
	GetMem(ErrorString,512);
	Replay := False;

	StrPCopy(ErrorString,IntMessages.GetMessage(_EndGameMessage)+#13+#10+
						IntMessages.GetMessage(_ReplayMessage));
	Button := Application.MessageBox(ErrorString,
								'END',
								mb_YesNo);
	FreeMem(ErrorString, 512);
	If Button = idYes Then DoEnd := True
	Else DoEnd := False;
End;	{DoEnd}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoDone(Data1, Data2 : Word) : Word;
Begin
	{in this implementation does nothing - should be handled by calling
		routine - ExecEntry}
End;	{DoDone}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoNotDone(Data1, Data2 : Word) : Word;
Begin
	{does nothing in this implementation - handled by calling routine, which
		is ExecEntry}
End;	{DoNotDone}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoSave(Data1, Data2 : Word) : Word;
Begin
{protect}
End;	{DoSave}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoLoad(Data1, Data2 : Word) : Word;
Begin
{protect}
End;	{DoLoad}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoAnyKey;
Var
	TempText : AnsiString;
Begin
	TempText := Application.Title;
	Application.Title := 'AGC';
	MessageDlgPos(IntMessages.GetMessage(_AnyKeyMessage),
					mtCustom,
					[mbOK],
					0,
					100,
					100);
	Application.Title := TempText;
End;	{DoAnyKey}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoNewText : Word;
Begin
	{doesn't do anything........variable should be set by caller instead of
		calling here!}
End;	{DoNewText}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoGet(Data1 : Word) : Boolean;
Var
	ThisObject : GameObject;
	PlayerLoc : Word;
	PlayerWeight : Word;	{The weight of the objects carried by the player}
	PlayerObjects : Word;	{the number of objects carried by the player}
Begin
	PlayerLoc := Flags.GetFlagValue(_PlayerLocation);
	PlayerWeight := Flags.GetFlagValue(_PlayerWeight);
	PlayerObjects := Flags.GetFlagValue(_ObjectsCarried);
	ThisObject := Objects.GetObject(Data1);
	If ((ThisObject.ObjCurrentLocation = _CarriedLoc) Or
		(ThisObject.ObjCurrentLocation = _WornLoc)) Then
	Begin
		DoIntMess(_AlreadyHaveMessage);
		DoGet := _Failed;
	End Else Begin
		If (ThisObject.ObjCurrentLocation = PlayerLoc) Then
		Begin
			If (ThisObject.ObjWeight + PlayerWeight) <= MaxWt Then
			Begin
				If (PlayerObjects +1 <= MaxObj) Then
				Begin
					Objects.SetObjectLocation(ThisObject.ObjNumber, _CarriedLoc);
					Flags.SetFlagValue(_ObjectsCarried, Flags.GetFlagValue(_ObjectsCarried) +1);
					DoIntMess(_GetMessage);
					DoGet := _Succeeded;
				End Else Begin
					DoIntMess(_HandsFullMessage);
					DoGet := _Failed;
				End;
			End Else Begin
				DoIntMess(_TooHeavyMessage);
				DoGet := _Failed;
			End;
		End Else Begin
			DoIntMess(_IsntOneHereMessage);
			DoGet := _Failed;
		End;
	End;
End;	{DoGet}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoDrop(Data1 : Word) : Boolean;
Var
	ThisObject : GameObject;
	PlayerLoc : Word;
Begin
	PlayerLoc := Flags.GetFlagValue(_PlayerLocation);
	ThisObject := Objects.GetObject(Data1);
	If (ThisObject.ObjCurrentLocation <> _WornLoc) Then
	Begin
		If (ThisObject.ObjCurrentLocation <> PlayerLoc) Then
		Begin
			If (ThisObject.ObjCurrentLocation <> _CarriedLoc) Then
			Begin
				DoIntMess(_DontHaveOneMessage);
				DoDrop := _Failed
			End Else Begin
				{we are here, means it's carried}
				Objects.SetObjectLocation(ThisObject.ObjNumber, PlayerLoc);
				Flags.SetFlagValue(_ObjectsCarried, Flags.GetFlagValue(_ObjectsCarried) -1);
				DoIntMess(_DropMessage);
				DoDrop := _Succeeded;
			End;
		End Else Begin
			DoIntMess(_DontHaveItMessage);
			DoDrop := _Failed;
		End;
	End Else Begin
		DoIntMess(_CantDropWearingMessage);
		DoDrop := _Failed;
	End;
End;	{DoDrop}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoWear(Data1 : Word) : Boolean;
Var
	ThisObject : GameObject;
	PlayerLoc : Word;
Begin
	PlayerLoc := Flags.GetFlagValue(_PlayerLocation);
	ThisObject := Objects.GetObject(Data1);
	If (ThisObject.ObjCurrentLocation <> PlayerLoc) Then
	Begin
		If (ThisObject.ObjCurrentLocation <> _WornLoc) Then
		Begin
			If (ThisObject.ObjCurrentLocation = _CarriedLoc) Then
			Begin
				If (ThisObject.ObjWearable = True) Then
				Begin
					Objects.SetObjectLocation(ThisObject.ObjNumber, _WornLoc);
					Flags.SetFlagValue(_ObjectsCarried, Flags.GetFlagValue(_ObjectsCarried) -1);
					Flags.SetFlagValue(_ObjectsWorn, Flags.GetFlagValue(_ObjectsWorn) +1);
					DoIntMess(_WearMessage);
					DoWear := _Succeeded;
				End Else Begin
					DoIntMess(_CantWearMessage);
					DoWear := _Failed;
				End;
			End Else Begin
				DoIntMess(_DontHaveOneMessage);
				DoWear := _Failed;
			End;
		End Else Begin
			DoIntMess(_AlreadyWearingMessage);
			DoWear := _Failed;
		End;
	End Else Begin
		DoIntMess(_DontHaveItMessage);
		DoWear := _Failed;
	End;	{object HERE}
End;	{DoWear}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoRemove(Data1 : Word) : Boolean;
Var
	ThisObject : GameObject;
	PlayerLoc : Word;
	PlayerObjects : Word;	{the number of objects carried by the player}
Begin
	PlayerLoc := Flags.GetFlagValue(_PlayerLocation);
	PlayerObjects := Flags.GetFlagValue(_ObjectsCarried);
	ThisObject := Objects.GetObject(Data1);

	{obj at location or carried - youre not wearing the thing}
	If ((ThisObject.ObjCurrentLocation = _CarriedLoc) Or
		(ThisObject.ObjCurrentLocation = PlayerLoc)) Then
	Begin
		DoIntMess(_NotWearingMessage);
		DoRemove := _Failed;
		Exit;
	End;

	{obj not here, not carried - youre not wearing one of those}
	If (ThisObject.ObjCurrentLocation <> _WornLoc) Then
	Begin
		DoIntMess(_NotWearingOneMessage);
		DoRemove := _Failed;
		Exit;
	End;

	{obj not wearable (thus not removable) - you cant remove the thing}
	If (ThisObject.ObjWearable = False) Then
	Begin
		DoIntMess(_CantRemoveMessage);
		DoRemove := _Failed;
		Exit;
	End;

	{if objs carried >= max carryable - youre carrying too many things}
	If (PlayerObjects >= MaxObj) Then
	Begin
		DoIntMess(_CantRemoveHandsFull);
		DoRemove := _Failed;
		Exit;
	End;

	{still here? remove it then}
	Objects.SetObjectLocation(ThisObject.ObjNumber, _CarriedLoc);
	Flags.SetFlagValue(_ObjectsCarried, Flags.GetFlagValue(_ObjectsCarried) + 1);
	Flags.SetFlagValue(_ObjectsWorn, Flags.GetFlagValue(_ObjectsWorn) -1);
	DoIntMess(_RemoveMessage);
	DoRemove := _Succeeded;
End;	{DoRemove}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoCreate(Data1 : Word) : Word;
Var
	PlayerLoc : Word;
	ThisObject : GameObject;
Begin
	PlayerLoc := Flags.GetFlagValue(_PlayerLocation);
	ThisObject := Objects.GetObject(Data1);
	If ThisObject.ObjCurrentLocation = _CarriedLoc Then
		Flags.SetFlagValue(_ObjectsCarried, Flags.GetFlagValue(_ObjectsCarried) -1);
	Objects.SetObjectLocation(Data1, PlayerLoc);
End;	{DoCreate}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoDestroy(Data1 : Word);
Var
	ThisObject : GameObject;
Begin
	ThisObject := Objects.GetObject(Data1);
	If ThisObject.ObjCurrentLocation = _CarriedLoc Then
		Flags.SetFlagValue(_ObjectsCarried, Flags.GetFlagValue(_ObjectsCarried) -1);
	Objects.SetObjectLocation(Data1, _NotCreatedLoc);
End;	{DoDestroy}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoPutO(Data1, Data2 : Word) : Word;
Begin
{protect}
End;	{DoPutO}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoAutop(Data1 : Word) : Boolean;
{get the object from the phrase, and attempt to put it in the location
specified}
Var
	ObjNum : Word;
	RetCode : Boolean;
Begin
	If Flags.GetFlagValue(_PhraseNoun1) <> 0 Then
	Begin
		ObjNum := Objects.GetObjectFromNnAndAdj(Flags.GetFlagValue(_PhraseNoun1),
										Flags.GetFlagValue(_PhraseAdjective1));
		If ((ObjNum > 0) And (ObjNum < 65501)) Then	{valid object number}
		Begin
			RetCode := DoPutIn(ObjNum, Data1);
			DoAutop := RetCode;
		End Else Begin
			If (Objects.NumObjects > 0) Then
			Begin
				DoIntMess(_IsntOneHereMessage);
				DoAutop := _Failed
			End Else Begin
				DoIntMess(_CantDoMessage);
				DoAutop := _Failed;
			End
		End;
	End Else Begin
		DoIntMess(_ObjNotKnownMessage);
		DoAutop := _Failed;
	End;	{if phrase has noun}
End;	{DoAutop}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoAutot(Data1 : Word) : Boolean;
{get the object from the phrase, and attempt to take it out of the location
specified}
Var
	ObjNum : Word;
	RetCode : Boolean;
Begin
	If Flags.GetFlagValue(_PhraseNoun1) <> 0 Then
	Begin
		ObjNum := Objects.GetObjectFromNnAndAdj(Flags.GetFlagValue(_PhraseNoun1),
										Flags.GetFlagValue(_PhraseAdjective1));
		If ((ObjNum > 0) And (ObjNum < 65501)) Then	{valid object number}
		Begin
			RetCode := DoTakeOut(ObjNum, Data1);
			DoAutot := RetCode;
		End Else Begin
			If (Objects.NumObjects > 0) Then
			Begin
				DoIntMess(_IsntOneHereMessage);
				DoAutot := _Failed
			End Else Begin
				DoIntMess(_CantDoMessage);
				DoAutot := _Failed;
			End
		End;
	End Else Begin
		DoIntMess(_ObjNotKnownMessage);
		DoAutot := _Failed;
	End;	{if phrase has noun}
End;	{DoAutot}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoSet(Data1 : Word);
Begin
	Flags.SetFlagValue(Data1, 65500);
End;	{DoSet}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoClear(Data1 : Word);
Begin
	Flags.SetFlagValue(Data1, 0);
End;	{DoClear}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoTurnOn(Data1 : Word);
Begin
	Bulbs.TurnOnBulb(Data1);
End;	{DoTurnOn}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoTurnOff(Data1 : Word);
Begin
	Bulbs.TurnOffBulb(Data1);
End;	{DoTurnOff}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoRandom(Data1 : Word);
Begin
	Randomize;
	Flags.SetFlagValue(Data1, Random(100));
End;	{DoRandom}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoMove(Data1 : Word) : Boolean;
Var
	RetCode : Word;
Begin
	RetCode := 0;
	If Flags.GetFlagValue(_PhraseNoun1) < 14 Then
		RetCode := DoConnections(Data1,	Flags.GetFlagValue(_PhraseNoun1));
	If RetCode = _NewLocationDiscardTextCode Then
	Begin
		NewLocation := False;	{we don't want this here}
		DoMove := _Succeeded
	End Else Begin
		DoMove := _Failed;
	End
End;	{DoMove}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoGoto(Data1 : Word);
Begin
	Flags.SetFlagValue(_PlayerLocation,Data1)
End;	{DoGoto}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoWeight(Data1 : Word);
{calculate the total weight of everything carried by the player - i.e.
recursively check all the containers he carries, the stuff worn, etc.  Put the
result in the flag specified}
Var
	TotalWeight : LongInt;
	Index : Word;
	ThisObject, ThisObject2 : GameObject;
Begin
	TotalWeight := 0;
	For Index := 0 to Objects.NumberOfObjects -1 Do
	Begin
		ThisObject := Objects.GetObject(Index);
		{if obj is worn or carried, then add its weight to the total}
		If ((ThisObject.ObjCurrentLocation = _CarriedLoc) Or
			(ThisObject.ObjCurrentLocation = _WornLoc)) Then
			TotalWeight := TotalWeight + ThisObject.ObjWeight;

		{if obj is in a container, and it is worn or carried, then add its
		weight to the total}
		If Objects.FindObject(ThisObject.ObjCurrentLocation) = True Then
		Begin
			ThisObject2 := Objects.GetObject(ThisObject.ObjCurrentLocation);
			If (((ThisObject2.ObjCurrentLocation = _CarriedLoc) Or
				(ThisObject2.ObjCurrentLocation = _WornLoc)) And
				(ThisObject2.ObjContainer = True)) Then
				TotalWeight := TotalWeight + ThisObject.ObjWeight;
		End;
	End;	{For Index}

	If TotalWeight < 65536 Then Flags.SetFlagValue(Data1, TotalWeight)
	Else Flags.SetFlagValue(Data1, 65535);
End;	{DoWeight}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoPrint(Data1 : Word);
Var
	Temp : Array[0..6] of Char;
Begin
	TestUnit.AddText(StrPCopy(Temp,IntToStr(Data1)), False);	{print the var, no newline}
End;	{DoPrint}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoMes(Data1 : Word);
{print the message specified - no newline}
Var
	ListIndex : Word;
	ThisMessage : MGameMessage;
Begin
	ListIndex := FindMessage(Data1);
	ThisMessage := MessageList.Items[ListIndex];
	TestUnit.AddText(ThisMessage.Message.Text, False);
End;	{DoMes}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoMessage(Data1 : Word);
{print the message specified - with newline}
Var
	ListIndex : Word;
	ThisMessage : MGameMessage;
Begin
	ListIndex := FindMessage(Data1);
	ThisMessage := MessageList.Items[ListIndex];
	TestUnit.AddText(ThisMessage.Message.Text, True);
End;	{DoMessage}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoIntMess(Data1 : Word) : Word;
Var
	ErrorMess : String;
	E2Mess : AnsiString;
	Index : Integer;
	ListIndex : Word;
	ThisObject : GameObject;
	TempMess : AnsiString;
	OName, FirstWord, Rest : String;
	TempIndex, TIndex2 : Integer;
Begin
	ErrorMess := IntMessages.GetMessage(Data1);
	E2Mess := '';
	For Index := 1 to Length(ErrorMess) Do
	Begin
		If ErrorMess[Index] = '_' Then
		Begin
			ListIndex := Objects.GetObjectFromNnAndAdj(
									Flags.GetFlagValue(_PhraseNoun1),
									Flags.GetFlagValue(_PhraseAdjective1));
			If ListIndex <> 65535 Then
			Begin
				ThisObject := Objects.GetObject(ListIndex);
				OName := ThisObject.ObjShortName;
				FirstWord := '';
				Rest := '';
				For TempIndex := 1 to Length(OName) Do
				Begin
					If OName[TempIndex] = ' ' Then
					Begin
						If ((FirstWord = 'A') Or
							(FirstWord = 'AN') Or
							(FirstWord = 'SOME')) Then
						Begin
							For TIndex2 := TempIndex+1 To Length(OName) Do
								Rest := Rest + OName[TIndex2];
							TempMess := Rest;
							E2Mess := E2Mess +TempMess;
							Break
						End Else Begin
							TempMess := ThisObject.ObjShortName;
							E2Mess := E2Mess + TempMess;
							Break;
						End;
					End Else Begin
						FirstWord := FirstWord + UpCase(OName[TempIndex]);
					End;
				End;
			End Else Begin
				E2Mess := E2Mess + '_';
			End;
		End Else
		If ErrorMess[Index] = '&' Then
		Begin
			ListIndex := Objects.GetObjectFromNnAndAdj(
									Flags.GetFlagValue(_PhraseNoun2),
									Flags.GetFlagValue(_PhraseAdjective2));
			If ListIndex <> 65535 Then
			Begin
				ThisObject := Objects.GetObject(ListIndex);
				OName := ThisObject.ObjShortName;
				FirstWord := '';
				Rest := '';
				For TempIndex := 1 to Length(OName) Do
				Begin
					If OName[TempIndex] = ' ' Then
					Begin
						If ((FirstWord = 'A') Or
							(FirstWord = 'AN') Or
							(FirstWord = 'SOME')) Then
						Begin
							For TIndex2 := TempIndex +1 To Length(OName) Do
								Rest := Rest + OName[TIndex2];
							TempMess := Rest;
							E2Mess := E2Mess + TempMess;
							Break
						End Else Begin
							TempMess := ThisObject.ObjShortName;
							E2Mess := E2Mess + TempMess;
							Break;
						End;
					End Else Begin
						FirstWord := FirstWord + UpCase(OName[TempIndex]);
					End;
				End;
			End Else Begin
				E2Mess := E2Mess + '&';
			End;
		End Else Begin
			TempMess := ErrorMess[Index];
			E2Mess := E2Mess + TempMess;
		End;
	End;

	TestUnit.AddText(E2Mess, True);
End;	{DoIntMess}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoBG(Data1 : Word);
Begin
	Case Data1 Of
		1 : TestUnit.Memo1.Color := clBlack;
		2 : TestUnit.Memo1.Color := clMaroon;
		3 : TestUnit.Memo1.Color := clGreen;
		4 : TestUnit.Memo1.Color := clOlive;
		5 : TestUnit.Memo1.Color := clNavy;
		6 : TestUnit.Memo1.Color := clPurple;
		7 : TestUnit.Memo1.Color := clTeal;
		8 : TestUnit.Memo1.Color := clGray;
		9 : TestUnit.Memo1.Color := clSilver;
		10 : TestUnit.Memo1.Color := clRed;
		11 : TestUnit.Memo1.Color := clLime;
		12 : TestUnit.Memo1.Color := clYellow;
		13 : TestUnit.Memo1.Color := clBlue;
		14 : TestUnit.Memo1.Color := clFuchsia;
		15 : TestUnit.Memo1.Color := clAqua;
		else TestUnit.Memo1.Color := clWhite;
	End;
End;	{DoBG}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoFG(Data1 : Word);
Begin
	Case Data1 Of
		1 : TestUnit.Memo1.Font.Color := clBlack;
		2 : TestUnit.Memo1.Font.Color := clMaroon;
		3 : TestUnit.Memo1.Font.Color := clGreen;
		4 : TestUnit.Memo1.Font.Color := clOlive;
		5 : TestUnit.Memo1.Font.Color := clNavy;
		6 : TestUnit.Memo1.Font.Color := clPurple;
		7 : TestUnit.Memo1.Font.Color := clTeal;
		8 : TestUnit.Memo1.Font.Color := clGray;
		9 : TestUnit.Memo1.Font.Color := clSilver;
		10 : TestUnit.Memo1.Font.Color := clRed;
		11 : TestUnit.Memo1.Font.Color := clLime;
		12 : TestUnit.Memo1.Font.Color := clYellow;
		13 : TestUnit.Memo1.Font.Color := clBlue;
		14 : TestUnit.Memo1.Font.Color := clFuchsia;
		15 : TestUnit.Memo1.Font.Color := clAqua;
		else TestUnit.Memo1.Font.Color := clWhite;
	End;
End;	{DoFG}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoListAt(Data1 : Word);
Var
	First : Boolean;
	Index : Word;
	ThisObject : GameObject;
	P : PChar;
Begin
	Getmem(P, 51);

	First := True;

	For Index := 0 To Objects.NumObjects -1 Do
	Begin
		ThisObject := Objects.GetObjectAtIndex(Index);
		If ((ThisObject.ObjCurrentLocation = Data1) And
			(ThisObject.ObjInvisible = False)) Then
		Begin
			If First = True Then First := False;
			StrPCopy(P, ThisObject.ObjShortName);
			TestUnit.AddText(P, True);
		End;	{is object here}
	End;	{For}

	If First = True Then DoIntMess(_CarryingMessage2);

	FreeMem(P, 51);
End;	{DoListAt}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoPause(Data1 : Word);
Var
	LongIndex : LongInt;
Begin
	For LongIndex := 1 to Data1* 100 Do
	Begin
		{primitive pause loop}
	End;
End;	{DoPause}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoTable(Data1, Data2 : Word) : Word;
Begin
{doesn't actually do anything in this implementation.  Handled by calling
routine - execentry}
End;	{DoTable}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoDoAll(Data1 : Word) : Boolean;
Var
	First : Boolean;
	PhNoun1, PhAdj1, PhNoun2, PhAdj2 : Word;
	Index : Word;
	ThisObject : GameObject;
	MatchNoun, MatchAdj, MatchNoun2, MatchAdj2 : Boolean;
	TempNoun, TempAdj : Word;
Begin
	First := True;	{so we know if we did anything}

	PhNoun1 := Flags.GetFlagValue(_PhraseNoun1);
	PhAdj1 := Flags.GetFlagValue(_PhraseAdjective1);
	PhNoun2 := Flags.GetFlagValue(_PhraseNoun2);
	PhAdj2 := Flags.getFlagValue(_PhraseAdjective2);

	If PhNoun1 <> 0 Then
		For Index := 0 To Objects.NumberOfObjects -1 Do
		Begin
			ThisObject := Objects.GetObjectAtIndex(Index);

			If ThisObject.ObjNoun = PhNoun1 Then
					MatchNoun := True;
			If ((PhAdj1 = 0) Or (ThisObject.ObjAdjective = PhAdj1)) Then
					MatchAdj := True;

			If ((PhNoun2 <> 0) And (ThisObject.ObjNoun = PhNoun2)) Then
					MatchNoun2 := True;
			If ((PhAdj2 = 0) Or (ThisObject.ObjAdjective = PhAdj2)) Then
					MatchAdj2 := True;

			If MatchNoun = False Then MatchAdj := False;
			If MatchNoun2 = False Then MatchAdj2 := False;

			If ((MatchNoun = True) And (MatchAdj = True) And
				(MatchNoun2 = False) And (MatchAdj2 = False)) Then
			Begin
				If First = True Then First := False;
				TempNoun := Flags.GetFlagvalue(_PhraseNoun1);
				TempAdj := Flags.GetFlagValue(_PhraseAdjective1);
				Flags.SetFlagValue(_PhraseNoun1, ThisObject.ObjNoun);
				Flags.SetFlagValue(_PhraseAdjective1, ThisObject.ObjAdjective);
				DoAllLoop := True;
				ProcessActionTables(3,True);
			End;
		End;

	If First = True Then DoDoAll := _Failed;	{used here to show that nothing
												happened}
End;	{DoDoAll}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoSwap(Data1, Data2 : Word) : Word;
Var
	Obj1, Obj2 : GameObject;
Begin
	Obj1 := Objects.GetObject(Data1);
	Obj2 := Objects.getObject(Data2);
	Objects.SetObjectLocation(Data1,Obj2.ObjCurrentLocation);
	Objects.SetObjectLocation(Data2,Obj1.ObjCurrentLocation);
End;	{DoSwap}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoPlace(Data1, Data2 : Word) : Word;
Var
	ThisObject : GameObject;
Begin
	ThisObject := Objects.GetObject(Data1);
	If ((ThisObject.ObjCurrentLocation = _CarriedLoc) And
		(Data2 <> _CarriedLoc)) Then
		Flags.SetFlagValue(_ObjectsCarried, Flags.GetFlagValue(_ObjectsCarried) -1);

	If ((ThisObject.ObjCurrentLocation = _WornLoc) And
		(Data2 <> _WornLoc)) Then
		Flags.SetFlagValue(_ObjectsWorn, Flags.GetFlagValue(_ObjectsWorn) -1);

	Objects.SetObjectLocation(Data1, Data2);
End;	{DoPlace}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoPutIn(Data1, Data2 : Word) : Boolean;
Var
	ThisObject : GameObject;
	PlayerLoc : Word;
Begin
	ThisObject := Objects.GetObject(Data2);
	PlayerLoc := Flags.GetFlagValue(_PlayerLocation);

	If ThisObject.ObjContainer = False Then
	Begin
		DoIntMess(_CantPutInNotContainer);
		DoPutIn := _Failed;
		Exit;
	End;	{Is obj a container}

	If ThisObject.ObjCurrentLocation = _WornLoc Then
	Begin
		DoIntMess(_CantWearingItMessage);
		DoPutIn := _Failed;
		Exit;
	End;	{is object worn}

	If ThisObject.ObjCurrentLocation = PlayerLoc Then
	Begin
		DoIntMess(_DontHaveItMessage);
		DoPutIn := _Failed;
		Exit;
	End;	{is object at location of player?}

	If ThisObject.ObjCurrentLocation <> _CarriedLoc Then
	Begin
		DoIntMess(_DontHaveOneMessage);
		DoPutIn := _Failed;
		Exit;
	End;

	{get to here, we can put object in container!}

	Objects.SetObjectLocation(Data1, Data2);
	Flags.SetFlagValue(_ObjectsCarried, Flags.GetFlagValue(_ObjectsCarried) - 1);
	DoIntMess(_PutInMessage);
	DoPutIn := _Succeeded;
End;	{DoPutIn}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoTakeOut(Data1, Data2 : Word) : Boolean;
Var
	ThisObject, ThisContainer : GameObject;
	PlayerLoc, PlayerObjects : Word;
	TempFlagVal : Word;	{in order to re-use code, se use the DoWeight procedure
						to get the total weight carried - but it sets a flag, so
						we copy the flag val, get the weight, and put the flag
						value back again}
	TotalWeight : Word;
Begin
	ThisObject := Objects.GetObject(Data1);
	ThisContainer := Objects.GetObject(Data2);
	PlayerLoc := Flags.GetFlagValue(_PlayerLocation);
	PlayerObjects := Flags.GetFlagValue(_ObjectsCarried);


	{is container really a container?}
	If ThisContainer.ObjContainer = False Then
	Begin
		DoIntMess(_CantTakeOutNotContainerMessage);
		DoTakeOut := _Failed;
		Exit;
	End;	{if object (container) is container}

	{is object carried or worn?}
	If ((ThisObject.ObjCurrentLocation = _WornLoc) Or
		(ThisObject.ObjCurrentLocation = _CarriedLoc)) Then
	Begin
		DoIntMess(_AlreadyHaveMessage);
		DoTakeOut := _Failed;
		Exit;
	End;	{if object (in container) is worn or carried}

	{is object at this location?}
	If (ThisObject.ObjCurrentLocation = PlayerLoc) Then
	Begin
		DoIntMess(_ObjNotInObjMessage);
		DoTakeOut := _Failed;
		Exit;
	End;	{if object (in container) is at the player's location}

	{is object in container?}
	If (ThisObject.ObjCurrentLocation <> Data2) Then
	Begin
		DoIntMess(_NotOneInObjMessage);
		DoTakeOut := _Failed;
		Exit;
	End;	{is object (in container) in the container?}

	{if container is not carried or worn, and total weight, plus weight of new
	object, would be too much, say so}
	If ((ThisContainer.ObjCurrentLocation <> _CarriedLoc) And
		(ThisContainer.ObjCurrentLocation <> _WornLoc)) Then
	Begin
		TempFlagVal := Flags.GetFlagValue(437);	{copy the temp flag val}
		DoWeight(437);
		TotalWeight := Flags.GetFlagValue(437);
		Flags.SetFlagValue(437, TempFlagVal);	{copy the temp flag back}
		If (TotalWeight + ThisObject.ObjWeight) < MaxWt Then
		Begin
			DoIntMess(_ObjTooHeavyToTakeOut);
			DoTakeOut := _Failed;
			Exit;
		End;
	End;

	{is player carrying too many objects?}
	If PlayerObjects >= MaxObj Then
	Begin
		DoIntMess(_CantTakeOutMessage);
		DoTakeOut := _Failed;
		Exit;
	End;

	{get to here, then we can take obj out of container!}
	Objects.SetObjectLocation(Data1, _Carriedloc);
	Flags.SetFlagValue(_ObjectsCarried, Flags.GetFlagValue(_ObjectsCarried) + 1);
	DoIntMess(_TakeOutMessage);
	DoTakeOut := _Succeeded;
End;	{DoTakeOut}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoCopyOO(Data1, Data2 : Word) : Word;
Begin
	Objects.SetObjectLocation(Data2, Objects.GetObjectLocation(Data1));
	DoCopyOO := _AllOKCode;
End;	{DoCopyOO}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoCopyOF(Data1, Data2 : Word) : Word;
Var
	ThisObject : GameObject;
Begin
	ThisObject := Objects.GetObject(Data1);
	Flags.SetFlagValue(Data2, ThisObject.ObjCurrentLocation);
	DoCopyOF := _AllOKCode;
End;	{DoCopyOF}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoCopyFO(Data1, Data2 : Word) : Word;
Begin
	If Data1 > 65500 Then Objects.SetObjectLocation(Data2, 65500)
	Else Objects.SetObjectLocation(Data2, Flags.GetFlagValue(Data1));
	DoCopyFO := _AllOKCode;
End;	{DoCopyFO}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoPlus(Data1, Data2 : Word) : Word;
Var
	Val : LongInt;
Begin
	Val := Flags.GetFlagValue(Data1) + Data2;
	If Val > 65500 Then Val := 65500;
	Flags.SetFlagValue(Data1, Val);
	DoPlus := _AllOKCode;
End;	{DoPlus}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoMinus(Data1, Data2 : Word) : Word;
Var
	Val : LongInt;
Begin
	Val := Flags.GetFlagValue(Data1) - Data2;
	If Val < 0 Then Val := 0;
	Flags.SetFlagValue(Data1, Val);
	DoMinus := _AllOKCode;
End;	{DoMinus}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoAdd(Data1, Data2 : Word) : Word;
Var
	Val : LongInt;
Begin
	Val := Flags.GetFlagValue(Data2) + Flags.GetFlagValue(Data1);
	If Val > 65500 Then Val := 65500;
	Flags.SetFlagValue(Data2, Val);
	DoAdd := _AllOKCode;
End;	{DoAdd}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoSub(Data1, Data2 : Word) : Word;
Var
	Val : LongInt;
Begin
	Val := Flags.GetFlagValue(Data2) - Flags.GetFlagValue(Data1);
	If Val < 0 Then Val := 0;
	Flags.SetFlagValue(Data2, Val);
	DoSub := _AllOKCode;
End;	{DoSub}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoCopyFF(Data1, Data2 : Word) : Word;
Begin
	Flags.SetFlagValue(Data2, Flags.getFlagValue(Data1));
	DoCopyFF := _AllOKCode;
End;	{DoCopyFF}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure DoBeep;
Begin
	MessageBeep(0);
End;	{DoBeep}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoAbility(Data1, Data2 : Word) : Word;
Begin
	MaxWt := Data1;
	MaxObj := Data2;
	DoAbility := _AllOKCode;
End;	{DoAbility}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoExamine(Data1 : Word) : Boolean;
Var
	ThisObject : GameObject;
	PlayerLoc : Word;
Begin
	PlayerLoc := Flags.GetFlagValue(_PlayerLocation);
	ThisObject := Objects.GetObject(Data1);
	If ((ThisObject.ObjCurrentLocation = _CarriedLoc) Or
		(ThisObject.ObjCurrentLocation = _WornLoc) Or
		(ThisObject.ObjCurrentLocation = PlayerLoc)) Then
	Begin
		TestUnit.AddText(ThisObject.ObjDescription, True);
		DoExamine := _Succeeded;
	End Else Begin
		DoIntMess(_IsntOneHereMessage);
		DoExamine:= _Failed;
	End;
End;	{DoExamine}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoAutoE : Boolean;
Var
	ObjNum : Word;
	RetCode : Boolean;
Begin
	If Flags.GetFlagValue(_PhraseNoun1) <> 0 Then
	Begin
		ObjNum := Objects.GetObjectFromNnAndAdj(Flags.GetFlagValue(_PhraseNoun1),
										Flags.GetFlagValue(_PhraseAdjective1));
		If ((ObjNum > 0) And (ObjNum < 65501)) Then	{valid object number}
		Begin
			RetCode := DoExamine(ObjNum);
			DoAutoE := RetCode;
		End Else Begin
			If (Objects.NumObjects > 0) Then
			Begin
				DoIntMess(_IsntOneHereMessage);
				DoAutoE := _Failed
			End Else Begin
				DoIntMess(_CantDoMessage);
				DoAutoE := _Failed;
			End
		End;
	End Else Begin
		DoIntMess(_ObjNotKnownMessage);
		DoAutoE := _Failed;
	End;
End;	{DoAutoE}

Procedure DoLet(Data1, Data2 : Word);
Begin
	Flags.SetFlagValue(Data1, Data2);
End;

end.
