unit Actions;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  ExtCtrls, Forms, Buttons, ActStuff, EntrNum, ViewInfo, StdCtrls,
  NewEntry, VcbStuff, Debug, InputEnt, Text2Num, FlagDef;

type
  TActDlg = class(TForm)
	NewTable: TBitBtn;
	SelTable: TBitBtn;
	DelTable: TBitBtn;
    ViewTable: TBitBtn;
	AddEntry: TBitBtn;
	ModEntry: TBitBtn;
	DelEntry: TBitBtn;
    ViewEntries: TBitBtn;
	ExitBtn: TBitBtn;
	Bevel1: TBevel;
	Label1: TLabel;
	Label2: TLabel;
	Bevel2: TBevel;
	procedure DelTableClick(Sender: TObject);
	procedure SelTableClick(Sender: TObject);
	procedure ViewTableClick(Sender: TObject);
	procedure AddEntryClick(Sender: TObject);
	procedure DelEntryClick(Sender: TObject);
	procedure ModEntryClick(Sender: TObject);
	procedure ViewEntriesClick(Sender: TObject);
	procedure FormShow(Sender: TObject);
	procedure FormCreate(Sender: TObject);
	procedure NewTableClick(Sender: TObject);
	procedure FormDestroy(Sender: TObject);
  end;

var
	ActDlg: TActDlg;
	TableList : TList;
	TableCount : Word;
	CurrentTable : Word;

implementation

uses MatchDlg;

{$R *.DFM}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                   Functions start here!                           * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }




{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TActDlg.NewTableClick(Sender: TObject);
Var
	TableNumber : Word;
	NewTable : MGameTable;
	CaptionText : Array[0..14] of Char;
begin
	TableNumber := GetFirstFreeTableNumber;

	If TableNumber = _ObjectNotFound Then	{too many tables}
	Begin
		Application.MessageBox(
					'This game already contains 65500 Action'+#13+#10+
					'Tables, which is the maximum allowed.'+#13+#10+#10+
					'A new table cannot be created.',
					'Error',
					MB_OK + MB_IconExclamation);
	End Else Begin
		NewTable := MGameTable.Create(TableNumber);		{create the table}
		AddTableToList(TableList, NewTable);		{add table to list}
		CurrentTable := TableNumber;
		StrPCopy(CaptionText,'Table : '+IntToStr(TableNumber));
		Application.MessageBox(
					'Table Created'+#13+#10+
					'The new table is now the CURRENT table.',
					CaptionText,
					MB_OK + MB_IconInformation);
		Label1.Caption := 'Current Table : '+IntToStr(CurrentTable);
		If CurrentTable = 1 Then Label2.Caption := 'Usage : Before User Input'
		Else If CurrentTable = 2 Then Label2.Caption := 'Usage : After User Input'
		Else If CurrentTable = 3 Then Label2.Caption := 'Usage : Normal'
		Else Label2.Caption := 'Usage : User-Defined';
	End;	{If}
End;	{New Table}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

procedure TActDlg.DelTableClick(Sender: TObject);
Var
	ListIndex : Word;
    ThisTable : MGameTable;
begin
	EnterNumberDlg.Caption := 'Enter Table Number';
	EnterNumberDlg.Label1.Caption := 'Enter the number of the table you wish to delete:';
	If (EnternumberDlg.Showmodal) = idOK Then	{user pressed ok in enter number
													dialog box}
	Begin
		ListIndex := Findtable(EnterNumberDlg.SpinEdit1.Value);

		If (ListIndex <> _ObjectNotFound) Then
		Begin
			ThisTable := TableList.Items[ListIndex];

			If ThisTable.NumEntries <> 0 Then
			Begin
				Application.MessageBox('The table specified contains entries.'+#10+#10+#13+
										'Deletion of this table is not allowed.',
										'Notice',
										mb_OK + mb_ICONINFORMATION);
				Exit;
			End;

			TableList.Delete(ListIndex);

			Application.MessageBox('The table specified has been deleted',
									'Table deleted',
									mb_OK + mb_ICONINFORMATION);

		End Else Begin
			Application.MessageBox('The table specified does not exist',
									'Error',
									mb_OK + mb_ICONEXCLAMATION);
		End;	{if table exists}
	End;	{if enternumberdlg = idok}
end;	{DelTable}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TActDlg.SelTableClick(Sender: TObject);
Var
	CaptionText : Array[0..39] of Char;
Begin
	EnterNumberDlg.Caption := 'Enter Table Number';
    EnterNumberDlg.Label1.Caption := 'Enter the table number you wish to be the CURRENT table.';
	If (EnterNumberDlg.ShowModal = idOK) Then
	Begin
		If (FindTable(EnterNumberDlg.SpinEdit1.Value) <> _ObjectNotFound) Then	{Table Exists}
		Begin
			CurrentTable := EnterNumberDlg.SpinEdit1.Value;
			Label1.Caption := 'Current Table : '+IntToStr(CurrentTable);
			If CurrentTable = 1 Then Label2.Caption := 'Usage : Before User Input'
			Else If CurrentTable = 2 Then Label2.Caption := 'Usage : After User Input'
			Else If CurrentTable = 3 Then Label2.Caption := 'Usage : Normal'
			Else Label2.Caption := 'Usage : User-Defined';
			StrPCopy(CaptionText,'The current table is now table : '+IntToStr(CurrentTable));
			Application.MessageBox(
						CaptionText,
						'Table Selected',
						MB_OK + MB_IconInformation)
		End Else Begin
			Application.MessageBox('The table specified does not exist.',
									'Error',
									mb_OK + mb_ICONEXCLAMATION);
		End;	{If}
	End;	{If}
End;	{SelTable}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

procedure TActDlg.ViewTableClick(Sender: TObject);
Var
	Index : Word;	{Integer!}
	ThisTable : MGameTable;
	LineText : String;
begin
	If HowManyTables <> 0 Then
	Begin
		For Index := 0 to HowManyTables-1 Do
		Begin
			ThisTable := TableList.Items[Index];
			LineText :=IntToStr(ThisTable.TableNum) + #9 + #9 + #9 +
								IntToStr(ThisTable.NumEntries);
			ViewInfoDlg.Memo1.Lines.Add(LineText);
		End;	{For}

		ViewInfoDlg.ShowModal;

	End Else Begin
		Application.MessageBox('There are no tables in the game!',
								'View Tables',
								mb_OK + mb_ICONEXCLAMATION);
	End;	{if}
End;	{View Table}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TActDlg.AddEntryClick(Sender: TObject);
Var
	VerbVal : Word;
	NounVal : Word;
	TableEntry : MGameTableEntry;
	ErrorPosition : Integer;
	CurrTable : MGameTable;
Begin
	If (NewEntryDlg.ShowModal = id_OK) Then		{user pressed okay}
	Begin
		{NOTE THAT CHECKING THE DATA IN THE DIALOG BOX SHOULD BE CHECKED
		WHEN THE USER PRESSES THE OK BUTTON}

		DebugWindow.AddText('  Verb is '+NewEntryDlg.VerbBox.Text);
		DebugWindow.AddText('  Noun is '+NewEntryDlg.NounBox.Text);

		If NewEntryDlg.VerbBox.Text = '*' Then VerbVal := 0
		Else If NewEntryDlg.VerbBox.Text = '#' Then VerbVal := 65535
		Else VerbVal := GetWordValue(NewEntryDlg.VerbBox.Text);

		If NewEntryDlg.NounBox.Text = '*' Then NounVal := 0
		Else If NewEntryDlg.NounBox.Text = '#' Then NounVal := 65535
		Else NounVal := GetWordValue(NewEntryDlg.NounBox.Text);

		DebugWindow.AddText('  Verb value is '+IntToStr(VerbVal));
		DebugWindow.AddText('  Noun value is '+IntToStr(NounVal));

		EnterEntryDlg.Label2.Caption := '"'+NewEntryDlg.VerbBox.Text+' '+
										NewEntryDlg.NounBox.Text+'"'+
										' in table '+IntToStr(CurrentTable);
		If (EnterEntryDlg.ShowModal = id_OK) Then
		Begin
			{process the input, and create the new entry}
			TableEntry := ProcessInput(EnterEntryDlg.Edit1.Text,
										ErrorPosition,
										VerbVal,
										NounVal);	{process user input}
			If ErrorPosition = 0 Then
			Begin
				CurrTable := TableList.Items[FindTable(CurrentTable)];
				AddEntryToTable(CurrTable, TableEntry);
				Application.MessageBox('Entry added.',
										'Added',
										mb_ok + mb_ICONINFORMATION);
				EnterEntryDlg.Edit1.Text := '';
				NewEntryDlg.VerbBox.Text := '';	{clear the edit boxes}
				NewEntryDlg.NounBox.Text := '';

				SortActionTableList;
			End Else Begin
				MessageBeep(0);
			End;	{if error}
		End;

	End;	{If}
End;	{AddEntry}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TActDlg.DelEntryClick(Sender: TObject);
{get the verb and noun, check current table for match, check if more than one
match, if more than one, show each one in turn and prompt for delete. delete if
okay}
Var
	VerbVal, NounVal : Word;
	TEntry : MGameTableEntry;
	CondActCounter : Word;	{Integer!}
	NumCondActs : Word;
	VerbNum, NounNum : Word;	{Integer}
	ThisCondAct : MGameCondAct;
	ThisTokenNum : Integer;
	ThisData1Num, ThisData2Num : Word;
	ThisTokenString, ThisData1String, ThisData2String : String[11];
	VerbString, NounString : String[11];
	NumData : Integer;
	LineText : String;
	MatchCount, MatchCounter : Word;
Begin
	NewEntryDlg.Caption := 'Delete an Action Table Entry';
	NewEntryDlg.Label1.Caption := 'Enter the verb and noun for the entry to be deleted';
	If (NewEntryDlg.ShowModal = idOK) Then
	Begin
		If NewEntryDlg.VerbBox.Text = '*' Then VerbVal := 0
		Else If NewEntryDlg.VerbBox.Text = '#' Then VerbVal := 65535
		Else VerbVal := GetWordValue(NewEntryDlg.VerbBox.Text);

		If NewEntryDlg.NounBox.Text = '*' Then NounVal := 0
		Else If NewEntryDlg.NounBox.Text = '#' Then NounVal := 65535
		Else NounVal := GetWordValue(NewEntryDlg.NounBox.Text);

		MatchCount := CountMatchingEntries(VerbVal, NounVal);

		Case MatchCount Of
			0 : Begin	{no matches}
					Application.MessageBox(
						'There are no entries in this table with that Verb and Noun',
						'Notice',
						mb_OK + mb_IconInformation);
				End;

			Else Begin	{1 match only, or more than 1 match}
				MatchCounter := 0;
				Repeat
					MatchCounter := MatchCounter + 1;
					TEntry := GetEntryFromVerbAndNoun(VerbVal, NounVal, MatchCounter);
					If ((TEntry.Verb = 0) And
						(TEntry.Noun = 0) And
						(TEntry.NumCondActs = 0)) Then
					Begin
						{here, some error occurred retreiving the entry found}
						DebugWindow.AddText('DelEntry potentially failed after GetEntryFromVerbAndNoun')
					End Else Begin
						{here, we have the entry, so put the details in the box
						for the user to see}

						VerbNum := TEntry.Verb;
						NounNum := TEntry.Noun;
						If VerbNum = 0 Then VerbString := '*'
						Else If VerbNum = 65535 Then VerbString := '#'
						Else VerbString := GetWordFromVocab(VerbNum, Verb);

						If NounNum = 0 Then NounString := '*'
						Else If NounNum = 65535 Then NounString := '#'
						Else NounString := GetWordFromVocab(NounNum, Noun);

						NumCondActs := TEntry.NumCondActs;
						ThisCondAct := TEntry.TableEntry.Items[0];

						ThisTokenNum := ThisCondAct.CondAct.Token;
						ThisData1Num := ThisCondAct.CondAct.Data1;
						ThisData2Num := ThisCondAct.CondAct.Data2;
						ThisData1String := IntToStr(ThisData1Num);
						ThisData2String := IntToStr(ThisData2Num);

						If ThisTokenNum > 100 Then	{Action}
						Begin
							ThisTokenString := Text2Num.Actions[ThisTokenNum-100];
							NumData := StrToInt(ActDataVal[ThisTokenNum-100])
						End Else Begin
							ThisTokenString := Conditions[ThisTokenNum];
							NumData := StrToInt(CondDataVal[ThisTokenNum]);
						End;

						If NumData > 10 Then NumData := 2
						Else If NumData <> 0 Then NumData := 1
						Else NumData := 0;

						While Length(ThisTokenString) < 10 Do
							ThisTokenString := ThisTokenString + ' ';

						While Length(NounString) < 10 Do
							NounString := NounString + ' ';

						While Length(VerbString) < 10 Do
							VerbString := VerbString + ' ';

						LineText := VerbString + ' ' + NounString + ' ' +
									ThisTokenString + ' ';
						If NumData = 2 Then
							LineText := LineText + ThisData1String + ' ' + ThisData2String
						Else If NumData = 1 Then
							LineText := LineText + ThisData1String;

						MatchDialog.Memo1.Lines.Add(LineText);

						LineText := '';
						VerbString := '';
						NounString := '';

						If NumCondActs <> 1 Then
						Begin
							For CondActCounter := 1 to NumCondActs -1 Do
							Begin
								ThisCondAct := TEntry.TableEntry.Items[CondActCounter];
								ThisTokenNum := ThisCondAct.CondAct.Token;
								ThisData1Num := ThisCondAct.CondAct.Data1;
								ThisData2Num := ThisCondAct.CondAct.Data2;
								ThisData1String := IntToStr(ThisData1Num);
								ThisData2String := IntToStr(ThisData2Num);
								If ThisTokenNum > 100 Then	{Action}
								Begin
									ThisTokenString := Text2Num.Actions[ThisTokenNum-100];
									NumData := StrToInt(ActDataVal[ThisTokenNum-100])
								End Else Begin
									ThisTokenString := Conditions[ThisTokenNum];
									NumData := StrToInt(CondDataVal[ThisTokenNum]);
								End;

								While Length(ThisTokenString) < 10 Do
									ThisTokenString := ThisTokenString + ' ';

								While Length(NounString) < 10 Do
									NounString := NounString + ' ';

								While Length(VerbString) < 10 Do
									VerbString := VerbString + ' ';

								If NumData > 10 Then NumData := 2
								Else If NumData <> 0 Then NumData := 1
								Else NumData := 0;
								LineText := VerbString + ' ' + NounString + ' ' +
										ThisTokenString + ' ';
								If NumData = 2 Then
									LineText := LineText + ThisData1String + ' ' + ThisData2String
								Else If NumData = 1 Then
									LineText := LineText + ThisData1String;
								MatchDialog.Memo1.Lines.Add(LineText);
							End;	{for condactcounter}
						End;

						MatchDialog.Label1.Caption := NewEntryDlg.VerbBox.Text;
						MatchDialog.Label2.Caption := NewEntryDlg.NounBox.Text;
						If MatchDialog.ShowModal = idYes Then
						Begin
							DeleteEntryFromVerbAndNoun(VerbVal, NounVal, MatchCounter);
							MatchCounter := MatchCounter -1;
							MatchCount := MatchCount -1;
						End;	{user wants to delete the selection}
					End;	{If error}
				Until MatchCounter = MatchCount;	{repeat}
			End;
		End;	{Case}
	End;
	NewEntryDlg.Caption := 'NewActionTableEntry';
	NewEntryDlg.Label1.Caption := 'Enter the verb and noun for the new entry';
	NewEntryDlg.VerbBox.Text :='';
	NewEntryDlg.NounBox.Text := '';
End;	{DelEntry}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

procedure TActDlg.ModEntryClick(Sender: TObject);
begin
{hello}
end;	{ModEntry}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

procedure TActDlg.ViewEntriesClick(Sender: TObject);
{procedure to view the entries for the current table.}
Var
	CondActCounter, EntryCounter : Word;	{Integer!}
	ListIndex : Word;
	ThisTable : MGameTable;
	NumEntries, NumCondActs : Word;
	ThisEntry : MGameTableEntry;
	VerbNum, NounNum : Word;	{Integer}
	VerbString, NounString : String[10];
	ThisCondAct : MGameCondAct;
	ThisTokenNum : Integer;
	ThisData1Num, ThisData2Num : Word;
	ThisTokenString, ThisData1String, ThisData2String : String[11];
	NumData : Integer;
	LineText : String;
begin
	If TableCount = 0 Then
	Begin
		Application.MessageBox('There are no tables in the database!',
								'View Entries',
								mb_OK + mb_ICONINFORMATION);
		Exit;
	End;

	ListIndex := FindTable(CurrentTable);

	If ListIndex = _ObjectNotFound Then
	Begin
		Application.MessageBox('The ''Current'' Table does not exist, and has'+#13+#10+
								'been reset to the first table in the database.',
								'Notice',
								mb_OK + mb_ICONINFORMATION);
		ThisTable := TableList.Items[0];
		CurrentTable := ThisTable.TableNum;
		Exit;
	End;

	ThisTable := TableList.Items[ListIndex];

	NumEntries := ThisTable.NumEntries;

	If NumEntries <> 0 Then
	Begin
		For EntryCounter := 0 To NumEntries -1 Do
		Begin
			ThisEntry := ThisTable.Table.Items[EntryCounter];

			VerbNum := ThisEntry.Verb;
			NounNum := ThisEntry.Noun;
			If VerbNum = 0 Then VerbString := '*'
			Else If VerbNum = 65535 Then VerbString := '#'
			Else VerbString := GetWordFromVocab(VerbNum, Verb);

			If NounNum = 0 Then NounString := '*'
			Else If NounNum = 65535 Then NounString := '#'
			Else NounString := GetWordFromVocab(NounNum, Noun);

			NumCondActs := ThisEntry.NumCondActs;
			ThisCondAct := ThisEntry.TableEntry.Items[0];

			ThisTokenNum := ThisCondAct.CondAct.Token;
			ThisData1Num := ThisCondAct.CondAct.Data1;
			ThisData2Num := ThisCondAct.CondAct.Data2;
			ThisData1String := IntToStr(ThisData1Num);
			ThisData2String := IntToStr(ThisData2Num);

			If ThisTokenNum > 100 Then	{Action}
			Begin
				ThisTokenString := Text2Num.Actions[ThisTokenNum-100];
				NumData := StrToInt(ActDataVal[ThisTokenNum-100])
			End Else Begin
				ThisTokenString := Conditions[ThisTokenNum];
				NumData := StrToInt(CondDataVal[ThisTokenNum]);
			End;

			If NumData > 10 Then NumData := 2
			Else If NumData <> 0 Then NumData := 1
			Else NumData := 0;

			While Length(ThisTokenString) < 10 Do
				ThisTokenString := ThisTokenString + ' ';

			While Length(NounString) < 10 Do
				NounString := NounString + ' ';

			While Length(VerbString) < 10 Do
				VerbString := VerbString + ' ';

			LineText := VerbString + ' ' + NounString + ' ' +
						ThisTokenString + ' ';
			If NumData = 2 Then
				LineText := LineText + ThisData1String + ' ' + ThisData2String
			Else If NumData = 1 Then
				LineText := LineText + ThisData1String;

			ViewInfoDlg.Memo1.Lines.Add(LineText);

			LineText := '';
			VerbString := '';
			NounString := '';

			If NumCondActs <> 1 Then
			Begin
				For CondActCounter := 1 to NumCondActs -1 Do
				Begin
					ThisCondAct := ThisEntry.TableEntry.Items[CondActCounter];
					ThisTokenNum := ThisCondAct.CondAct.Token;
					ThisData1Num := ThisCondAct.CondAct.Data1;
					ThisData2Num := ThisCondAct.CondAct.Data2;
					ThisData1String := IntToStr(ThisData1Num);
					ThisData2String := IntToStr(ThisData2Num);
					If ThisTokenNum > 100 Then	{Action}
					Begin
						ThisTokenString := Text2Num.Actions[ThisTokenNum-100];
						NumData := StrToInt(ActDataVal[ThisTokenNum-100])
					End Else Begin
						ThisTokenString := Conditions[ThisTokenNum];
						NumData := StrToInt(CondDataVal[ThisTokenNum]);
					End;

					While Length(ThisTokenString) < 10 Do
						ThisTokenString := ThisTokenString + ' ';

					While Length(NounString) < 10 Do
						NounString := NounString + ' ';

					While Length(VerbString) < 10 Do
						VerbString := VerbString + ' ';

					If NumData > 10 Then NumData := 2
					Else If NumData <> 0 Then NumData := 1
					Else NumData := 0;
					LineText := VerbString + ' ' + NounString + ' ' +
							ThisTokenString + ' ';
					If NumData = 2 Then
						LineText := LineText + ThisData1String + ' ' + ThisData2String
					Else If NumData = 1 Then
						LineText := LineText + ThisData1String;
					ViewInfoDlg.Memo1.Lines.Add(LineText);
				End;	{for condactcounter}
			End;	{if numcondacts}
			ViewInfoDlg.Memo1.Lines.Add(' ');
		End;	{For EntryCounter}
		ViewInfoDlg.Memo1.Lines.Add('---------------------------------------');
		ViewInfoDlg.Caption := 'View Table Entries';
		ViewInfoDlg.Label1.Caption := '';
		ViewInfoDlg.Label2.Caption := '';
		ViewInfoDlg.ShowModal;
		ViewInfoDlg.Caption := 'View Table Information';
		ViewInfoDlg.Label1.Caption := 'Table Number:';
		ViewInfoDlg.Label2.Caption := 'Number of Entries:';
	End Else Begin
		Application.MessageBox('This table has no entries.',
								'View Entries',
								mb_OK + mb_ICONINFORMATION);
	End;	{if more than zero entries}
end;	{ViewEntries}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

procedure TActDlg.FormShow(Sender: TObject);
begin
	If TableCount = 0 Then
	Begin
		Application.MessageBox('There are no tables in this game yet.'+
								#10+#13+'Create a table before you can create entries',
								'Notice',
								mb_OK + mb_IconInformation);
	End Else Begin
		Label1.Caption := 'Current Table : '+IntToStr(CurrentTable);
		If CurrentTable = 1 Then Label2.Caption := 'Usage : Before User Input'
		Else If CurrentTable = 2 Then Label2.Caption := 'Usage : After User Input'
		Else If CurrentTable = 3 Then Label2.Caption := 'Usage : Normal'
		Else Label2.Caption := 'Usage : User-Defined';
	End;
end;	{FormShow}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

procedure TActDlg.FormCreate(Sender: TObject);
Var
	TableFile : File of Byte;
	TempByte : Byte;
	TableNumber, NumEntries, Verb, Noun, Data1, Data2, NumCondActs, EntryCounter, CondActCounter : Word;	{Integer!}
    Token : Integer;
	ThisTable : MGameTable;
	ThisEntry : MGameTableEntry;
    ThisCondAct : MGameCondAct;
begin
	TableList := TList.Create;	{Create a new instance of the list}
	TableCount := 0;			{currently no tables in the game}
	CurrentTable := 0;			{so there is no current table}

	If FileExists('Project.Tab') Then	{no point in trying to load a file
										that doesn't exist}
	Begin
		AssignFile(TableFile,'Project.Tab');	{this bit loads an existing}
		Reset(TableFile);						{Action Table file}
		While Not(Eof(TableFile)) Do
		Begin
			Read(TableFile, TempByte);
			TableNumber := TempByte;
			Read(TableFile, TempByte);
			TableNumber := TableNumber + (256*TempByte);

			Read(TableFile, TempByte);
			NumEntries := TempByte;
			Read(TableFile, TempByte);
			NumEntries := NumEntries + (256*TempByte);

			ThisTable := MGameTable.Create(TableNumber);

			For EntryCounter := 1 to NumEntries Do
			Begin
				Read(TableFile, TempByte);
				Verb := TempByte;
				Read(TableFile, TempByte);
				Verb := Verb + (256*TempByte);

				Read(TableFile, TempByte);
				Noun := TempByte;
				Read(TableFile, TempByte);
				Noun := Noun + (256*TempByte);

				Read(TableFile, TempByte);
				NumCondActs := TempByte;
				Read(TableFile, TempByte);
				NumCondActs := NumCondActs + (256*TempByte);

				ThisEntry := MGameTableEntry.Create(Verb, Noun);

				For CondActCounter := 1 to NumCondActs Do
				Begin
					Read(TableFile, TempByte);
					Token := TempByte;

					Read(TableFile, TempByte);
					Data1 := TempByte;
					Read(TableFile, TempByte);
					Data1 := Data1 + (256*TempByte);

					Read(TableFile, TempByte);
					Data2 := TempByte;
					Read(TableFile, TempByte);
					Data2 := Data2 + (256*TempByte);

					ThisCondAct := MGameCondAct.Create(Token, Data1, Data2);

					AddCondActToEntry(ThisEntry, ThisCondAct);
				End;	{For CondActCounter}

				AddEntryToTable(ThisTable, ThisEntry);
			End;	{For EntryCounter}

			AddTableToList(TableList, ThisTable);
			Inc(TableCount);
			If CurrentTable = 0 Then CurrentTable := TableNumber;
		End;
		CloseFile(TableFile);
	End;
end;	{FormCreate}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

procedure TActDlg.FormDestroy(Sender: TObject);
Var
	NumTables : Word;
	TableCounter, EntryCounter, CondActCounter : Word;
	ThisTableNumber : Word;
	NumEntries : Word;	{the number of entries in this table}
	NumCondActs : Word;	{the number of condacts in this entry}
	TempByte : Byte;
	TableFile : File of Byte;
	Verb, Noun : Word;	{Integer!}
	ThisCondAct : MGameCondAct;
	ThisTable : MGameTable;
    ThisEntry : MGameTableEntry;
begin
	NumTables := HowManyTables;

	AssignFile(TableFile,'Project.Tab');
	ReWrite(TableFile);

	If NumTables <> 0 Then
	Begin
		For TableCounter := 0 to NumTables -1 Do
		Begin
			ThisTableNumber := GetTableNumber(TableCounter);
			NumEntries := HowManyEntries(ThisTableNumber);

			{write the table number to the file}
			TempByte:=ThisTableNumber MOD 256;
			Write(TableFile,TempByte);
			TempByte:=ThisTableNumber DIV 256;
			Write(TableFile,TempByte);

			{write the number of entries in the table to the file}
			TempByte:=NumEntries MOD 256;
			Write(TableFile,TempByte);
			TempByte:=NumEntries DIV 256;
			Write(TableFile,TempByte);

			If NumEntries <> 0 Then
			Begin
				For EntryCounter := 0 to NumEntries-1 Do
				Begin
					NumCondActs := HowManyCondActs(ThisTableNumber, EntryCounter);
					Verb := GetVerb(ThisTableNumber, EntryCounter);
					Noun := GetNoun(ThisTableNumber, EntryCounter);

					{write the verb to the file}
					TempByte:=Verb MOD 256;
					Write(TableFile,TempByte);
					TempByte:=Verb DIV 256;
					Write(TableFile,TempByte);

					{write the noun to the file}
					TempByte:=Noun MOD 256;
					Write(TableFile,TempByte);
					TempByte:=Noun DIV 256;
					Write(TableFile,TempByte);

					{write the number of condacts in this entry to the file}
					TempByte:=NumCondActs MOD 256;
					Write(TableFile,TempByte);
					TempByte:=NumCondActs DIV 256;
					Write(TableFile,TempByte);

					If NumCondActs <> 0 Then
					Begin
						For CondActCounter := 0 to NumCondActs-1 Do
						Begin
							ThisCondAct := GetCondAct(ThisTableNumber,
														EntryCounter,
														CondActCounter);

							{write the token to the file}
							TempByte:=ThisCondAct.CondAct.Token;
							Write(TableFile,TempByte);

							{write the first piece of data to the file}
							TempByte:=ThisCondAct.CondAct.Data1 MOD 256;
							Write(TableFile,TempByte);
							TempByte:=ThisCondAct.CondAct.Data1 DIV 256;
							Write(TableFile,TempByte);

							{write the second piece of data to the file}
							TempByte:=ThisCondAct.CondAct.Data2 MOD 256;
							Write(TableFile,TempByte);
							TempByte:=ThisCondAct.CondAct.Data2 DIV 256;
							Write(TableFile,TempByte);
						End;	{For CondActCounter}
					End;	{If NumCondActs}
				End;	{For EntryCounter}
			End;	{if numentries}
		End;	{For TableCounter}
	End;	{If}

	CloseFile(TableFile);

	If HowManyTables <> 0 Then
	Begin
		For TableCounter := 0 to HowManyTables -1 Do
		Begin
			ThisTable := TableList.Items[TableCounter];
			If ThisTable.NumEntries <> 0 Then
			Begin
				For EntryCounter := 0 to ThisTable.NumEntries-1 Do
				Begin
					ThisEntry := ThisTable.Table.Items[EntryCounter];
					ThisEntry.TableEntry.Free;
				End;	{for entrycounter}
			End;	{if}
			ThisTable.Table.Free;
		End;	{for tablecounter}
	End;	{if}

	TableList.Free;
end;	{FormDestroy}

end.	{Actions}
