unit Cnctmenu;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ChngCnct, EntrNum, LocStuff, VcbStuff,
  Debug;

type
  TConnectMenu = class(TForm)
	ChngCnct: TBitBtn;
	ViewCnct: TBitBtn;
	ExitBtn: TBitBtn;
	procedure ChngCnctClick(Sender: TObject);
	procedure ViewCnctClick(Sender: TObject);
	procedure FormShow(Sender: TObject);
	procedure ExitBtnClick(Sender: TObject);
  private
	{ Private declarations }
  public
	{ Public declarations }
  end;

var
  ConnectMenu: TConnectMenu;

implementation

{$R *.DFM}

uses
	VocabMnu, LocMenu;

procedure TConnectMenu.ChngCnctClick(Sender: TObject);
var
	ThisLocation : MGameLocation;
	ThisWord : MGameVocab;
	TheseWords : Array[1..14] of String[10];
	TheseExits : Array[1..14] of Word;
	ListIndex : Word;
	Index : Word;
	P : Array[0..71] of Char;
begin
	DebugWindow.AddText('  Modify Connections clicked');
	If VocabList.Count = 0 Then
	Begin
		DebugWindow.AddText('    No words in database');

		Application.MessageBox('There are no words in this game yet!'+#10+#10+#13+
								'Connections cannot be defined until the game has vocabulary.',
								'Notice',
								mb_OK + mb_ICONINFORMATION);

		DebugWindow.AddText('  Return to menu');
		DebugWindow.AddText('');

		Exit;
	End;

	If (LocationList.Count = 0) Then
	Begin
		DebugWindow.AddText('    No locations in database');

		Application.MessageBox('There are no locations in this game yet!',
								'Notice',
								mb_OK + mb_ICONINFORMATION);

		DebugWindow.AddText('  Return to menu');
		DebugWindow.AddText('');

		Exit;
	End;

	EnterNumberDlg.Label1.Caption := 'Enter the location number to change connections.';
	EnterNumberDlg.ShowModal;
	If (EnterNumberDlg.ModalResult = idOK) Then	{user pressed okay}
	Begin
		DebugWindow.AddText('    Got location number from user');
		ListIndex := FindLocation(EnterNumberDlg.SpinEdit1.Value);
		If (ListIndex = 65535) Then
		Begin
			DebugWindow.AddText('      Invalid location number');

			Application.MessageBox('There is no location with that number',
									'Error',
									mb_OK + mb_ICONEXCLAMATION);

			DebugWindow.AddText('  Return to menu');
			DebugWindow.AddText('');

			Exit
		End Else Begin
			DebugWindow.AddText('      Valid location number');

			ThisLocation := LocationList.Items[ListIndex];

			DebugWindow.AddText('    Extract location''s exits');
			For Index := 1 to 14 Do
			Begin
				TheseExits[Index] := ThisLocation.Location.Exits[Index]
			End;
		End;
	End;
	{get to here, then TheseExits holds an array of the 14 exits from location specified}

	For Index := 1 to 14 Do
		TheseWords[Index] := '';

	DebugWindow.AddText('    Extract corresponding vocab');
	For Index := 0 to VocabList.Count-1 Do
	Begin
		ThisWord := VocabList.Items[Index];

		If ((ThisWord.Vocabulary.WordValue < 15) And
			(ThisWord.Vocabulary.WordType = Noun)) Then
		Begin
			TheseWords[ThisWord.Vocabulary.WordValue] := ThisWord.Vocabulary.Word;
		End;
	End;

	{get to here, then thesewords holds any nouns in the vocabulary with values of less than 14}

	{this next bit is basically 14 repetitions of the same bit of code....very ugly}
	{but there is no way of doing it using a loop - i tried!}

	ResetCCDialog;
	MakeCCDialogRO;

	DebugWindow.AddText('Set-up dialog box');
	If TheseWords[1] <> '' Then
	Begin
		ChngCnctDlg.First.Caption := TheseWords[1];
		ChngCnctDlg.Dest1.Value := TheseExits[1];
		ChngCnctDlg.Dest1.ReadOnly := False;
	End;

	If TheseWords[2] <> '' Then
	Begin
		ChngCnctDlg.Second.Caption := TheseWords[2];
		ChngCnctDlg.Dest2.Value := TheseExits[2];
		ChngCnctDlg.Dest2.ReadOnly := False;
	End;

	If TheseWords[3] <> '' Then
	Begin
		ChngCnctDlg.Third.Caption := TheseWords[3];
		ChngCnctDlg.Dest3.Value := TheseExits[3];
		ChngCnctDlg.Dest3.ReadOnly := False;
	End;

	If TheseWords[4] <> '' Then
	Begin
		ChngCnctDlg.Fourth.Caption := TheseWords[4];
		ChngCnctDlg.Dest4.Value := TheseExits[4];
		ChngCnctDlg.Dest4.ReadOnly := False;
	End;

	If TheseWords[5] <> '' Then
	Begin
		ChngCnctDlg.Fifth.Caption := TheseWords[5];
		ChngCnctDlg.Dest5.Value := TheseExits[5];
		ChngCnctDlg.Dest5.ReadOnly := False;
	End;

	If TheseWords[6] <> '' Then
	Begin
		ChngCnctDlg.Sixth.Caption := TheseWords[6];
		ChngCnctDlg.Dest6.Value := TheseExits[6];
		ChngCnctDlg.Dest6.ReadOnly := False;
	End;

	If TheseWords[7] <> '' Then
	Begin
		ChngCnctDlg.Seventh.Caption := TheseWords[7];
		ChngCnctDlg.Dest7.Value := TheseExits[7];
		ChngCnctDlg.Dest7.ReadOnly := False;
	End;

	If TheseWords[8] <> '' Then
	Begin
		ChngCnctDlg.Eigth.Caption := TheseWords[8];
		ChngCnctDlg.Dest8.Value := TheseExits[8];
		ChngCnctDlg.Dest8.ReadOnly := False;
	End;

	If TheseWords[9] <> '' Then
	Begin
		ChngCnctDlg.Ninth.Caption := TheseWords[9];
		ChngCnctDlg.Dest9.Value := TheseExits[9];
		ChngCnctDlg.Dest9.ReadOnly := False;
	End;

	If TheseWords[10] <> '' Then
	Begin
		ChngCnctDlg.Tenth.Caption := TheseWords[10];
		ChngCnctDlg.Dest10.Value := TheseExits[10];
		ChngCnctDlg.Dest10.ReadOnly := False;
	End;

	If TheseWords[11] <> '' Then
	Begin
		ChngCnctDlg.Eleventh.Caption := TheseWords[11];
		ChngCnctDlg.Dest11.Value := TheseExits[11];
		ChngCnctDlg.Dest11.ReadOnly := False;
	End;

	If TheseWords[12] <> '' Then
	Begin
		ChngCnctDlg.Twelfth.Caption := TheseWords[12];
		ChngCnctDlg.Dest12.Value := TheseExits[12];
		ChngCnctDlg.Dest12.ReadOnly := False;
	End;

	If TheseWords[13] <> '' Then
	Begin
		ChngCnctDlg.Thirteenth.Caption := TheseWords[13];
		ChngCnctDlg.Dest13.Value := TheseExits[13];
		ChngCnctDlg.Dest13.ReadOnly := False;
	End;

	If TheseWords[14] <> '' Then
	Begin
		ChngCnctDlg.Fourteenth.Caption := TheseWords[14];
		ChngCnctDlg.Dest14.Value := TheseExits[14];
		ChngCnctDlg.Dest14.ReadOnly := False;
	End;

	ChngCnctDlg.LocNumber.Caption := IntToStr(EnterNumberDlg.Spinedit1.Value);
	ChngCnctDlg.Caption := 'Change Connections';

	If (ChngCnctDlg.ShowModal = id_OK) Then
	Begin
		DebugWindow.AddText('    Verify dialog box contents');

		If ChngCnctDlg.Dest1.Value <> 0 Then
		Begin
			If FindLocation(ChngCnctDlg.Dest1.Value) <> 65535 Then
				ThisLocation.Location.Exits[1] := ChngCnctDlg.Dest1.Value
			Else Begin
				StrPCopy(P,'Destination for '+TheseWords[1]+' does not exist'+#10+#13+
							'It has been set to (nowhere)');
				Application.MessageBox(P, 'Error', mb_OK + mb_ICONEXCLAMATION);
			End
		End Else ThisLocation.Location.Exits[1] := 0;

		If ChngCnctDlg.Dest2.Value <> 0 Then
		Begin
			If FindLocation(ChngCnctDlg.Dest2.Value) <> 65535 Then
				ThisLocation.Location.Exits[2] := ChngCnctDlg.Dest2.Value
			Else Begin
				StrPCopy(P,'Destination for '+TheseWords[2]+' does not exist'+#10+#13+
							'It has been set to (nowhere)');
				Application.MessageBox(P, 'Error', mb_OK + mb_ICONEXCLAMATION);
			End
		End Else ThisLocation.Location.Exits[2] := 0;

		If ChngCnctDlg.Dest3.Value <> 0 Then
		Begin
			If FindLocation(ChngCnctDlg.Dest3.Value) <> 65535 Then
				ThisLocation.Location.Exits[3] := ChngCnctDlg.Dest3.Value
			Else Begin
				StrPCopy(P,'Destination for '+TheseWords[3]+' does not exist'+#10+#13+
							'It has been set to (nowhere)');
				Application.MessageBox(P, 'Error', mb_OK + mb_ICONEXCLAMATION);
			End
		End Else ThisLocation.Location.Exits[3] := 0;

		If ChngCnctDlg.Dest4.Value <> 0 Then
		Begin
			If FindLocation(ChngCnctDlg.Dest4.Value) <> 65535 Then
				ThisLocation.Location.Exits[4] := ChngCnctDlg.Dest4.Value
			Else Begin
				StrPCopy(P,'Destination for '+TheseWords[4]+' does not exist'+#10+#13+
							'It has been set to (nowhere)');
				Application.MessageBox(P, 'Error', mb_OK + mb_ICONEXCLAMATION);
			End;
		End Else ThisLocation.Location.Exits[4] := 0;

		If ChngCnctDlg.Dest5.Value <> 0 Then
		Begin
			If FindLocation(ChngCnctDlg.Dest5.Value) <> 65535 Then
				ThisLocation.Location.Exits[5] := ChngCnctDlg.Dest5.Value
			Else Begin
				StrPCopy(P,'Destination for '+TheseWords[5]+' does not exist'+#10+#13+
							'It has been set to (nowhere)');
				Application.MessageBox(P, 'Error', mb_OK + mb_ICONEXCLAMATION);
			End;
		End Else ThisLocation.Location.Exits[5] := 0;

		If ChngCnctDlg.Dest6.Value <> 0 Then
		Begin
			If FindLocation(ChngCnctDlg.Dest6.Value) <> 65535 Then
				ThisLocation.Location.Exits[6] := ChngCnctDlg.Dest6.Value
			Else Begin
				StrPCopy(P,'Destination for '+TheseWords[6]+' does not exist'+#10+#13+
							'It has been set to (nowhere)');
				Application.MessageBox(P, 'Error', mb_OK + mb_ICONEXCLAMATION);
			End;
		End Else ThisLocation.Location.Exits[6] := 0;

		If ChngCnctDlg.Dest7.Value <> 0 Then
		Begin
			If FindLocation(ChngCnctDlg.Dest7.Value) <> 65535 Then
				ThisLocation.Location.Exits[7] := ChngCnctDlg.Dest7.Value
			Else Begin
				StrPCopy(P,'Destination for '+TheseWords[7]+' does not exist'+#10+#13+
							'It has been set to (nowhere)');
				Application.MessageBox(P, 'Error', mb_OK + mb_ICONEXCLAMATION);
			End;
		End Else ThisLocation.Location.Exits[7] := 0;

		If ChngCnctDlg.Dest8.Value <> 0 Then
		Begin
			If FindLocation(ChngCnctDlg.Dest8.Value) <> 65535 Then
				ThisLocation.Location.Exits[8] := ChngCnctDlg.Dest8.Value
			Else Begin
				StrPCopy(P,'Destination for '+TheseWords[8]+' does not exist'+#10+#13+
							'It has been set to (nowhere)');
				Application.MessageBox(P, 'Error', mb_OK + mb_ICONEXCLAMATION);
			End;
		End Else ThisLocation.Location.Exits[8] := 0;

		If ChngCnctDlg.Dest9.Value <> 0 Then
		Begin
			If FindLocation(ChngCnctDlg.Dest9.Value) <> 65535 Then
				ThisLocation.Location.Exits[9] := ChngCnctDlg.Dest9.Value
			Else Begin
				StrPCopy(P,'Destination for '+TheseWords[9]+' does not exist'+#10+#13+
							'It has been set to (nowhere)');
				Application.MessageBox(P, 'Error', mb_OK + mb_ICONEXCLAMATION);
			End;
		End Else ThisLocation.Location.Exits[9] := 0;

		If ChngCnctDlg.Dest10.Value <> 0 Then
		Begin
			If FindLocation(ChngCnctDlg.Dest10.Value) <> 65535 Then
				ThisLocation.Location.Exits[10] := ChngCnctDlg.Dest10.Value
			Else Begin
				StrPCopy(P,'Destination for '+TheseWords[10]+' does not exist'+#10+#13+
							'It has been set to (nowhere)');
				Application.MessageBox(P, 'Error', mb_OK + mb_ICONEXCLAMATION);
			End;
		End Else ThisLocation.Location.Exits[10] := 0;

		If ChngCnctDlg.Dest11.Value <> 0 Then
		Begin
			If FindLocation(ChngCnctDlg.Dest11.Value) <> 65535 Then
				ThisLocation.Location.Exits[11] := ChngCnctDlg.Dest11.Value
			Else Begin
				StrPCopy(P,'Destination for '+TheseWords[11]+' does not exist'+#10+#13+
							'It has been set to (nowhere)');
				Application.MessageBox(P, 'Error', mb_OK + mb_ICONEXCLAMATION);
			End;
		End Else ThisLocation.Location.Exits[11] := 0;

		If ChngCnctDlg.Dest12.Value <> 0 Then
		Begin
			If FindLocation(ChngCnctDlg.Dest12.Value) <> 65535 Then
				ThisLocation.Location.Exits[12] := ChngCnctDlg.Dest12.Value
			Else Begin
				StrPCopy(P,'Destination for '+TheseWords[12]+' does not exist'+#10+#13+
							'It has been set to (nowhere)');
				Application.MessageBox(P, 'Error', mb_OK + mb_ICONEXCLAMATION);
			End;
		End Else ThisLocation.Location.Exits[12] := 0;

		If ChngCnctDlg.Dest13.Value <> 0 Then
		Begin
			If FindLocation(ChngCnctDlg.Dest13.Value) <> 65535 Then
				ThisLocation.Location.Exits[13] := ChngCnctDlg.Dest13.Value
			Else Begin
				StrPCopy(P,'Destination for '+TheseWords[13]+' does not exist'+#10+#13+
							'It has been set to (nowhere)');
				Application.MessageBox(P, 'Error', mb_OK + mb_ICONEXCLAMATION);
			End;
		End Else ThisLocation.Location.Exits[13] := 0;

		If ChngCnctDlg.Dest14.Value <> 0 Then
		Begin
			If FindLocation(ChngCnctDlg.Dest14.Value) <> 65535 Then
				ThisLocation.Location.Exits[14] := ChngCnctDlg.Dest14.Value
			Else Begin
				StrPCopy(P,'Destination for '+TheseWords[14]+' does not exist'+#10+#13+
							'It has been set to (nowhere)');
				Application.MessageBox(P, 'Error', mb_OK + mb_ICONEXCLAMATION);
			End;
		End Else ThisLocation.Location.Exits[14] := 0;

		DebugWindow.AddText('    Insert location into list');
		LocationList.Delete(ListIndex);
		LocationList.Add(ThisLocation);
		SortLocationList;
	End;	{user pressed ok in change connect dialog}
	MakeCCDialogRDWR;
	ResetCCDialog;
	DebugWindow.AddText('  Return to menu');
	DebugWindow.AddText('');
End;	{change connections}

procedure TConnectMenu.ViewCnctClick(Sender: TObject);
var
	Index : Word;	{Integer}
	ThisLocation : MGameLocation;
	TheseConns : Array[1..14] of Integer;
	Counter : Integer;
begin
	DebugWindow.AddText('  View locations clicked');

	If LocationList.Count = 0 Then
	Begin
		DebugWindow.AddText('    No locations in database');
		Application.MessageBox('There are no locations in the database',
								'View Connections',
								mb_OK + mb_ICONINFORMATION)
	End Else Begin
		DebugWindow.AddText('    Show locations');
		MakeCCDialogRO;	{make the dialog box read only}
		ChngCnctDlg.Caption := 'View Connections';
		For Index := 0 To LocationList.Count -1 Do
		Begin
			ThisLocation := LocationList.Items[Index];

			For Counter := 1 to 14 Do
				TheseConns[Counter] := ThisLocation.Location.Exits[Counter];

			If TheseConns[1] <> 0 Then
			Begin
				ChngCnctDlg.First.Caption := GetWordFromVocab(1,Noun);
				ChngCnctDlg.Dest1.Value := TheseConns[1];
			End;

			If TheseConns[2] <> 0 Then
			Begin
				ChngCnctDlg.Second.Caption := GetWordFromVocab(2,Noun);
				ChngCnctDlg.Dest2.Value := TheseConns[2];
			End;

			If TheseConns[3] <> 0 Then
			Begin
				ChngCnctDlg.Third.Caption := GetWordFromVocab(3,Noun);
				ChngCnctDlg.Dest3.Value := TheseConns[3];
			End;

			If TheseConns[4] <> 0 Then
			Begin
				ChngCnctDlg.Fourth.Caption := GetWordFromVocab(4,Noun);
				ChngCnctDlg.Dest4.Value := TheseConns[4];
			End;

			If TheseConns[5] <> 0 Then
			Begin
				ChngCnctDlg.Fifth.Caption := GetWordFromVocab(5,Noun);
				ChngCnctDlg.Dest5.Value := TheseConns[5];
			End;

			If TheseConns[6] <> 0 Then
			Begin
				ChngCnctDlg.Sixth.Caption := GetWordFromVocab(6,Noun);
				ChngCnctDlg.Dest6.Value := TheseConns[6];
			End;

			If TheseConns[7] <> 0 Then
			Begin
				ChngCnctDlg.Seventh.Caption := GetWordFromVocab(7,Noun);
				ChngCnctDlg.Dest7.Value := TheseConns[7];
			End;

			If TheseConns[8] <> 0 Then
			Begin
				ChngCnctDlg.Eigth.Caption := GetWordFromVocab(8,Noun);
				ChngCnctDlg.Dest8.Value := TheseConns[8];
			End;

			If TheseConns[9] <> 0 Then
			Begin
				ChngCnctDlg.Ninth.Caption := GetWordFromVocab(9,Noun);
				ChngCnctDlg.Dest9.Value := TheseConns[9];
			End;

			If TheseConns[10] <> 0 Then
			Begin
				ChngCnctDlg.Tenth.Caption := GetWordFromVocab(10,Noun);
				ChngCnctDlg.Dest10.Value := TheseConns[10];
			End;

			If TheseConns[11] <> 0 Then
			Begin
				ChngCnctDlg.Eleventh.Caption := GetWordFromVocab(11,Noun);
				ChngCnctDlg.Dest11.Value := TheseConns[11];
			End;

			If TheseConns[12] <> 0 Then
			Begin
				ChngCnctDlg.Twelfth.Caption := GetWordFromVocab(12,Noun);
				ChngCnctDlg.Dest12.Value := TheseConns[12];
			End;

			If TheseConns[13] <> 0 Then
			Begin
				ChngCnctDlg.Thirteenth.Caption := GetWordFromVocab(13,Noun);
				ChngCnctDlg.Dest13.Value := TheseConns[13];
			End;

			If TheseConns[14] <> 0 Then
			Begin
				ChngCnctDlg.Fourteenth.Caption := GetWordFromVocab(14,Noun);
				ChngCnctDlg.Dest14.Value := TheseConns[14];
			End;

			ChngCnctDlg.LocNumber.Caption := IntToStr(ThisLocation.Location.Value);
			If (ChngCnctDlg.ShowModal = idCancel) Then Break; {Index := LocationList.Count -1;}

			ResetCCDialog;	{clear the values to their defaults}
		End;	{for}
		MakeCCDialogRDWR;	{enable everything on the dialog box again}
	End;
	DebugWindow.AddText('  Return to menu');
	DebugWindow.AddText('');
end;	{view connections}

procedure TConnectMenu.FormShow(Sender: TObject);
begin
	ResetCCDialog;
end;

procedure TConnectMenu.ExitBtnClick(Sender: TObject);
begin
	DebugWindow.AddText('Return to Main Menu');
	DebugWindow.AddText('');
    Close;
end;

end.
