unit Condit;

interface

Uses
	Forms, Act, FlagDef, IntDlg, SysUtils, Dialogs, WinTypes, Test, Globals,
	Debug;

Function CheckQUIT : Boolean;
Function CheckAt(Data1 : Word) : Boolean;
Function CheckNotAt(Data1 : Word) : Boolean;
Function CheckAtGreater(Data1 : Word) : Boolean;
Function CheckAtLess(Data1 : Word) : Boolean;
Function CheckPresent(Data1 : Word) : Boolean;
Function CheckAbsent(Data1 : Word) : Boolean;
Function CheckWearing(Data1 : Word) : Boolean;
Function CheckNotWearing(Data1 : Word) : Boolean;
Function CheckCarrying(Data1 : Word) : Boolean;
Function CheckNotCarrying(Data1 : Word) : Boolean;
Function CheckZero(Data1 : Word) : Boolean;
Function CheckNotZero(Data1 : Word) : Boolean;
Function CheckOn(Data1 : Word) : Boolean;
Function CheckOff(Data1 : Word) : Boolean;
Function CheckAdject1(Data1 : Word) : Boolean;
Function CheckAdverb(Data1 : Word) : Boolean;
Function CheckPreposition(Data1 : Word) : Boolean;
Function CheckNoun2(Data1 : Word) : Boolean;
Function CheckAdject2(Data1 : Word) : Boolean;
Function CheckChance(Data1 : Word) : Boolean;
Function CheckAtBetween(Data1, Data2 : Word) : Boolean;
Function CheckIsAt(Data1, Data2 : Word) : Boolean;
Function CheckIsNotAt(Data1, Data2 : Word) : Boolean;
Function CheckEq(Data1, Data2 : Word) : Boolean;
Function CheckNotEq(Data1, Data2 : Word) : Boolean;
Function CheckGreater(Data1, Data2 : Word) : Boolean;
Function CheckLessThan(Data1, Data2 : Word) : Boolean;
Function CheckSame(Data1, Data2 : Word) : Boolean;
Function CheckNotSame(Data1, Data2 : Word) : Boolean;
Function CheckLess(Data1, Data2 : Word) : Boolean;
Function CheckMore(Data1, Data2 : Word) : Boolean;

implementation

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckQuit : Boolean;
Var
	ErrorString : Array[0..255] of Char;
	Button : Integer;
Begin
	StrPCopy(ErrorString,IntMessages.GetMessage(_QuitMessage));
	Button := Application.MessageBox(ErrorString,
								'QUIT',
								mb_YesNo);
	CheckQuit := (Button = idYES);

	{returns TRUE if yes, else false}
End;	{CheckQuit}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckAt(Data1 : Word) : Boolean;
Var
	Loc : Word;
Begin
	Loc := Flags.GetFlagValue(_PlayerLocation);
	CheckAt := (Loc = Data1);
End;	{CheckAt}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckNotat(Data1 : Word) : Boolean;
Begin
	If (CheckAt(Data1) = True) Then
		CheckNotAt := False
	Else
		CheckNotAt := True;
End;	{CheckNotat}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckAtGreater(Data1 : Word) : Boolean;
Var
	Loc : Word;
Begin
	Loc := Flags.GetFlagValue(_PlayerLocation);
	CheckAtGreater := (Loc > Data1);
End;	{CheckAtGreater}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckAtLess(Data1 : Word) : Boolean;
Var
	Loc : Word;
Begin
	Loc := Flags.GetFlagValue(_PlayerLocation);
	CheckAtLess := (Loc < Data1);
End;	{CheckAtLess}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckPresent(Data1 : Word) : Boolean;
Var
	ObjLoc : Word;
	Loc : Word;
Begin
	ObjLoc := Objects.GetObjectLocation(Data1);
	Loc := Flags.GetFlagValue(_PlayerLocation);
	If ((ObjLoc = _WornLoc) Or (ObjLoc = _CarriedLoc) Or (ObjLoc = Loc)) Then
		CheckPresent := True
	Else
		CheckPresent := False;
End;	{CheckPresent}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckAbsent(Data1 : Word) : Boolean;
Var
	ObjLoc : Word;
	Loc : Word;
Begin
	ObjLoc := Objects.GetObjectLocation(Data1);
	Loc := Flags.GetFlagValue(_PlayerLocation);
	If ((ObjLoc <> _WornLoc) And (ObjLoc <> _CarriedLoc) And (ObjLoc <> Loc)) Then
		CheckAbsent := True
	Else
		CheckAbsent := False;
End;	{CheckAbsent}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckWearing(Data1 : Word) : Boolean;
Var
	ObjLoc : Word;
Begin
	ObjLoc := Objects.GetObjectLocation(Data1);
	CheckWearing := (ObjLoc = _WornLoc);
End;	{CheckWearing}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckNotWearing(Data1 : Word) : Boolean;
Begin
	If (CheckWearing(Data1) = True) Then
		CheckNotWearing := False
	Else
		CheckNotWearing := True;
End;	{CheckNotWearing}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckCarrying(Data1 : Word) : Boolean;
Var
	ObjLoc : Word;
Begin
	ObjLoc := Objects.GetObjectLocation(Data1);
	CheckCarrying := (ObjLoc = _CarriedLoc);
End;	{CheckCarrying}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckNotCarrying(Data1 : Word) : Boolean;
Begin
	If (CheckCarrying(Data1) = True) Then
		CheckNotCarrying := False
	Else
		CheckNotCarrying := True;
End;	{CheckNotCarrying}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckZero(Data1 : Word) : Boolean;
Var
	FlagVal : Word;
Begin
	FlagVal := Flags.GetFlagValue(Data1);
	CheckZero := (FlagVal = 0);
End;	{CheckZero}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckNotZero(Data1 : Word) : Boolean;
Begin
	If (CheckZero(Data1) = True) Then
		CheckNotZero := False
	Else
		CheckNotZero := True;
End;	{CheckNotZero}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckOn(Data1 : Word) : Boolean;
Var
	BulbStatus : Boolean;
Begin
	BulbStatus := Bulbs.GetBulbStatus(Data1);
	CheckOn := BulbStatus;
End;	{CheckOn}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckOff(Data1 : Word) : Boolean;
Begin
	CheckOff := Not(CheckOn(Data1));
End;	{CheckOff}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckAdject1(Data1 : Word) : Boolean;
Var
	AdjVal : Word;
Begin
	AdjVal := Flags.GetFlagValue(_PhraseAdjective1);
	CheckAdject1 := (AdjVal = Data1);
End;	{CheckAdject1}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckAdverb(Data1 : Word) : Boolean;
Var
	AdvVal : Word;
Begin
	AdvVal := Flags.GetFlagValue(_PhraseAdverb);
	CheckAdverb := (AdvVal = Data1);
End;	{CheckAdverb}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckPreposition(Data1 : Word) : Boolean;
Var
	PrepVal : Word;
Begin
	PrepVal := Flags.GetFlagValue(_PhrasePreposition);
	CheckPreposition := (PrepVal = Data1);
End;	{CheckPreposition}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckNoun2(Data1 : Word) : Boolean;
Var
	N2Val : Word;
Begin
	N2Val := Flags.GetFlagValue(_PhraseNoun2);
	CheckNoun2 := (N2Val = Data1);
End;	{CheckNoun2}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckAdject2(Data1 : Word) : Boolean;
Var
	Adj2Val : Word;
Begin
	Adj2Val := Flags.GetFlagValue(_PhraseAdjective2);
	CheckAdject2 := (Adj2Val = Data1);
End;	{CheckAdject2}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckChance(Data1 : Word) : Boolean;
Var
	RandVal : Word;
Begin
	Randomize;
	RandVal := Random(100);
	CheckChance := (RandVal <= Data1);
End;	{CheckChance}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckAtBetween(Data1, Data2 : Word) : Boolean;
Var
	Loc : Word;
Begin
	Loc := Flags.GetFlagValue(_PlayerLocation);
	CheckAtBetween := ((Loc > Data1) And (Loc < Data2));
End;	{CheckAtBetween}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckIsAt(Data1, Data2 : Word) : Boolean;
Var
	ObjLoc : Word;
Begin
	ObjLoc := Objects.GetObjectLocation(Data1);
	DebugWindow.AddText('*** object '+IntToStr(Data1)+' is at location '+ IntToStr(ObjLoc)+ '***');
	CheckIsAt := (ObjLoc = Data2);
End;	{CheckIsAt}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckIsNotAt(Data1, Data2 : Word) : Boolean;
Begin
	If (CheckIsAt(Data1, Data2) = True) Then
		CheckIsNotAt := False
	Else
		CheckIsNotAt := True;
End;	{CheckIsNotAt}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckEq(Data1, Data2 : Word) : Boolean;
Var
	FlagVal : Word;
Begin
	FlagVal := Flags.getFlagValue(Data1);
	DebugWindow.AddText('***Flag '+IntToStr(Data1)+' equals '+IntToStr(FlagVal)+'***');
	CheckEq := (FlagVal = Data2);
End;	{CheckEq}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckNotEq(Data1, Data2 : Word) : Boolean;
Begin
	If (CheckEq(Data1, Data2) = True) Then
		CheckNotEq := False
	Else
		CheckNotEq := True;
End;	{CheckNotEq}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckGreater(Data1, Data2 : Word) : Boolean;
Var
	FlagVal : Word;
Begin
	FlagVal := Flags.GetFlagValue(Data1);
	CheckGreater := (FlagVal > Data2);
End;	{CheckGreater}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckLessThan(Data1, Data2 : Word) : Boolean;
Var
	FlagVal : Word;
Begin
	FlagVal := Flags.GetFlagValue(Data1);
	CheckLessThan := (FlagVal < Data2);
End;	{CheckLessThan}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckSame(Data1, Data2 : Word) : Boolean;
Var
	Flag1, Flag2 : Word;
Begin
	Flag1 := Flags.GetFlagValue(Data1);
	Flag2 := Flags.GetFlagValue(Data2);
	DebugWindow.AddText('*** Flag '+IntToStr(Data1)+' = '+IntToStr(Flag1)+
						', Flag '+IntToStr(Data2)+' = '+IntToStr(Flag2)+'***');
	CheckSame := (Flag1 = Flag2);
End;	{CheckSame}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckNotSame(Data1, Data2 : Word) : Boolean;
Begin
	If (CheckSame(Data1, Data2) = True) Then
		CheckNotSame := False
	Else
		CheckNotSame := True;
End;	{CheckNotSame}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckLess(Data1, Data2 : Word) : Boolean;
Var
	Val1, Val2 : Word;
Begin
	Val1 := Flags.GetFlagValue(Data1);
	Val2 := Flags.GetFlagValue(Data2);
	CheckLess := (Val1 < Val2);
End;	{CheckLess}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function CheckMore(Data1, Data2 : Word) : Boolean;
Var
	Val1, Val2 : Word;
Begin
	Val1 := Flags.GetFlagValue(Data1);
	Val2 := Flags.GetFlagValue(Data2);
	CheckMore := (Val1 > Val2);
End;	{CheckMore}

End.	{Condit}
