Unit Debug;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * *                                                                   * * * }
{ * * *  The purpose of this unit is to provide a window which will       * * *}
{* * *    show the internal workings of the program to the user -        * * * }
{ * * *   it will show the internal flow of things, and help in debugging * * *}
{* * *    both the game designer, and any adventures written using it.   * * * }
{ * * *                                                                   * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Interface

Uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

Type
  TDebugWindow = Class(TForm)
	Memo1: TMemo;
    FontDialog1: TFontDialog;
	Procedure FormResize(Sender: TObject);
	Procedure AddText(Text : String);
	procedure FormShow(Sender: TObject);
	procedure Memo1Click(Sender: TObject);
	procedure FormCreate(Sender: TObject);
	procedure Memo1DblClick(Sender: TObject);
  End;

Var
	DebugStatus : Boolean;
	DebugWindow : TDebugWindow;
	LineCount : Integer;

Implementation

{$R *.DFM}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                   Functions start here!                           * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }




{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
Procedure TDebugWindow.FormResize(Sender: TObject);
{Makes sure that the Memo component resizes when the window does}
Begin
	Memo1.Width := DebugWindow.Width - 25;
	Memo1.Height := DebugWindow.Height - 50;
	LineCount := Memo1.Height DIV (Memo1.Font.Height * -2 - Memo1.Font.Size);
{	AddText('lcount '+IntToStr(LineCount));
	AddText('fsize '+IntToStr(Memo1.Font.Size));
	AddText('height '+IntToStr(Memo1.Height));
	AddText('fheight '+IntToStr(Memo1.Font.Height));}
End;	{Resize}









Procedure TDebugWindow.AddText(Text : String);
Var
	NumLines : Integer;
Begin
	If DebugStatus = True Then
	Begin
		Memo1.Lines.Add(Text);

		NumLines := Memo1.Lines.Count;

		While NumLines > LineCount Do
		Begin
			Dec(NumLines);
			Memo1.Lines.Delete(0);
		End;
	End;
End;	{AddText}

procedure TDebugWindow.FormShow(Sender: TObject);
begin
	DebugWindow.Height := Screen.Height;
end;

procedure TDebugWindow.Memo1Click(Sender: TObject);
begin
	FontDialog1.Execute;
	Memo1.Font.Assign(FontDialog1.Font);
    DebugWindow.Resize;
end;

procedure TDebugWindow.FormCreate(Sender: TObject);
begin
	DebugStatus := True;
end;

procedure TDebugWindow.Memo1DblClick(Sender: TObject);
begin
	DebugStatus := Not(DebugStatus);
	If DebugStatus = True Then DebugWindow.Show
    Else DebugWindow.Hide;
end;

End.	{Debug}
