unit Delword;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
		StdCtrls, ExtCtrls, VcbStuff;

type
	TDelWordDlg = class(TForm)
		OKBtn: TBitBtn;
		CancelBtn: TBitBtn;
		Edit1: TEdit;
		Label1: TLabel;
		procedure OKBtnClick(Sender: TObject);
		procedure FormShow(Sender: TObject);
	private
		{ Private declarations }
	public
		{ Public declarations }
	end;

var
	DelWordDlg : TDelWordDlg;

implementation

uses
	VocabMnu;

{$R *.DFM}

{***************************************************************************}
procedure TDelWordDlg.OKBtnClick(Sender: TObject);
{
	When the user presses 'ok', check if the word entered is in the vocabulary.
	If it is, delete it, and tell the user that it has been deleted.
	If it isn't, report an error
}
var
	WordToDelete : String;
begin
	WordToDelete := DelWordDlg.Edit1.Text;
	If (FindWordInVocab(WordToDelete) = True) Then
	Begin
		If ((CheckObjects(WordToDelete) = True) And
			(CheckMovement(WordToDelete) = True) And
			(CheckActionTables(WordToDelete) = True)) Then
		Begin
			VocabList.Delete(GetPositionOfWord(WordToDelete));
			Application.MessageBox('Word Deleted',
									'Information',
									mb_OK + MB_ICONINFORMATION)
		End Else Begin
			Application.MessageBox('Word NOT Deleted',
									'Information',
									mb_OK + mb_ICONINFORMATION)
		End
	End Else Begin
		Application.MessageBox('Word NOT in Vocab',
								'Error',
								mb_OK + MB_ICONEXCLAMATION)
	End;
end;

{***************************************************************************}
procedure TDelWordDlg.FormShow(Sender: TObject);
{
	When the form is shown on the screen, make sure that the cursor is in the
	edit box.  Just done for neatness...the user can start typing straight away
}
begin
	Edit1.SetFocus;
end;

end.
