unit Exec;

interface

Uses
	ActStuff, TNames, Condit, Act, FlagDef, Globals, Debug, SysUtils;

	Function ExecEntry(ThisEntry: MGameTableEntry; Matching : Boolean) : Word;

implementation

Uses
	GameStuf;

Function ExecEntry(ThisEntry: MGameTableEntry; Matching : Boolean) : Word;
{execute the current entry - i.e. interpret the token and its data.
'Matching' is used to tell if we had to match the verb and noun of the input
to get to here.  Basically, this means that a table which did not need to
check user input, when calling another table, will not need to match user input}
Var
	CondActCounter : Word;
	ThisCondAct : MGameCondAct;
	RetBool : Boolean;
	Fail, GameOver : Boolean;
	{fail : shows if this token succeeded or not
	done : should we go on to do the next token? if done=true, then NO
	newtext : discard remaining text and prompt for more input? if newtext=true
				then YES
	gameover : game over? if endgame = true then YES}
	ThisData, ThisData2 : String;
	ExecutedSomething : Boolean;	{used to check if we did actually execute
						at least one entry.  Thus, we can return a 'you can't
						do that' message.  Also used by NOTDONE to return an
						error}
Begin
	For CondActCounter := 0 To ThisEntry.NumCondActs -1 Do
	Begin
		ThisCondAct := ThisEntry.TableEntry.Items[CondActCounter];
		Fail := False;
		Done := False;
		NewText := False;
		GameOver := False;
		ExecutedSomething := False;
		Case ThisCondAct.CondAct.Token Of
			{Conditions}
			TQUIT : Begin
						RetBool := CheckQuit;
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckQuit : Fail')
						End Else
							DebugWindow.AddText('CheckQuit : Succeed');
					End;
			TAT : Begin
						RetBool := CheckAt(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckAt : Fail')
						End Else
							DebugWindow.AddText('CheckAt : Succeed');
					End;
			TNOTAT : Begin
						RetBool := CheckNotAt(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckNotAt : Fail')
						End Else
							DebugWindow.AddText('CheckNotAt : Succeed');
					End;
			TATGREATER : Begin
						RetBool := CheckAtGreater(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckAtGreater : Fail')
						End Else
							DebugWindow.AddText('CheckAtGreater : Succeed');
					End;
			TATLESS : Begin
						RetBool := CheckAtLess(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckAtLess : Fail')
						End Else
							DebugWindow.AddText('CheckAtLess : Succeed');
					End;
			TPRESENT : Begin
						RetBool := CheckPresent(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckPresent : Fail')
						End Else
							DebugWindow.AddText('CheckPresent : Succeed');
					End;
			TABSENT	: Begin
						RetBool := CheckAbsent(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckAbsent : Fail')
						End Else
							DebugWindow.AddText('CheckAbsent : Succeed');
					End;
			TWEARING : Begin
						RetBool := CheckWearing(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckWearing : Fail')
						End Else
							DebugWindow.AddText('CheckWearing : Succeed');
					End;
			TNOTWEARING : Begin
							RetBool := CheckNotWearing(ThisCondAct.CondAct.Data1);
							If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckNotWearing : Fail')
						End Else
							DebugWindow.AddText('CheckNotWearing : Succeed');
					End;
			TCARRYING : Begin
						RetBool := CheckCarrying(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckCarrying : Fail')
						End Else
							DebugWindow.AddText('CheckCarrying : Succeed');
					End;
			TNOTCARRYING : Begin
						RetBool := CheckNotCarrying(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckNotCarrying : Fail')
						End Else
							DebugWindow.AddText('CheckNotCarrying : Succeed');
					End;
			TZERO : Begin
						RetBool := CheckZero(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckZero : Fail')
						End Else
							DebugWindow.AddText('CheckZero : Succeed');
					End;
			TNOTZERO : Begin
						RetBool := CheckNotZero(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckNotZero : Fail')
						End Else
							DebugWindow.AddText('CheckNotZero : Succeed');
					End;
			TON : Begin
						RetBool := CheckOn(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckOn : Fail')
						End Else
							DebugWindow.AddText('CheckOn : Succeed');
					End;
			TOFF : Begin
						RetBool := CheckOff(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckOff : Fail')
						End Else
							DebugWindow.AddText('CheckOff : Succeed');
					End;
			TADJECT1 : Begin
						RetBool := CheckAdject1(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckAdject1 : Fail')
						End Else
							DebugWindow.AddText('CheckAdject1 : Succeed');
					End;
			TADVERB : Begin
						RetBool := CheckAdverb(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckAdverb : Fail')
						End Else
							DebugWindow.AddText('CheckAdverb : Succeed');
					End;
			TPREPOSITION : Begin
						RetBool := CheckPreposition(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckPreposition : Fail')
						End Else
							DebugWindow.AddText('CheckPreposition : Succeed');
					End;
			TNOUN2 : Begin
						RetBool := CheckNoun2(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckNoun2 : Fail')
						End Else
							DebugWindow.AddText('CheckNoun2 : Succeed');
					End;
			TADJECT2 : Begin
						RetBool := CheckAdject2(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckAdject2 : Fail')
						End Else
							DebugWindow.AddText('CheckAdject2 : Succeed');
					End;
			TCHANCE : Begin
						RetBool := CheckChance(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckChance : Fail')
						End Else
							DebugWindow.AddText('CheckChance : Succeed');
					End;
			TATBETWEEN : Begin
						RetBool := CheckAtBetween(ThisCondAct.CondAct.Data1,
										ThisCondAct.CondAct.Data2);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckAtBetween : Fail')
						End Else
							DebugWindow.AddText('CheckAtBetween : Succeed');
					End;
			TISAT : Begin
						RetBool := CheckIsAt(ThisCondAct.CondAct.Data1,
										ThisCondAct.CondAct.Data2);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckIsAt : Fail')
						End Else
							DebugWindow.AddText('CheckIsAt : Succeed');
					End;
			TISNOTAT : Begin
						RetBool := CheckIsNotAt(ThisCondAct.CondAct.Data1,
										ThisCondAct.CondAct.Data2);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckIsNotAt : Fail')
						End Else
							DebugWindow.AddText('CheckIsNotAt : Succeed');
					End;
			TEQ : Begin
						RetBool := CheckEq(ThisCondAct.CondAct.Data1,
										ThisCondAct.CondAct.Data2);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckEq : Fail')
						End Else
							DebugWindow.AddText('CheckEq : Succeed');
					End;
			TNOTEQ : Begin
						RetBool := CheckNotEq(ThisCondAct.CondAct.Data1,
										ThisCondAct.CondAct.Data2);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckNotEq : Fail')
						End Else
							DebugWindow.AddText('CheckNotEq : Succeed');
					End;
			TGREATER : Begin
						RetBool := CheckGreater(ThisCondAct.CondAct.Data1,
										ThisCondAct.CondAct.Data2);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckGreater : Fail')
						End Else
							DebugWindow.AddText('CheckGreater : Succeed');
					End;
			TLESSTHAN : Begin
						RetBool := CheckLessThan(ThisCondAct.CondAct.Data1,
										ThisCondAct.CondAct.Data2);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckLessThan : Fail')
						End Else
							DebugWindow.AddText('CheckLessThan : Succeed');
					End;
			TSAME : Begin
						RetBool := CheckSame(ThisCondAct.CondAct.Data1,
										ThisCondAct.CondAct.Data2);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckSame : Fail')
						End Else
							DebugWindow.AddText('CheckSame : Succeed');
					End;
			TNOTSAME : Begin
						RetBool := CheckNotSame(ThisCondAct.CondAct.Data1,
										ThisCondAct.CondAct.Data2);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckNotSame : Fail')
						End Else
							DebugWindow.AddText('CheckNotSame : Succeed');
					End;
			TLESS : Begin
						RetBool := CheckLess(ThisCondAct.CondAct.Data1,
										ThisCondAct.CondAct.Data2);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckLess : Fail')
						End Else
							DebugWindow.AddText('CheckLess : Succeed');
					End;
			TMORE : Begin
						RetBool := CheckMore(ThisCondAct.CondAct.Data1,
										ThisCondAct.CondAct.Data2);
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('CheckMore : Fail')
						End Else
							DebugWindow.AddText('CheckMore : Succeed');
					End;


				{the conditions can only FAIL - they can never cause newtext,
				end game or done to become true.  however, the actions can cause
				one or many of these to become true}

				{ACTIONS}

			TDROPALL : Begin
						DoDropAll;
						DebugWindow.AddText('DropAll executed');
						ExecutedSomething := True;
					End;
			TAUTOG : Begin
						RetBool := DoAutog;
						If RetBool = False Then
						Begin
							Fail := True;
							NewText := True;
							Done := True;
							DebugWindow.AddText('Autog failed')
						End Else Begin
							DebugWindow.AddText('Autog succeeded');
							ExecutedSomething := True;
						End;
					End;
			TAUTOD : Begin
						RetBool := DoAutod;
						If RetBool = False Then
						Begin
							Fail := True;
							NewText := True;
							Done := True;
							DebugWindow.AddText('Autod failed')
						End Else begin
							DebugWindow.AddText('Autod succeeded');
							ExecutedSomething := True;
						End;
					End;
			TAUTOW : Begin
						RetBool := DoAutow;
						If RetBool = False Then
						Begin
							Fail := True;
							NewText := True;
							Done := True;
							DebugWindow.AddText('Autor failed')
						End Else begin
							DebugWindow.AddText('Autor succeeded');
							ExecutedSomething := True;
						End;
					End;
			TAUTOR : Begin
						RetBool := DoAutor;
						If RetBool = False Then
						Begin
							Fail := True;
							NewText := True;
							Done := True;
							DebugWindow.AddText('Autor failed')
						End Else begin
							DebugWindow.AddText('Autor succeeded');
							ExecutedSomething := True;
						End;
					End;
			TWHATO : Begin
					End;
			TTURNS : Begin
						DoTurns;
						DebugWindow.AddText('Turns executed');
						ExecutedSomething := True;
				End;
			TSCORE : Begin
						DoScore;
						DebugWindow.AddText('Score executed');
						ExecutedSomething := True;
					End;
			TCLS : Begin
						DoCLS;
						DebugWindow.AddText('CLS executed');
						ExecutedSomething := True;
					End;
			TNEWLINE : Begin
						DoNewLine;
						DebugWindow.AddText('NewLine executed');
						ExecutedSomething := True;
					End;
			TLISTOBJ : Begin
						DoListObj;
						DebugWindow.AddText('ListObj executed');
						ExecutedSomething := True;
					End;
			TINVEN : Begin
						DoInven;
						DebugWindow.AddText('Inven executed');
						ExecutedSomething := True;
					End;
			TDESC : Begin
						DoDesc;
						NewText := True;
						NewLocation := True;
						Done := True;
						DebugWindow.AddText('Desc executed - new location is true');
						ExecutedSomething := True;
					End;
			TDONE : Begin
						Done := True;
						DebugWindow.AddText('Done executed - done is true');
						ExecutedSomething := True;
					End;
			TNOTDONE : Begin
						Fail := True;
						Done := True;
						DebugWindow.AddText('NotDone executed - done and fail are true');
						ExecutedSomething := False;
					End;
			TEND : Begin
						RetBool := DoEnd;
						If RetBool = False Then
						{don't want to replay}
						Begin
							EndGame := True;
							Replay := False;
							Fail := True
						End Else Begin
						{want to replay}
							EndGame := True;
							Replay := True;
							Fail := True;
						End;
						Break;
					End;
			TSAVE : Begin
					End;
			TLOAD : Begin
					End;
			TANYKEY : Begin
						DoAnyKey;
						DebugWindow.AddText('AnyKey executed');
						ExecutedSomething := True;
					End;
			TNEWTEXT : Begin
						NewText := True;
						DebugWindow.AddText('NewText executed - newtext is true');
						ExecutedSomething := True;
					End;
			TGET : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						RetBool := DoGet(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							Done := True;
							NewText := True;
							DebugWindow.AddText('DoGet('+ThisData+') failed')
						End Else Begin
							DebugWindow.AddText('DoGet('+ThisData+') succeeded');
							ExecutedSomething := True;
						End;
					End;
			TDROP : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						RetBool := DoDrop(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							Done := True;
							NewText := True;
							DebugWindow.AddText('DoDrop('+ThisData+') failed')
						End Else Begin
							DebugWindow.AddText('DoDrop('+ThisData+') succeeded');
							ExecutedSomething := True;
						End;
					End;
			TWEAR : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						RetBool := DoWear(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							Done := True;
							NewText := True;
							DebugWindow.AddText('DoWear('+ThisData+') failed')
						End Else Begin
							DebugWindow.AddText('DoWear('+ThisData+') succeeded');
							ExecutedSomething := True;
						End;
					End;
			TREMOVE : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						RetBool := DoRemove(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							Done := True;
							NewText := True;
							DebugWindow.AddText('DoRemove('+ThisData+') failed')
						End Else Begin
							DebugWindow.AddText('DoRemove('+ThisData+') succeeded');
							ExecutedSomething := True;
						End;
					End;
			TCREATE : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoCreate(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoCreate('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TDESTROY : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoDestroy(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoDestroy('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TPUTO : Begin
						ExecutedSomething := True;
					End;
			TAUTOP : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoAutop(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoAutop('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TAUTOT : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoAutot(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoAutot('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TSET : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoSet(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoSet('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TCLEAR : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoClear(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoClear('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TTURNON : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoTurnOn(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoTurnOn('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TTURNOFF : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoTurnOff(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoTurnOff('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TRANDOM : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoRandom(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoRandom('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TMOVE : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						RetBool := DoMove(ThisCondAct.CondAct.Data1);
						If RetBool = False Then
						Begin
							Fail := True;
							Done := True;
							DebugWindow.AddText('DoMove('+ThisData+') failed')
						End Else Begin
							DebugWindow.AddText('DoMove('+ThisData+') succeeded');
							ExecutedSomething := True;
						End;
					End;
			TGOTO : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoGoTo(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoGoTo('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TWEIGHT : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoWeight(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoWeight('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TPRINT : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoPrint(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoPrint('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TMES : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoMes(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoMes('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TMESSAGE : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoMessage(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoMessage('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TINTMESS : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoIntMess(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoIntMess('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TBG : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoBG(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoBG('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TFG : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoFG(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoFG('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TLISTAT : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoListAt(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoListAt('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TPAUSE : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoPause(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoPause('+ThisData+') executed');
						ExecutedSomething := True;
					End;
			TTABLE : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						If Matching = True Then ThisData2 := 'TRUE'
						Else ThisData2 := 'FALSE';
						DebugWindow.AddText('Executing Table('+ThisData+','+ThisData2+')');
						ProcessActionTables(ThisCondAct.CondAct.Data1, Matching);
						ExecutedSomething := True;
					End;
			TDOALL : Begin
						ExecutedSomething := True;
					End;
			TSWAP : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						ThisData2 := IntToStr(ThisCondAct.CondAct.Data2);
						DoSwap(ThisCondAct.CondAct.Data1, ThisCondAct.CondAct.Data2);
						DebugWindow.AddText('DoSwap('+ThisData+','+ThisData2+') executed');
						ExecutedSomething := True;
					End;
			TPLACE : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						ThisData2 := IntToStr(ThisCondAct.CondAct.Data2);
						DoPlace(ThisCondAct.CondAct.Data1, ThisCondAct.CondAct.Data2);
						DebugWindow.AddText('DoPlace('+ThisData+','+ThisData2+') executed');
						ExecutedSomething := True;
					End;
			TPUTIN : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						ThisData2 := IntToStr(ThisCondAct.CondAct.Data2);
						DoPutIn(ThisCondAct.CondAct.Data1, ThisCondAct.CondAct.Data2);
						DebugWindow.AddText('DoPutIn('+ThisData+','+ThisData2+') executed');
						ExecutedSomething := True;
					End;
			TTAKEOUT : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						ThisData2 := IntToStr(ThisCondAct.CondAct.Data2);
						DoTakeOut(ThisCondAct.CondAct.Data1, ThisCondAct.CondAct.Data2);
						DebugWindow.AddText('DoTakeOut('+ThisData+','+ThisData2+') executed');
						ExecutedSomething := True;
					End;
			TCOPYOO : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						ThisData2 := IntToStr(ThisCondAct.CondAct.Data2);
						DoCopyOO(ThisCondAct.CondAct.Data1, ThisCondAct.CondAct.Data2);
						DebugWindow.AddText('DoCopyOO('+ThisData+','+ThisData2+') executed');
						ExecutedSomething := True;
					End;
			TCOPYOF : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						ThisData2 := IntToStr(ThisCondAct.CondAct.Data2);
						DoCopyOF(ThisCondAct.CondAct.Data1, ThisCondAct.CondAct.Data2);
						DebugWindow.AddText('DoCopyOF('+ThisData+','+ThisData2+') executed');
						ExecutedSomething := True;
					End;
			TCOPYFO : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						ThisData2 := IntToStr(ThisCondAct.CondAct.Data2);
						DoCopyFO(ThisCondAct.CondAct.Data1, ThisCondAct.CondAct.Data2);
						DebugWindow.AddText('DoCopyFO('+ThisData+','+ThisData2+') executed');
						ExecutedSomething := True;
					End;
			TPLUS : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						ThisData2 := IntToStr(ThisCondAct.CondAct.Data2);
						DoPlus(ThisCondAct.CondAct.Data1, ThisCondAct.CondAct.Data2);
						DebugWindow.AddText('DoPlus('+ThisData+','+ThisData2+') executed');
						ExecutedSomething := True;
					End;
			TMINUS : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						ThisData2 := IntToStr(ThisCondAct.CondAct.Data2);
						DoMinus(ThisCondAct.CondAct.Data1, ThisCondAct.CondAct.Data2);
						DebugWindow.AddText('DoMinus('+ThisData+','+ThisData2+') executed');
						ExecutedSomething := True;
					End;
			TADD : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						ThisData2 := IntToStr(ThisCondAct.CondAct.Data2);
						DoAdd(ThisCondAct.CondAct.Data1, ThisCondAct.CondAct.Data2);
						DebugWindow.AddText('DoAdd('+ThisData+','+ThisData2+') executed');
						ExecutedSomething := True;
					End;
			TSUB : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						ThisData2 := IntToStr(ThisCondAct.CondAct.Data2);
						DoSub(ThisCondAct.CondAct.Data1, ThisCondAct.CondAct.Data2);
						DebugWindow.AddText('DoSub('+ThisData+','+ThisData2+') executed');
						ExecutedSomething := True;
					End;
			TCOPYFF : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						ThisData2 := IntToStr(ThisCondAct.CondAct.Data2);
						DoCopyFF(ThisCondAct.CondAct.Data1, ThisCondAct.CondAct.Data2);
						DebugWindow.AddText('DoCopyFF('+ThisData+','+ThisData2+') executed');
						ExecutedSomething := True;
					End;
			TBEEP : Begin
						DoBeep;
						DebugWindow.AddText('DoBeep executed');
						ExecutedSomething := True;
					End;
			TABILITY : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						ThisData2 := IntToStr(ThisCondAct.CondAct.Data2);
						DoAbility(ThisCondAct.CondAct.Data1, ThisCondAct.CondAct.Data2);
						DebugWindow.AddText('DoAbility('+ThisData+','+ThisData2+') executed');
						ExecutedSomething := True;
					End;
			TEXAMINE : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						DoExamine(ThisCondAct.CondAct.Data1);
						DebugWindow.AddText('DoExamine('+ThisData+') Executed');
						ExecutedSomething := True;
					End;
			TAUTOE : Begin
						RetBool := DoAutoE;
						ExecutedSomething := True;
						If RetBool = False Then
						Begin
							Fail := True;
							DebugWindow.AddText('Autoe failed')
						End Else Begin
							DebugWindow.AddText('Autoe succeeded');
						End;
					End;
			TLET : Begin
						ThisData := IntToStr(ThisCondAct.CondAct.Data1);
						ThisData2 := IntToStr(ThisCondAct.CondAct.Data2);
						DoLet(ThisCondAct.CondAct.Data1, ThisCondAct.CondAct.Data2);
						DebugWindow.AddText('DoLet('+ThisData+','+ThisData2+') executed');
						ExecutedSomething := True;
					End;

		End;	{Case}
		If Fail = True Then Break;
		If Done = True Then Break;
	End;	{for condactcounter}

	If ((Fail = True) And (ExecutedSomething = False)) Then ExecEntry := _ExecFailed;
	If NewText = True Then ExecEntry := _NewTextRequired;
	If EndGame = True Then ExecEntry := _GameIsOver;
End;	{ExecEntry}

end.
