unit Flagdef;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * *                                                                   * * * }
{ * * *  The purpose of this unit is to provide the global data required  * * *}
{* * *    by the game - such as the numbers of the internal messages, etc* * * }
{ * * *                                                                   * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

interface

const
	_DarkFlag				= 1;
	_ObjectsCarried			= 2;
	_ObjectsWorn			= 3;
	_PlayerLocation			= 4;
	_GameTurns				= 5;
	_DecFlag1				= 6;
	_DecFlag2				= 7;
	_DecFlag3				= 8;
	_DecFlag4				= 9;
	_DecFlag5				= 10;
	_DecOnDesc				= 11;
	_DecOnDarkDesc			= 12;
	_DecOnDarkDarkDesc		= 13;
	_DecDark				= 14;
	_DecDarkDark			= 15;
	_PhraseVerb				= 16;
	_PhraseNoun1			= 17;
	_PhraseAdjective1		= 18;
	_PhraseAdverb			= 19;
	_PhrasePreposition		= 20;
	_PhraseNoun2			= 21;
	_PhraseAdjective2		= 22;
	_LastObjectNoun			= 23;
	_LastObjectAdjective	= 24;
	_MaxObjects				= 25;
	_MaxWeightFlag			= 26;
	_PlayerScore			= 27;
	_PlayerWeight			= 28;


	{return codes for executing player input}

	_AllOKCode					= 0;
	_NotUnderstoodCode			= -1;
	_ErrorOccurredContinueCode	= -2;
	_NewLocationDiscardTextCode	= 30000;
	_CouldntMoveCheckTablesCode	= -4;
	_OK_EndOfCurrentLoopCode	= 65535;
	_NotOK_EndOfCurrentLoopCode	= 65534;
	_EndGameCode = 65533;
	_NewTextCode = 65532;
	_EndGameReplayCode = 65531;

	_GameIsOver = 65535;
	_NewTextRequired = 65534;
	_ExecFailed = 65533;

	{Internal Message Reference names}

	_DarkMessage			= 1;
	_ObjsPresentMessage		= 2;
	_PromptMessage			= 3;
	_NotUnderstoodMessage	= 4;
	_CantGoMessage			= 5;
	_CantDoMessage			= 6;
	_CarryingMessage1		= 7;
	_WearingMessage			= 8;
	_CarryingMessage2		= 9;
	_QuitMessage			= 10;
	_EndGameMessage			= 11;
	_ReplayMessage			= 12;
	_OKMessage				= 13;
	_AnyKeyMessage			= 14;
	_TurnsMessage1			= 15;
	_TurnsMessage2			= 16;
	_TurnsMessage3			= 17;
	_TurnsMessage4			= 18;
	_ScoreMessage1			= 19;
	_ScoreMessage2			= 20;
	_YesMessage				= 21;
	_NoMessage				= 22;
	_MoreMessage			= 23;
	_ObjNotHereMessage		= 24;
	_ObjNotKnownMessage		= 25;
	_GetMessage				= 26;
	_DropMessage			= 27;
	_WearMessage			= 28;
	_RemoveMessage			= 29;
	_HandsFullMessage		= 30;
	_TooHeavyMessage		= 31;
	_CantPickUpMessage		= 32;
	_CantDropMessage		= 33;
	_CantWearMessage		= 34;
	_CantRemoveHandsFull	= 35;
	_PutInMessage			= 36;
	_CantPutInNotContainer	= 37;
	_TakeOutMessage			= 38;
	_CantTakeOutMessage		= 39;
	_CantDropWearingMessage	= 40;
	_DontHaveItMessage		= 41;
	_DontHaveOneMessage		= 42;
	_CantTakeOutNotContainerMessage = 43;
	_IsntOneHereMessage		= 44;
	_AlreadyHaveMessage		= 45;
	_AlreadyWearingMessage	= 46;
	_NotWearingMessage		= 47;
	_NotWearingOneMessage	= 48;
	_CantRemoveMessage		= 49;
	_ObjNotInObjMessage		= 50;
	_NotOneInObjMessage		= 51;
	_ObjTooHeavyToTakeOut	= 52;
	_CantWearingItMessage	= 53;

	{other global numbers}

	_ObjectNotFound	= 65535;

	_WornLoc		= 65510;
	_CarriedLoc		= 65511;
	_NotCreatedLoc	= 65512;

	_Succeeded = TRUE;
	_Failed = FALSE;

implementation


end.
