unit Gamestuf;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * *                                                                   * * * }
{ * * *  The purpose of this unit is to provide the basic functionality   * * *}
{* * *    needed to be able to play the game...such as setting and       * * * }
{ * * *   clearing flags, acting on the action tables statements, etc     * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

interface

uses
	Classes, FlagDef, SysUtils, WinTypes, Forms, VcbStuff, Debug, LocStuff,
	Globals, TNames, ActStuff, ObjStuff;

Type
	FlagArray = Class(TObject)
		Private
			FArray : Array[1..655] of Word;
		Public
			Constructor Create;
			Function GetValue(FlagNo : Integer) : Word;
			Procedure SetValue(FlagNo : Integer; Value : Word);
	End;	{FlagArray}

	MGameFlags = Class(TObject)
		Private
			FlagList : TList;
		Public
			Constructor Create;
			Procedure SetFlagValue(FlagNo, Value : Word);
			Function GetFlagValue(FlagNo : Word) : Word;
	End;	{MGameFlags}

	MGameBulbs = Class(TObject)
		Private
			BulbList : TList;
		Public
			Constructor Create;
			Procedure TurnOnBulb(BulbNo : Word);
			Procedure TurnOffBulb(BulbNo : Word);
			Function GetBulbStatus(BulbNo : Word) : Boolean;
	End;	{MGameBulbs}

	BulbArray = Class(TObject)
		Private
			BArray : Array[1..655] of Boolean;
		Public
			Constructor Create;
			Function GetStatus(BulbNo : Integer) : Boolean;
			Procedure TurnOn(BulbNo : Integer);
			Procedure TurnOff(BulbNo : Integer);
	End;	{BulbArray}

		{*********************************************}

		{*********************************************}
		{**           Exported Procedures           **}
		{*********************************************}

		{*********************************************}

		Procedure SetupGame;
		Function TextToKnownWords(Input : String) : String;
		Function ProcessOutput(Command : String) : Integer;
		Function ProcessPhrase(Input : String) : Integer;
		Procedure ShowPrompt;
		Function DoConnections(MovementFlag, NounValue : Word) : Integer;
		Function ProcessActionTables(TableNumber : Word; Match : Boolean) : Word;

implementation

Uses
	Test, VocabMnu, IntDlg, LocMenu, Act, Condit, Exec;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                   Functions start here!                           * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }




{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                  Class FlagArray functions                        * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Constructor FlagArray.Create;
{Just set all the elements in the array to zero}
Var
	Index : Integer;
Begin
	For Index := 1 to 655 Do
		FArray[Index] := 0;
End;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function FlagArray.GetValue(FlagNo : Integer) : Word;
Begin
	GetValue := FArray[FlagNo];
End;	{FlagArray.GetValue}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure FlagArray.SetValue(FlagNo : Integer; Value : Word);
Begin
	FArray[FlagNo] := Value;
End;	{FlagArray.SetValue}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                    Class MGameFlags functions                     * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Constructor MGameFlags.Create;
Var
	Index : Integer;
	ThisArray : FlagArray;
Begin
	FlagList := TList.Create;

	For Index := 1 to 100 Do
	Begin
		ThisArray := FlagArray.Create;
		FlagList.Add(ThisArray);
	End;	{For Index}
End;	{MGameFlags.Create}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function MGameFlags.GetFlagValue(FlagNo : Word) : Word;
Var
	ThisArray : FlagArray;
Begin
	ThisArray := FlagList[FlagNo DIV 655];
	GetFlagValue := ThisArray.GetValue(FlagNo MOD 655);
End;	{MGameFlags.GetFlagValue}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure MGameFlags.SetFlagValue(FlagNo, Value : Word);
Var
	ThisArray : FlagArray;
Begin
	ThisArray := FlagList.Items[FlagNo DIV 655];
	ThisArray.SetValue(FlagNo MOD 655,Value);
	FlagList.Delete(FlagNo DIV 655);
	FlagList.Insert(FlagNo DIV 655,ThisArray);
End;	{MGameFlags.SetFlagValue}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                  Class BulbArray functions                        * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Constructor BulbArray.Create;
{Just set all the elements in the array to false}
Var
	Index : Integer;
Begin
	For Index := 1 to 655 Do
		BArray[Index] := False;
End;	{BulbArray.Create}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function BulbArray.GetStatus(BulbNo : Integer) : Boolean;
Begin
	GetStatus := BArray[BulbNo];
End;	{BulbArray.GetStatus}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure BulbArray.TurnOn(BulbNo : Integer);
Begin
	BArray[BulbNo] := True;
End;	{BulbArray.TurnOn}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure BulbArray.TurnOff(BulbNo : Integer);
Begin
	BArray[BulbNo] := False;
End;	{BulbArray.TurnOff}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                    Class MGameBulbs functions                     * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Constructor MGameBulbs.Create;
Var
	Index : Integer;
	ThisArray : BulbArray;
Begin
	BulbList := TList.Create;
	For Index := 1 to 100 Do
	Begin
		ThisArray := BulbArray.Create;
		BulbList.Add(ThisArray);
	End;	{For Index}
End;	{MGameBulbs.Create}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function MGameBulbs.GetBulbStatus(BulbNo : Word) : Boolean;
Var
	ThisArray : BulbArray;
Begin
	ThisArray := BulbList.Items[BulbNo DIV 655 -1];
	GetBulbStatus := ThisArray.GetStatus(BulbNo MOD 655);
End;	{MGameBulbs.GetBulbStatus}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure MGameBulbs.TurnOnBulb(BulbNo : Word);
Var
	ThisArray : BulbArray;
Begin
	ThisArray := BulbList.Items[BulbNo DIV 655 -1];
	ThisArray.TurnOn(BulbNo MOD 655);
	BulbList.Insert(BulbNo DIV 655 -1,ThisArray);
End;	{MGameBulbs.TurnOnBulb}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure MGameBulbs.TurnOffBulb(BulbNo : Word);
Var
	ThisArray : BulbArray;
Begin
	ThisArray := BulbList.Items[BulbNo DIV 655 -1];
	ThisArray.TurnOff(BulbNo MOD 655);
	BulbList.Insert(BulbNo DIV 655 -1,ThisArray);
End;	{MGameBulbs.TurnOffBulb}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                         General functions                         * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure SetupGame;
{Procedure to set up a game - basically, just sets up the first location of the
player}
Var
	Index : Word;
	ThisObject : GameObject;
Begin
	Flags := MGameFlags.Create;
	Bulbs := MGameBulbs.Create;

	{set up the game's initial location}

	Flags.SetFlagValue(_PlayerLocation,StartLoc);

	TestUnit.CLS;

	For Index := 0 to Objects.NumberOfObjects-1 Do
	{set flags for objects carried and worn, and move all objects to their
	starting locations}
	Begin
		ThisObject := Objects.GetObjectAtIndex(Index);
		If ThisObject.ObjStartingLoc = _CarriedLoc Then
			Flags.SetFlagValue(_ObjectsCarried, Flags.GetFlagValue(_ObjectsCarried) + 1);
		If ThisObject.ObjStartingLoc = _WornLoc Then
			Flags.SetFlagValue(_ObjectsWorn, Flags.GetFlagValue(_ObjectsWorn) + 1);
		Objects.SetObjectLocation(ThisObject.ObjNumber, ThisObject.ObjStartingLoc);
	End;
End;	{SetupGame}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function TextToKnownWords(Input : String) : String;
{function to work through an input string, and create a series of phrases from
it - it will split up the input text, first looking for conjunction words and
punctuation, and converting them all to the first conjunction word in the vocab.
Then, work through input text, discard any words not in vocab.  Finally, sort it
out into acceptable sentence format, and return}

	{*********************************************}
	{**           Local Procedures              **}
	{*********************************************}

	{*********************************************}
	Function IsLetter(Ch : Char) : Boolean;
	Begin
		If ((Ch In['A'..'Z']) Or (Ch In['a'..'z'])) Then
			IsLetter := True
		Else IsLetter := False;
	End;	{IsLetter}

	{*********************************************}
	Function UpperCase(Ch : Char) : Char;
	{return the uppercase version of a lower-case
	letter, or the input letter if it is upper-case}
	Begin
		If (Ch In['a'..'z']) Then
			UpperCase := Chr(Ord(Ch) - 32)
		Else
			UpperCase := Ch;
	End;	{UpperCase}

	{*********************************************}
	Function IsConjunctionPunctuation(Ch : Char) : Boolean;
	{check if the character specified is considered
	as conjunction punctuation, i.e. commas, full stops
	etc}
	Begin
		If ((Ch = '.') Or
			(Ch = ',') Or
			(Ch = ':') Or
			(Ch = ';')) Then
			IsConjunctionPunctuation := True
		Else
			IsConjunctionPunctuation:= False;
	End;	{IsConjunctionPunctuation}

	{*********************************************}

	{*********************************************}
	{**           Main Procedure code           **}
	{*********************************************}

	{*********************************************}

Const
	Space = #32;
Var
	CurrentWord, ThisWord, PrevWord : String;
	Output : String;
	Index : Integer;
	RetCode : Integer;
Begin
	DebugWindow.AddText('User entered : "'+Input+'"');

	Input := Input + Space;	{This will allow the last word to be processed}
	CurrentWord := '';
	Output := '';
	For Index := 1 to Length(Input) Do
	Begin
		If IsLetter(Input[Index]) Then
			CurrentWord := CurrentWord + UpperCase(Input[Index])
		Else If IsConjunctionPunctuation(Input[Index]) Then
		Begin
			Output := Output + CurrentWord + Space + 'THEN' + Space;
			CurrentWord := ''
		End Else If ((Input[Index] = Space) Or (Index = Length(Input))) Then
			If IsConjunction(CurrentWord) Then
			Begin
				Output := Output + 'THEN' + Space;
				CurrentWord := '';
			End Else Begin
				If CurrentWord <> '' Then
				Begin
					Output := Output + CurrentWord + Space;
					CurrentWord := '';
				End;	{If}
			End;	{If IsConjunction}
	End;	{For Index}

	{get to here, we have got rid of punctuation.  because someone might type
	", then", get rid of multiple 'then's}

	Input := Output;

	ThisWord := '';
	PrevWord := '';
	Output := '';
	CurrentWord := '';

	For Index := 1 to Length(Input) Do
	Begin
		If IsLetter(Input[Index]) Then
			CurrentWord := CurrentWord + Input[Index]
		Else Begin
			PrevWord := ThisWord;
			ThisWord := CurrentWord;
			If ((PrevWord <> ThisWord) Or (ThisWord <> 'THEN')) Then
			Begin
				CurrentWord := '';
				If PrevWord <> '' Then Output := Output + PrevWord + Space
			End Else Begin
				CurrentWord := '';
			End;	{if words different}
		End;	{is letter or space}
	End;	{for}

	If ((ThisWord <> 'THEN') And (ThisWord <> PrevWord)) Then
			Output := Output + ThisWord;

	{get to here, have removed multiple THEN's, and also, the last word is not
	a conjunction word.  Now, remove words which are not in the vocab}

	Input := Output;

	ThisWord := '';
	PrevWord := '';
	Output := '';
	CurrentWord := '';

	For Index := 1 to Length(Input) Do
	Begin
		If IsLetter(Input[Index]) Then
			CurrentWord := CurrentWord + Input[Index]
		Else Begin
			If CurrentWord = 'THEN' Then	{end of phrase}
			Begin
				{*********************************************}

				{*********************************************}
				{** This is the MAIN line of the game       **}
				{**  player.  We get to here, and have the  **}
				{**  string OUTPUT containing a phrase to   **}
				{**  be acted upon.                         **}
				{*********************************************}

				{*********************************************}
				RetCode := ProcessOutput(Output);
{				If RetCode = _NewLocationDiscardTextCode Then Break;}
				If RetCode = _EndGameCode Then Break;
				Output := '';
				CurrentWord := '';
				If EndGame = False Then ProcessActionTables(2,False);
			End Else Begin
				If (FindWordInVocab(CurrentWord) = True) Then
				Begin
					Output := Output + CurrentWord + Space;
					CurrentWord := ''
				End	Else
					CurrentWord := '';	{word not recognised}
			End;	{end of phrase?}
		End;	{is letter or space}
	End;	{for}

	If ((RetCode <> _NewLocationDiscardTextCode) And (RetCode <> _EndGameCode)) Then
	Begin
		If (FindWordInVocab(CurrentWord) = True) Then
			Output := Output + CurrentWord;

		{have to act upon the last phrase input}

		RetCode := ProcessOutput(Output);
		If RetCode = _EndGameCode Then EndGame := True;

		Output := '';
		CurrentWord := '';
		If EndGame = False Then ProcessActionTables(2,False);
	End;
End;	{TextToKnownWords}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function ProcessOutput(Command : String) : Integer;
Var
	RetCode : Integer;
	ErrorMess : String;
	ActionRetCode : Word;
Begin
	{the first thing we want to do when we are here is process action table 2,
	which allows AGC to 'have a go' at the game itself}

{	ProcessActionTables(2,False);}	{don't want to do this here!}

	{now we get back to what we were doing, checking the user input}
	
	ProcessPhrase(Command);

	ErrorMess := IntMessages.GetMessage(_OKMessage);
	If ((Flags.GetFlagValue(_PhraseNoun1) < 14) And
		(Flags.GetFlagValue(_PhraseNoun1) <> 0)) Then
	Begin
		RetCode := DoConnections(_PlayerLocation,
						Flags.GetFlagValue(_PhraseNoun1));
		Case RetCode Of
			_CouldntMoveCheckTablesCode : Begin
					ActionRetCode := ProcessActionTables(3, True);
					If NewLocation = True Then
					Begin
						NewLocation := False;
					End;
					Case ActionRetCode Of
						_NewtextCode : ProcessOutput := _NewLocationDiscardTextCode;
						_EndGameCode : ProcessOutput := _EndGameCode;
					End;
				End;
			_NewLocationDiscardTextCode : Begin
					DoDesc;
					NewLocation := False;
					ProcessOutput := _NewLocationDiscardTextCode;
					{discard further phrases...get more input}
				End;
		End;	{Case}
	End Else Begin
		ActionRetCode := ProcessActionTables(3, True);
		If NewLocation = True Then
		Begin
			NewLocation := False;
		End;
		Case ActionRetCode Of
			_NewTextCode : ProcessOutput := _NewLocationDiscardTextCode;
			_EndGameCode : ProcessOutput := _EndGameCode;
		End;
	End;
End;	{Processoutput}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function ProcessPhrase(Input : String) : Integer;
{Take the input string, and act upon it}

	{*********************************************}
	{**           Local Procedures              **}
	{*********************************************}

	{*********************************************}
	Function IsLetter(Ch : Char) : Boolean;
	Begin
		If ((Ch In['A'..'Z']) Or (Ch In['a'..'z'])) Then
			IsLetter := True
		Else IsLetter := False;
	End;	{IsLetter}
	{*********************************************}

	{*********************************************}
	{**           Main Procedure code           **}
	{*********************************************}

	{*********************************************}
Var
	PhVerb, PhAdverb, PhNoun1, PhAdjective1, PhNoun2, PhAdjective2, PhPreposition : Word;
	Index : Integer;
	ThisWord : MGameVocab;
	CurrentWord : String;
	WordPos : Word;
Begin
	If Length(Input) = 0 Then
	Begin
		Flags.SetFlagValue(_PhraseVerb, 0);
		Flags.SetFlagValue(_PhraseNoun1, 0);
		Flags.SetFlagValue(_PhraseAdjective1, 0);
		Flags.SetFlagValue(_PhraseAdverb, 0);
		Flags.SetFlagValue(_PhrasePreposition, 0);
		Flags.SetFlagValue(_PhraseNoun2, 0);
		Flags.SetFlagValue(_PhraseAdjective2, 0);
		Exit;
	End;

	If Input[Length(Input)] <> ' ' Then Input := Input + #32;

	DebugWindow.AddText('  Phrase is: "'+Input+'"');

	PhVerb := 0;
	PhNoun1 := 0;
	PhNoun2 := 0;
	PhAdjective1 := 0;
	PhAdjective2 := 0;
	PhAdverb := 0;
	PhPreposition := 0;

	CurrentWord := '';

	For Index := 1 to Length(Input) Do
	Begin
		If IsLetter(Input[Index]) Then
		Begin
			CurrentWord := CurrentWord + Input[Index];
		End Else Begin
			WordPos := GetPositionOfWord(CurrentWord);
			ThisWord := VocabList.Items[WordPos];
			Case ThisWord.Vocabulary.WordType Of
				Verb : PhVerb := ThisWord.Vocabulary.WordValue;
				Adverb : PhAdverb := ThisWord.Vocabulary.WordValue;
				Noun : If PhNoun1 = 0 Then
							PhNoun1 := ThisWord.Vocabulary.WordValue
						Else
							PhNoun2 := ThisWord.Vocabulary.WordValue;
				Adjective : If PhAdjective1 = 0 Then
								PhAdjective1 := ThisWord.Vocabulary.WordValue
							Else
								PhAdjective2 := ThisWord.Vocabulary.WordValue;
				Preposition : PhPreposition := ThisWord.Vocabulary.WordValue;
			End;
			CurrentWord := '';
		End;	{If isletter}
	End;	{For}

	{now, have word values in the appropriate places}

	Flags.SetFlagValue(_PhraseVerb, PhVerb);
	Flags.SetFlagValue(_PhraseNoun1, PhNoun1);
	Flags.SetFlagValue(_PhraseAdjective1, PhAdjective1);
	Flags.SetFlagValue(_PhraseAdverb, PhAdverb);
	Flags.SetFlagValue(_PhrasePreposition, PhPreposition);
	Flags.SetFlagValue(_PhraseNoun2, PhNoun2);
	Flags.SetFlagValue(_PhraseAdjective2, PhAdjective2);

	If PhVerb <> 0 Then DebugWindow.AddText('    Verb : '+IntToStr(PhVerb));
	If PhNoun1 <> 0 Then DebugWindow.AddText('    Noun1 : '+IntToStr(PhNoun1));
	If PhAdjective1 <> 0 Then DebugWindow.AddText('    Adjective1 : '+IntToStr(PhAdjective1));
	If PhAdverb <> 0 Then DebugWindow.AddText('    Adverb : '+IntToStr(PhAdverb));
	If PhPreposition <> 0 Then DebugWindow.AddText('    Preposition : '+IntToStr(PhPreposition));
	If PhNoun2 <> 0 Then DebugWindow.AddText('    Noun2 : '+IntToStr(PhNoun2));
	If PhAdjective2 <> 0 Then DebugWindow.AddText('    Adjective2 : '+IntToStr(PhAdjective2));

End;	{ProcessPhrase}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure ShowPrompt;
Var
	ThisMessage : AnsiString;
Begin
	ThisMessage := IntMessages.GetMessage(_PromptMessage);

	TestUnit.AddText('^^^^^', True);
	TestUnit.AddText(ThisMessage, True);
End;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function DoConnections(MovementFlag, NounValue : Word) : Integer;
{check the connection table for the current location, and if there is an entry
in the slot corresponding to the value NounValue, move the player to that
location and describe it.  If not, do nothing
Returns:	'CouldntMoveCheckActionTablesCode' if the player could not move in
				the direction specified
			'NewLocationDiscardTextCode' if the player moved.  This means
				'discard all further text, and get more input'}
Var
	ListIndex : Word;
	ThisLocation : MGameLocation;
	CurrentLoc : Word;
Begin
	CurrentLoc := Flags.GetFlagValue(MovementFlag);
	ListIndex := FindLocation(CurrentLoc);

	If ListIndex <> 65535 Then
	Begin
		ThisLocation := LocationList.Items[ListIndex];
		If ThisLocation.Location.Exits[NounValue] <> 0 Then
		Begin
			Flags.SetFlagValue(MovementFlag,ThisLocation.Location.Exits[NounValue]);
			NewLocation := True;
			DoConnections := _NewLocationDiscardTextCode;
		End Else Begin
			DoConnections := _CouldntMoveCheckTablesCode;
		End;
	End Else Begin
		DebugWindow.AddText('error occurred retreiving location from list in DoConnect');
	End;
End;	{DoConnections}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function ProcessActionTables(TableNumber : Word; Match : Boolean) : Word;
{this procedure will work through the action table specified, matching the verb
and noun to any entry (if match is set to true), or not doing any matching.  Any
entries which match (or all entries) will then be executed.  Depending on the
return codes, there are three possible actions after checking/executing a
CondAct:  1. do next condact.  2. fail this condact, go to next entry.  3. fail
this condact, get new text
Return Codes:	AllOKCode - tables executed with no error
				ErrorOccurredContinueCode - error occurred  (or 'notdone'
					executed.) carry on with next phrase
				NewLocationDiscardTextCode - get new text from the user.
					discard any existing phrases waiting to be executed.}
Var
	ThisTable : MGameTable;
	ListIndex, Index : Word;
	ThisVerb, ThisNoun : Word;
	ThisEntry : MGameTableEntry;
	MatchVerb, MatchNoun : Boolean;
	Fail : Boolean;
	EntryStatus : Word;
	MatchedOneEntry : Boolean;	{to check if we matched at least one entry}
Begin
	DebugWindow.AddText('In ProcessActionTables.  Processing Table '+IntToStr(TableNumber));
	MatchedOneEntry := False;
	ListIndex := FindTable(TableNumber);
	ThisVerb := Flags.GetFlagValue(_PhraseVerb);
	ThisNoun := Flags.GetFlagValue(_PhraseNoun1);
	If ListIndex <> 65535 Then
		ThisTable := GetTableFromList(Listindex);
	EndGame := False;
	NewText := False;
	If ThisTable.NumEntries <> 0 Then
	For Index := 0 To ThisTable.NumEntries -1 Do
	Begin
		ThisVerb := Flags.GetFlagValue(_PhraseVerb);
		ThisNoun := Flags.GetFlagValue(_PhraseNoun1);
		ThisEntry := ThisTable.Table.Items[Index];
		MatchVerb := False;
		MatchNoun := False;

		If ((ThisEntry.Verb = 0) Or
			(ThisEntry.Verb = 65535) Or
			(ThisEntry.Verb = ThisVerb) Or
			(Match = False)) Then
			MatchVerb := True;
		If ((ThisEntry.Noun = 0) Or
			(ThisEntry.Noun = 65535) Or
			(ThisEntry.Noun = ThisNoun) Or
			(Match = False)) Then
			MatchNoun := True;

		If ((MatchVerb = True) And (MatchNoun = True)) Then
		{we exectute this entry}
		Begin
			MatchedOneEntry := True;
			EntryStatus := ExecEntry(ThisEntry, Match);
			If EntryStatus = _GameIsOver Then EndGame := True;
			If EntryStatus = _NewTextRequired Then NewText := True;
			If EntryStatus = _ExecFailed Then Fail := True;

			If NewText = True Then Break;
			If EndGame = True Then Break;
			If Done = True Then Break;

{			If Fail = True Then
			Begin
			{check the verb and noun to see whether it was a 'can't do' or a
			'can't go' error}
{				If ((ThisVerb = 0) And (ThisNoun < 14)) Then
				Begin
				{can't go}
{					DoIntMess(_CantGoMessage);
				End Else Begin
					DoIntMess(_CantDoMessage);
				End;
			End;
}		End;
		If EndGame = True Then Break;
	End;	{For Index}

	If MatchedOneEntry = False Then
	Begin
		If ((ThisVerb = 0) And (ThisNoun = 0) And (Match = True)) Then
		Begin
		{not understood}
			DoIntMess(_NotUnderstoodMessage);
		End Else If ((ThisVerb = 0) And (ThisNoun < 14) And (Match = True)) Then
		Begin
			{can't go}
			DoIntMess(_CantGoMessage);
		End Else Begin
			If Match = True Then DoIntMess(_CantDoMessage);
		End;
	End;

	If NewText = True Then ProcessActionTables := _NewTextCode;
End;	{CheckActionTables}

End.
