Unit Intdlg;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * *                                                                   * * * }
{ * * *  The purpose of this unit is to provide the routines needed for   * * *}
{* * *    the menu interface to the Internal messages portion.           * * * }
{ * * *                                                                   * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Interface

Uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, IntStuff, EntrNum, MdIntMsg,
  NmIntMsg;

Type
  TIntMsgDlg = Class(TForm)
	NewMsg: TBitBtn;
	ChngMsg: TBitBtn;
	ViewMsgs: TBitBtn;
	ExitBtn: TBitBtn;
	Procedure FormShow(Sender: TObject);
	Procedure FormCreate(Sender: TObject);
	Procedure FormDestroy(Sender: TObject);
	Procedure ChngMsgClick(Sender: TObject);
	Procedure NewMsgClick(Sender: TObject);
	Procedure ViewMsgsClick(Sender: TObject);
  Private
	{ Private declarations }
  Public
	{ Public declarations }
  End;

Var
  IntMsgDlg: TIntMsgDlg;
  IntMessages : MGameIntMessage;

Implementation

{$R *.DFM}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                   Functions start here!                           * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }




{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TIntMsgDlg.FormShow(Sender: TObject);
Begin
	NewMsg.SetFocus;
End;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TIntMsgDlg.FormCreate(Sender: TObject);
Var
	IntMessFile : TextFile;
	Temp : String;
	Index : Integer;
	TempVal, TempMess : String;
Begin
	IntMessages := MGameIntMessage.Create;

	If Not FileExists('Project.Int') Then CreateIntMessFile;

	If FileExists('Project.Int') Then
	Begin
		AssignFile(IntMessFile,'Project.Int');
		Reset(IntMessFile);
		While Not Eof(IntMessFile) Do
		Begin
			ReadLn(IntMessFile,Temp);
			TempVal := '';
			TempMess := '';

			Index := 1;
			While Temp[Index] <> ' ' Do
			Begin
				TempVal := TempVal + Temp[Index];
				Inc(Index);
			End;
			Inc(Index);
			For Index := Index to Length(Temp) Do
			Begin
				TempMess := TempMess + Temp[Index];
			End;

			If (IntMessages.AddMessage(StrToInt(TempVal),TempMess) = False) Then
			Begin
				Application.MessageBox('Attemps to create duplicate message number detected.',
										'AddMessage Failed',
										mb_OK + mb_IconExclamation);
			End;
		End;	{while}

		CloseFile(IntMessFile);
	End;	{file exists}
End;	{form create}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TIntMsgDlg.FormDestroy(Sender: TObject);
Var
	Index : Word;
	IntMessFile : TextFile;
	ThisIntMess : IntMessage;
Begin
	AssignFile(IntMessFile,'Project.Int');
	ReWrite(IntMessFile);
	If IntMessages.Count <>0 Then
	Begin
		For Index := 0 to IntMessages.Count -1 Do
		Begin
			ThisIntMess := IntMessages.GetMessageAtIndex(Index);

			Writeln(IntMessFile,IntToStr(ThisIntMess.Number)+' '+
					ThisIntMess.Text);
		End;	{for}
	End;	{if}
	CloseFile(IntMessFile);
End;	{form destroy}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TIntMsgDlg.ChngMsgClick(Sender: TObject);
Var
	ThisIntMess : IntMessage;
	Index : Word;
Begin
	EnterNumberDlg.Caption := 'Internal Messages';
	EnterNumberDlg.Label1.Caption := 'Enter the number of the internal message you wish to change';
	EnterNumberDlg.ShowModal;

	If EnterNumberDlg.ModalResult = idOK Then
	Begin
		Index := IntMessages.FindMessage(EnterNumberDlg.SpinEdit1.Value);
		If Index  <> 65535 Then
		Begin
			ThisIntMess := IntMessages.GetMessageAtIndex(Index);

			ModifyMessage.MesgNum.Caption := IntToStr(ThisIntMess.Number);
			ModifyMessage.Edit1.Text := ThisIntMess.Text;

			ModifyMessage.ShowModal;

			If ModifyMessage.ModalResult = idOK Then
			Begin
				IntMessages.ReplaceMessage(StrToInt(ModifyMessage.MesgNum.Caption), ModifyMessage.Edit1.Text);
			End
		End Else Begin
			Application.MessageBox('There is no Internal Message with that number',
									'Error',
									mb_OK + mb_ICONEXCLAMATION)
		End;	{find internal message in list}
	End;	{user pressed ok in enter number dialog}
End;	{chngmsgclick}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TIntMsgDlg.NewMsgClick(Sender: TObject);
Var
	Index : Word;
Begin
	Index := IntMessages.GetFirstFreeNumber;

	If Index  <> 65535 Then
	Begin
		ModifyMessage.Caption := 'Add a new Message';

		ModifyMessage.MesgNum.Caption := IntToStr(Index);
		ModifyMessage.Edit1.Text := '';

		ModifyMessage.ShowModal;

		If ModifyMessage.ModalResult = idOK Then
			IntMessages.AddMessage(Index, ModifyMessage.Edit1.Text);
	End Else Begin
		NoMoreIntMsgsDlg.ShowModal;
	End;	{find internal message in list}
End;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TIntMsgDlg.ViewMsgsClick(Sender: TObject);
Var
	ThisIntMess : IntMessage;
	Index : Word;	{integer!}
Begin
	If IntMessages.Count = 0 Then
		Application.MessageBox('There are no Internal Messages in the Database',
								'View Internal Messages',
								mb_OK + mb_ICONINFORMATION)
	Else Begin
		ModifyMessage.GroupBox1.Caption := 'Message Text:';
		ModifyMessage.Caption := 'View Internal Messages';

		For Index := 0 to IntMessages.Count-1 Do
		Begin
			ThisIntMess := IntMessages.GetMessageAtIndex(Index);

			ModifyMessage.MesgNum.Caption := IntToStr(ThisIntMess.Number);
			ModifyMessage.Edit1.Text := ThisIntMess.Text;
			If (ModifyMessage.ShowModal = idCancel) Then Break;
		End;	{for}

		ModifyMessage.Caption:='Modify Internal Message Text';
		ModifyMessage.GroupBox1.Caption := 'Enter the text of the message';
	End;
End;

End.	{intdlg}
