Unit Intstuff;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * *                                                                   * * * }
{ * * *  The purpose of this unit is to provide the routines needed to    * * *}
{* * *    create and manipulate the Internal Message list.               * * * }
{ * * *                                                                   * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Interface

Uses
	Classes, SysUtils, Forms, WinTypes;

Type
	IntMessage = Class(TObject)
			Number : Word;
			Text : String;

		Public
			Constructor Create(Value : Word; MessText : String);
	End;

	MGameIntMessage = Class(TObject)
		Private
			MessList : TList;

		Public
			Count : Word;

			Constructor	Create;
			Function AddMessage(Value : Word; Text : String) : Boolean;
			Function GetMessage(Value : Word) : String;
			Function GetMessageAtIndex(ListIndex : Word) : IntMessage;
			Function ReplaceMessage(Value : Word; NewText : String) : Integer;
			Function FindMessage(Value : Word) : Word;
			Function GetFirstFreeNumber : Word;
			Procedure SortList;
	End;	{MGameIntMess}

		{*********************************************}

		{*********************************************}
		{**           Exported Procedures           **}
		{*********************************************}

		{*********************************************}

	Procedure CreateIntMessFile;

Const
	IntMessCount = 53;

	IntMessages : Array[1..IntMessCount] of String = (
		'It''s dark.',							{loc is dark}
		'You can also see:',					{objs present}
		'What next?',							{prompt}
		'I didn''t understand.',				{not understood}
		'You can''t go that way',				{not understood, verb movement}
		'You can''t do that',					{ ""   ""   , verb not movement}
		'You are carrying',
		'and are wearing',                              {  INVEN}
		'nothing',
		'Do you really want to quit?',			{QUIT}
		'Game Over',							{END}
		'Do you want to play again?',			{ ""}
		'OK',									{OK}
		'Press a key...',						{ANYKEY}
		'You have taken ',						{  <--					}
		' turn',								{  <--     TURNS		}
		's',									{  <--					}
		'.',										{  <--					}
		'You have scored ',						{ <<--					}
		'%',									{ <<--		SCORE		}
		'Y',									{indicates a positive response}
		'N',									{indicates negative response}
		'more...',								{prompt for full screen}
		'I don''t see the _ here',
		'I don''t know what one of those is.',
		'You pick up the _',
		'You drop the _',
		'You put on the _',
		'You take off the _',
		'You can''t pick up the _.  Your hands are full',
		'You can''t pick up the _.  It''s too heavy',
		'You can''t pick up the _',
		'You can''t drop the _',
		'You can''t wear the _',
		'You can''t take off the _.  Your hands are full',
		'You put the _ in the &',
		'You can''t put the _ in the & - the & isn''t a container!',
		'You take the _ out of the &',
		'You can''t take the _ out of the &.  You can''t carry any more.',
		'You can''t drop the _.  You''re wearing it',
		'You don''t have the _',
		'You don''t have one of those',
		'You can''t take the _ out of the & - the & isn''t a container!',
		'There isn''t one of those here',
		'You already have the _',
		'You are already wearing the _',
		'You''re not wearing the _',
		'You''re not wearing one of those',
		'You can''t take the _ off',
		'The _ isn''t in the &',
		'There isn''t one of those in the &',
		'The _ weighs too much to take it out of the &',
		'You can''t, you''re wearing the _');


Implementation

Uses
	IntDlg;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                   Functions start here!                           * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }



{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                  Class IntMessage functions                       * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Constructor IntMessage.Create(Value : Word; MessText : String);
{note that no checks are made here}
Begin
	Number := Value;
	Text := MessText;
End;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                  Class MGameIntMess functions                     * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Constructor MGameIntMessage.Create;
{just create an empty list}
Begin
	MessList := TList.Create;
	Count := 0;
End;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function MGameIntMessage.AddMessage(Value : Word; Text : String) : Boolean;
{add a message to the list.
Returns:	TRUE if the message added successfully
			FALSE if a message with te number specified already exists}
Var
	ThisMessage : IntMessage;
Begin
	If (FindMessage(Value) = 65535) Then	{No message found}
	Begin
		ThisMessage := IntMessage.Create(Value, Text);
		MessList.Add(ThisMessage);
		SortList;
		AddMessage := True;
        Inc(Count)
	End Else Begin
		AddMessage := False;
	End;	{if}
End;	{AddMessage}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function MGameIntMessage.GetMessage(Value : Word) : String;
Var
	ThisMessage : IntMessage;
	Posn : Word;
Begin
	Posn := FindMessage(Value);
	If (Posn = 65535) Then
	Begin	{no message found}
		GetMessage := 'Error.  Message '+IntToStr(Value)+' not found.'
	End Else Begin
		ThisMessage := MessList.Items[Posn];
		GetMessage := ThisMessage.Text;
	End;	{message found}
End;	{GetMessage}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function MGameIntMessage.GetMessageAtIndex(ListIndex : Word) : IntMessage;
Begin
	If ListIndex < MessList.Count Then
	Begin
		GetMessageAtIndex := MessList.Items[ListIndex]
	End Else Begin
		GetMessageAtIndex := NIL;
	End;	{if}
End;	{GetMessageAtIndex}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function MGameIntMessage.ReplaceMessage(Value : Word; NewText : String) : Integer;
{replace the text of the message specified with the new text given
Returns:	0 if all went ok
			-1 if the message specified did not exist and was created}
Var
	ListIndex : Word;
	Status : Integer;
Begin
	Status := 32767;

	ListIndex := FindMessage(Value);
	If ListIndex <> 65535 Then
	Begin
		MessList.Delete(ListIndex);
		Status := 0;
        Dec(Count);
	End;

	AddMessage(Value, NewText);

	If Status = 32767 Then Status := -1;

	ReplaceMessage := Status;

End;
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function MGameIntMessage.FindMessage(Value : Word) : Word;
{check if a message with the specified number exists.
Returns:	65535 if the message number specified does not exist
			List index if it does}
Var
	ThisMessage : IntMessage;
	Index, Found : Word;
Begin
	Found := 65535;	{Assume failure}
	If (MessList.Count <> 0) Then
	Begin
		For Index := 0 To MessList.Count -1 Do
		Begin
			ThisMessage := MessList.Items[Index];
			If (ThisMessage.Number = Value) Then
			Begin
				Found := Index;
				Break;   {Index := MessList.Count -1;}
			End;	{If found}
		End;	{For}
	End;	{have at least 1 message}

	FindMessage := Found;
End;	{FindMessage}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Function MGameIntMessage.GetFirstFreeNumber : Word;
{figure out the first free number in the list.  i.e. if there are messages
numbered 1, 2, 3, 5, 6, then the first free number in the list is 4.
Returns:	The first free message number
			65535 if there are no free slots}
Var
	MesNumberArray : PChar;
	Index : Word;
	TempMessage : IntMessage;
Begin
	If (MessList.Count = 0) Then
	Begin
		GetFirstFreeNumber := 1;
		Exit;
	End;

	Getmem(MesNumberArray,65502);

	For Index := 0 To 65500 Do
		MesNumberArray[Index] := '0';

	For Index := 0 To MessList.Count - 1 Do
	Begin
		TempMessage := MessList.Items[Index];
		MesNumberArray[TempMessage.Number] := '1';
	End;

	For Index := 1 to 65500 Do
	Begin
		If (MesNumberArray[Index] = '0') Then
		Begin
			GetFirstFreeNumber := Index;
			FreeMem(MesNumberArray,65502);
			Exit;
		End;	{If found}
	End;	{For}

	FreeMem(MesNumberArray,65502);

	{Get to here, so no free slots found}

	GetFirstFreeNumber := 65535;
End;	{GetFirstFreeNumber}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure MGameIntMessage.SortList;
{sort the list of internal messages into ascending order on message number}

	{*********************************************}
	{**           Local Procedures              **}
	{*********************************************}

	{*********************************************}
	Function Sort : Boolean;
	Var
		Done : Boolean;
		Index : Word;
		ThisIntMess, NextIntMess : IntMessage;
	Begin
		Done := False;
		If (MessList.Count = 0) Or (MessList.Count = 1) Then
			Sort := False	{A list with 0 or 1 items is always sorted}
		Else
		Begin
			For Index:=0 To MessList.Count-2 Do
			Begin
				ThisIntMess := MessList.Items[Index];
				NextIntMess := MessList.Items[Index+1];
				If ThisIntMess.Number > NextIntMess.Number Then
				Begin
					MessList.Exchange(Index, Index+1);
					Done := True;	{To say that we exchanged at least one item}
				End;	{out of synch}
			End;	{for}
		End;	{have at least 2 messages}
		Sort := Done;
	End;

	{*********************************************}

	{*********************************************}
	{**           Main Procedure code           **}
	{*********************************************}

	{*********************************************}

Begin
	Repeat
	Until Sort = False;
End;	{SortList}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                         General functions                         * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure CreateIntMessFile;
{Used to create an internal message list, if one does not already exist for the
game}
Var
	Index : Integer;
	IntMessFile : TextFile;
Begin
	Assign(IntMessFile,'Project.Int');
	ReWrite(IntMessFile);
	For Index := 1 to IntMessCount Do
		Writeln(IntMessFile,IntToStr(Index) + ' ' +
			IntMessages[Index]);
	CloseFile(IntMessFile);
End;	{CreateIntMessFile}

end.
