unit Locmenu;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Tabs, ChngLoc, EntrNum, LocStuff, Text2Num;

type
  TLocationDlg = class(TForm)
	Exit: TBitBtn;
	NewLoc: TBitBtn;
	ChngLoc: TBitBtn;
	DelLoc: TBitBtn;
	ViewLocs: TBitBtn;
	procedure ChngLocClick(Sender: TObject);
	procedure FormCreate(Sender: TObject);
	procedure FormDestroy(Sender: TObject);
	procedure ViewLocsClick(Sender: TObject);
	procedure NewLocClick(Sender: TObject);
	procedure DelLocClick(Sender: TObject);
	procedure FormShow(Sender: TObject);
  private
	{ Private declarations }
  public
	{ Public declarations }
  end;

var
  LocationDlg: TLocationDlg;
  LocationList : TList;		{Define our List of Locations here}

implementation

{$R *.DFM}

procedure TLocationDlg.ChngLocClick(Sender: TObject);
var
	P : Pchar;
	Index : Word;
	ErrCode : Word;	{used to show if string copied okay}
	NewLocation : MGameLocation;
	ListIndex : Word;	{used to get the index in the list of the location we want to modify}
begin
	EnterNumberDlg.Caption := 'Enter Location number';
    EnterNumberDlg.Label1.Caption := 'Enter the number of the location you wish to change.';
	EnterNumberDlg.ShowModal;	{show the 'get number' dialog}
	if (EnterNumberDlg.ModalResult = idOK) Then	{did the user press 'OK'?}
	Begin								{inside the loop - yes}
		ListIndex := FindLocation(StrToInt(EnterNumberDlg.SpinEdit1.Text));
		If ListIndex = 65535 Then
		Begin
			Application.MessageBox('There is no location with that number',
									'Error',
									mb_OK + mb_ICONEXCLAMATION);
		End Else
		Begin
			ChangeLocDlg.LocationNumber.Caption := EnterNumberDlg.Spinedit1.Text;
			{print the number of the location text we are changing}
			ChangeLocDlg.Caption := 'Modify Location Text';
			{because this dialog box is also used by 'add location', change its title}
			NewLocation:=LocationList.Items[ListIndex];
			LocationList.Delete(ListIndex);
			ChangeLocDlg.Memo1.Lines.Add(NewLocation.Location.Description);
			ChangeLocDlg.ShowModal;		{show the dialog}
			Index:=ChangeLocDlg.Memo1.GetTextLen;	{get the length of the text entered}
			GetMem(P,Index+1);	{allocate a block of Index bytes, starting at P}
			ErrCode:= ChangeLocDlg.Memo1.GetTextBuf(P,Index+1);	{copy the string to our memory}
			If ErrCode <> Index Then
			Begin
				Application.MessageBox('String copy failed!',
										'Error',
										mb_OK + mb_ICONEXCLAMATION)
			end else Begin
				NewLocation := MGameLocation.Create(StrToInt(EnterNumberDlg.SpinEdit1.Text), P,
					NewLocation.Location.Exits[1], NewLocation.Location.Exits[2],
					NewLocation.Location.Exits[3], NewLocation.Location.Exits[4],
					NewLocation.Location.Exits[5], NewLocation.Location.Exits[6],
					NewLocation.Location.Exits[7], NewLocation.Location.Exits[8],
					NewLocation.Location.Exits[9], NewLocation.Location.Exits[10],
					NewLocation.Location.Exits[11],NewLocation.Location.Exits[12],
					NewLocation.Location.Exits[13],NewLocation.Location.Exits[14]);
				LocationList.Add(NewLocation);

				SortLocationList;	{Sort the list into ascending order on location number}
			End;	{If}
		End;	{valid location number found}
	End;	{clicked okay in enter num dlg, not cancel}
end;	{ChngLocClick}

procedure TLocationDlg.FormCreate(Sender: TObject);
var
	LocationFile : File of Byte;	{The file we will use to store the data}
		{format of data file is:
			Location Number : 2 bytes (1st +256*2nd)
			Text : n bytes}
	NewLocation : MGameLocation;	{A TObject used to store the location data}
	Index, Counter : Word;	{Counters}
	NewLocValue : Word;		{Temporary variable to hold new location number}
{	Temp, TempVal : String;}
	TempByte : Byte;
	Description : String;	{will hold description}
	Exits : Array[1..14] of Word;	{used to hold the 14 destinations}
begin
	LocationList := Tlist.Create;	{Create a new instance of our list}

	If FileExists('Project.Loc') Then
	Begin
		AssignFile(LocationFile,'Project.Loc');	{this bit loads an existing}
		Reset(LocationFile);						{location file}
		While Not(Eof(LocationFile)) Do
		Begin
			Read(LocationFile,TempByte);
			Index := TempByte;
			Read(LocationFile, TempByte);
			Index:=Index+(256*TempByte);	{Index now holds location number}
			NewLocValue := Index;

			Description := '';
			Read(LocationFile,TempByte);
			While TempByte <> 26 Do
			Begin
				Description := Description + Chr(TempByte);
				Read(LocationFile, TempByte);
			End;

			For Counter := 1 to 14 Do
			Begin
				Read(LocationFile,TempByte);
				Exits[Counter] := TempByte;
				Read(LocationFile,TempByte);
				Exits[Counter] := Exits[Counter]+(256 * TempByte);
			End;


			NewLocation := MGameLocation.Create(NewLocValue, Description,
							Exits[1], Exits[2], Exits[3], Exits[4], Exits[5], Exits[6],
							Exits[7], Exits[8], Exits[9], Exits[10], Exits[11],
							Exits[12], Exits[13], Exits[14]);

			LocationList.Add(NewLocation);
		End;

		CloseFile(LocationFile);
	End;
end;	{FormCreate}

procedure TLocationDlg.FormDestroy(Sender: TObject);
var
	LocationFile : File of Byte;
	Index,Counter : Word;
	LocNum : Word;
	TempLoc : MGameLocation;
	TempByte : Byte;
	ThisExit : Word;
begin
	AssignFile(LocationFile,'Project.Loc');
	ReWrite(LocationFile);

	If LocationList.Count <> 0 Then
	Begin
	{only save the list if it has some items in it!}
		For Counter:=0 to LocationList.Count-1 Do
		Begin
			TempLoc := LocationList.Items[Counter];

			LocNum:=TempLoc.Location.Value;
			TempByte:=LocNum MOD 256;
			Write(LocationFile,TempByte);
			TempByte:=LocNum DIV 256;
			Write(LocationFile,TempByte);

			For Index := 1 to Length(TempLoc.Location.Description) Do
			Begin
				TempByte:=Ord(TempLoc.Location.Description[Index]);
				Write(LocationFile,TempByte);
			End;

			TempByte := 26;	{The marker}
			Write(LocationFile,TempByte);

			For Index := 1 to 14 Do
			Begin
				ThisExit := TempLoc.Location.Exits[Index];
				TempByte := ThisExit MOD 256;
				Write(LocationFile,TempByte);
				TempByte := ThisExit DIV 256;
				Write(LocationFile,TempByte);
			End;
		End;
	End;	{If}

	CloseFile(LocationFile);
	LocationList.Free;		{Free the location list and its memory}
end;	{FormDestroy}

procedure TLocationDlg.ViewLocsClick(Sender: TObject);
{will just view the locations one at a time.  just puts a loc in the change
dialog box, makes it read only, and shows it then exits, making it
read-write.  Will loop if more than one location}
var
	Index:Word;
	ThisLocation :MGameLocation;
begin
	If LocationList.Count = 0 Then
	Begin
		Application.MessageBox('There are no locations in this game yet!',
								'View Locations',
								mb_OK + mb_ICONINFORMATION);
	End Else
	For Index:=0 to LocationList.Count-1 Do
	Begin
		ThisLocation:=LocationList.Items[Index];

		ChangeLocDlg.Caption := 'View Locations';
		ChangeLocDlg.LocationNumber.Caption:=IntToStr(ThisLocation.Location.Value);
		ChangeLocDlg.Memo1.ReadOnly:=True;
		ChangeLocDlg.Memo1.Lines.Add(ThisLocation.Location.Description);
		ChangeLocDlg.ShowModal;
		ChangeLocDlg.Memo1.ReadOnly:=False;
		ChangeLocDlg.Memo1.Clear;
	End;
end;	{ViewLocsClick}

procedure TLocationDlg.NewLocClick(Sender: TObject);
var
	P : Pchar;
	Index : Word;
	ErrCode : Word;	{used to show if string copied okay}
	NewLocation : MGameLocation;
	LocNum : Word;	{The number of the new location}
begin
	ChangeLocDlg.Caption:='Add Location';
	LocNum := GetFirstFreeLocationNumber;
	ChangeLocDlg.LocationNumber.Caption := IntToStr(LocNum);
	{print the number of the location text we are changing}
	If (ChangeLocDlg.ShowModal = 1) Then		{show the dialog}
	Begin	{user pressed OK}
		Index:=ChangeLocDlg.Memo1.GetTextLen;	{get the length of the text entered}
		If Index = 0 Then
		Begin
			Application.MessageBox('Location Text is zero bytes long.  Location not created.',
									'Locations',
									mb_OK + mb_ICONEXCLAMATION)
		End Else Begin
			GetMem(P,Index+1);	{allocate a block of Index bytes, starting at P, allow for terminating NULL}
			ErrCode:= ChangeLocDlg.Memo1.GetTextBuf(P,Index+1);	{copy the string to our memory}
			If ErrCode <> Index Then
			Begin
				Application.MessageBox('String copy failed!','Error',mb_OK + mb_ICONEXCLAMATION)
			end else Begin
				NewLocation := MGameLocation.Create(LocNum, P,
					0,0,0,0,0,0,0,0,0,0,0,0,0,0);	{Create our new location}
						{note, initially, all exits lead nowhere}
				LocationList.Add(NewLocation);	{Add it to the list}

				SortLocationList;	{Sort the list into ascending order on location number}
			End;	{If}
		End;
	End;
	ChangeLocDlg.Memo1.Clear;	{Clear the dialog box's edit box}
end;	{NewLocClick}

procedure TLocationDlg.DelLocClick(Sender: TObject);
{prompt the user for a location number, and then delete it from the list}
var
	LocNum : Word;
	LocationText : Array[0..14] of Char;
begin
	If LocationList.Count = 0 Then	{no locs in db}
		Application.MessageBox('There are no locations in the database',
								'Error',
								mb_OK + mb_ICONEXCLAMATION)
	Else Begin
    	EnterNumberDlg.Caption := 'Enter Location Number';
		EnterNumberDlg.Label1.Caption := 'Enter number of location to delete:';
		EnterNumberDlg.ShowModal;	{show the 'get number' dialog}
		if (EnterNumberDlg.ModalResult = idOK) Then	{did the user press 'OK'?}
		Begin								{inside the loop - yes}
			LocNum := FindLocation(StrToInt(EnterNumberDlg.SpinEdit1.Text));
			If LocNum = 65535 Then	{oops, a location with that number was NOT found!!}
				Application.MessageBox('There is no location with that number',
										'Error',
										mb_OK + mb_ICONEXCLAMATION)
			Else
			Begin
				If (CheckLocUsedByObjects(EnterNumberDlg.SpinEdit1.Value) = True) Then
					{checks if location is the start loc by an object or more, and returns true if
						either it is not used, or it is okay to delete the loc anyway}
				Begin
					If (CheckLocUsedByOtherLoc(EnterNumberDlg.SpinEdit1.Value) = True) Then
					Begin
						{checks if the loc is used by an exit from any of the other locations
							and returns true if either it is not used, or it is okay to
							delete the loc anyway...false if not}
						Begin
							StrPCopy(LocationText,'Location '+EnterNumberDlg.SpinEdit1.Text);
							If (Application.MessageBox('Are you sure you want to delete this location?',
													LocationText,
													mb_OKCancel + mb_ICONQUESTION)) = 1 Then
							{The user pressed OK}
								LocationList.Delete(LocNum);
						End;
					End;
				End;
			End;
		End;
	End;
end;	{DelLocClick}

procedure TLocationDlg.FormShow(Sender: TObject);
begin
	NewLoc.SetFocus;
end;

end.
