unit Locstuff;

interface

uses
	Globals, Classes, SysUtils, Forms, WinTypes, ObjStuff, ChngCnct;

type
	GameLocation = Record
		Value : Word;	{the location's number, 0-65535}
		Description : AnsiString;	{the description, a pointer to its first char}
		Exits : Array[1..14] Of Word;	{used to hold the 14 destinations from this location}
	end;

	MGameLocation = class(TObject)
		Location : GameLocation;	{have to overload the class definition}
									{for TObject, to that a TList, i.e. our}
									{list of locations, will hold a Location}
									{as each node}
		constructor
			Create(Value : Word; Description : AnsiString;
					a,b,c,d,e,f,g,h,i,j,k,l,m,n : Word);	{create our constructor}
		public
	end;	{MGameLocation}

	function FindLocation(Number : Word) : Word;
	function GetFirstFreeLocationNumber : Word;
	procedure SortLocationList;		{Used to sort the list}
	function CheckLocUsedByObjects(LocNumber : Word) : Boolean;
	function CheckLocUsedByOtherLoc(LocNumber : Word) : Boolean;

	procedure MakeCCDialogRO;
	procedure MakeCCDialogRDWR;
	procedure ResetCCDialog;

implementation

uses
	LocMenu, ObjMenu;

constructor MGameLocation.Create(Value : Word; Description : AnsiString;
									a,b,c,d,e,f,g,h,i,j,k,l,m,n : Word);
{NOTENOTENOTENOTENOTENOTENOTENOTENOTENOTENOTENOTENOTENOTENOTENOTE

			no checks are made on the data here

 NOTENOTENOTENOTENOTENOTENOTENOTENOTENOTENOTENOTENOTENOTENOTENOTE}
begin
	Location.Value := Value;
	Location.Description := Description;
	Location.Exits[1] := a;
	Location.Exits[2] := b;
	Location.Exits[3] := c;
	Location.Exits[4] := d;
	Location.Exits[5] := e;
	Location.Exits[6] := f;
	Location.Exits[7] := g;
	Location.Exits[8] := h;
	Location.Exits[9] := i;
	Location.Exits[10] := j;
	Location.Exits[11] := k;
	Location.Exits[12] := l;
	Location.Exits[13] := m;
	Location.Exits[14] := n;
end;	{Create}


function FindLocation(Number : Word) : Word;
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Checks if the location number specified is used already.
Returns:	list index number if so
			65535 if not
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
var
	ThisLocation : MGameLocation;	{temp var}
	Index : Word;		{counter}
	Found : Word;		{local copy of true/false}
begin
	Found := 65535;		{assume failure}
	If LocationList.Count <> 0 Then
	Begin
		For Index:=0 to LocationList.Count -1 Do	{loop through list, check each loc}
		Begin
			ThisLocation := LocationList.Items[Index];
			If ThisLocation.Location.Value = Number Then Found := Index;	{found it}
		End;
	End;

	FindLocation := Found;	{return our true/false status}
End;	{FindLocation}

function GetFirstFreeLocationNumber : Word;
{Using the List of locations, return the first available location number,}
{ in the range 0-65535}
var
	LocNumberArray : PChar;
	Index : Word;
	TempLocation : MGameLocation;
begin
	If LocationList.Count =0 Then
	Begin
		GetFirstFreeLocationNumber := 1;
		Exit;
	End;

	GetMem(LocNumberArray,65502);

	For Index:=0 to 65500 Do
		LocNumberArray[Index] := '0';

	For Index:=0 to LocationList.Count-1 Do
	Begin
		TempLocation:=LocationList.Items[Index];
		LocNumberArray[TempLocation.Location.Value]:='1';
	End;
	For Index:=1 To 65500 Do
	Begin
		If LocNumberArray[Index]='0' Then
		Begin
			GetFirstFreeLocationNumber:=Index;
			FreeMem(LocNumberArray,65502);
			Exit;
		End;
	End;

	{***problem - no default value returned!***}
	FreeMem(LocNumberArray,65502);
End;	{GetFirstFreeLocationNumber}


Procedure SortLocationList;

	function Sort : Boolean;
	var
		Done : Boolean;
		Index : Word;
		ThisLocation, NextLocation : MGameLocation;
	Begin
		Done := False;
		If (LocationList.Count = 0) or (LocationList.Count = 1) Then
			Sort := False	{A list with 0 or 1 items is always sorted}
		Else
		Begin
			For Index:=0 to LocationList.Count-2 Do
			Begin
				ThisLocation:=LocationList.Items[Index];
				NextLocation:=LocationList.Items[Index+1];
				If ThisLocation.Location.Value > NextLocation.Location.Value Then
				Begin
					LocationList.Exchange(Index, Index+1);
					Done := True;	{To say that we exchanged at least one item}
				End;
			End;
		End;
		Sort := Done;
	End;

Begin
	repeat
	Until Sort = False;
End;	{SortLocationList}

function CheckLocUsedByObjects(LocNumber : Word) : Boolean;
{checks if the location specified is used by any othe the objects in the game
as a starting location for that object.  If so, prompts the user if he wants to
delete the location, meaning that the starting loc of the object(s) in question
would be set to zero.  returns true, meaning that either the location is not
used, or that it is okay to delete the loc, or false, meaning that the location
deletion should not happen}
var
	Found : Boolean;
	Index : Word;
	ThisObject : GameObject;
Begin
	Found := False;

	If Objects.NumObjects <> 0 Then	{we have at least one object}
	Begin
		For Index := 0 to Objects.NumObjects -1 Do
		Begin
			ThisObject := Objects.GetObjectAtIndex(Index);

			If ThisObject.ObjStartingLoc = LocNumber Then
			Begin
				Found := True;
			End;	{start loc + loc num match}
		End;	{for}

		If Found = True Then
		Begin
			If (Application.MessageBox('The location you are about to delete is used by one or more'+#10+#13+
										'of the objects in the database as their starting location.'+#10+#13+
										'To delete the location, the objects'' starting locations'+#10+#13+
										'have to be set to (nowhere) first.'+#10+#10+#10+#13+
										'Do you wish to do this?',
										'Question',
										mb_YESNO + mb_ICONQUESTION) = idYES) Then
			Begin
				For Index := 0 to Objects.NumObjects -1 Do
				Begin
					ThisObject := Objects.GetObjectAtIndex(Index);
						If ThisObject.ObjStartingLoc = LocNumber Then
							Objects.ResetStartingLocAtIndex(Index);
				End;
				Application.MessageBox('The starting location for any object which used'+#10+#13+
										'the location specified has been reset',
										'Information',
										mb_OK + mb_ICONINFORMATION);
			End;	{user pressed yes in confirm dialog}
		End;	{found = true}
	End;

	CheckLocUsedByObjects := True;
End;	{CheckLocUsedByObjects}

function CheckLocUsedByOtherLoc(LocNumber : Word) : Boolean;
{checks if the location specified is referenced by any of the other locations
if the connections table for each location.  If so, will prompt the user that
continuing the delete will break the links (i.e. set the offending connection
in the table to zero).  If user presses 'yes', will set conflicting links to
zero.  Pressing 'no', will do nothing, and exit the routine indicating that
deletion should not occur}
var
	Found, ContinueOK : Boolean;
	Index : Word;
	Counter : Word;
	ThisLoc : MGameLocation;
	SpareList : TList;	{copy of the location list}
Begin
	Found := False;
	ContinueOK := True;
	For Index := 0 to LocationList.Count-1 Do
	Begin
		ThisLoc:=LocationList.Items[Index];

		If ThisLoc.Location.Value <> LocNumber Then
		Begin
			For Counter := 1 to 14 Do
			Begin
				If ThisLoc.Location.Exits[Counter] = LocNumber Then
					Found := True;
			End;
		End;
	End;

	If Found = True Then
	Begin
		If (Application.MessageBox('The location you are about to delete is used by one or more'+#10+#13+
									'of the other locations in the database - a link exists between them'+#10+#13+
									'in the connections table.  To delete this location, the links have to'+#10+#13+
									'be broken first.'+#10+#10+#10+#13+
									'Do you wish to delete the links?',
									'Question',
									mb_YESNO + mb_ICONQUESTION) = idYES) Then
		Begin
			SpareList := TList.Create;

			For Index := 0 to LocationList.Count -1 Do
			Begin
				ThisLoc := LocationList.Items[Index];

				For Counter := 1 to 14 Do
				Begin
					If ThisLoc.Location.Exits[Counter] = LocNumber Then
						ThisLoc.Location.Exits[Counter] := 0;
				End;

				SpareList.Add(ThisLoc);
			End;

			LocationList.Free;

			LocationList := TList.Create;

			For Index := 0 to SpareList.Count -1 Do
			Begin
				ThisLoc := SpareList.Items[Index];
				LocationList.Add(ThisLoc);
			End;

			SpareList.Free;

			Application.MessageBox('Likns from other locations to this one have been deleted',
									'Information',
									mb_OK + mb_ICONINFORMATION)
		End Else	{user clicked 'no'}
			ContinueOK := False;
	End;
	CheckLocUsedByOtherLoc := ContinueOK;
End;	{CheckLocUsedByOtherLoc}

procedure MakeCCDialogRO;
{make the connections dialog box read-only, by disabling everything.  Used for viewing the connections}
Begin
	ChngCnctDlg.Dest1.ReadOnly := True;
	ChngCnctDlg.Dest2.ReadOnly := True;
	ChngCnctDlg.Dest3.ReadOnly := True;
	ChngCnctDlg.Dest4.ReadOnly := True;
	ChngCnctDlg.Dest5.ReadOnly := True;
	ChngCnctDlg.Dest6.ReadOnly := True;
	ChngCnctDlg.Dest7.ReadOnly := True;
	ChngCnctDlg.Dest8.ReadOnly := True;
	ChngCnctDlg.Dest9.ReadOnly := True;
	ChngCnctDlg.Dest10.ReadOnly := True;
	ChngCnctDlg.Dest11.ReadOnly := True;
	ChngCnctDlg.Dest12.ReadOnly := True;
	ChngCnctDlg.Dest13.ReadOnly := True;
	ChngCnctDlg.Dest14.ReadOnly := True;
End;	{makedialogro}

procedure MakeCCDialogRDWR;
{the opposite of makedialogro - return everything to !readonly}
Begin
	ChngCnctDlg.Dest1.ReadOnly := False;
	ChngCnctDlg.Dest2.ReadOnly := False;
	ChngCnctDlg.Dest3.ReadOnly := False;
	ChngCnctDlg.Dest4.ReadOnly := False;
	ChngCnctDlg.Dest5.ReadOnly := False;
	ChngCnctDlg.Dest6.ReadOnly := False;
	ChngCnctDlg.Dest7.ReadOnly := False;
	ChngCnctDlg.Dest8.ReadOnly := False;
	ChngCnctDlg.Dest9.ReadOnly := False;
	ChngCnctDlg.Dest10.ReadOnly := False;
	ChngCnctDlg.Dest11.ReadOnly := False;
	ChngCnctDlg.Dest12.ReadOnly := False;
	ChngCnctDlg.Dest13.ReadOnly := False;
	ChngCnctDlg.Dest14.ReadOnly := False;
End;	{makedialogrdwr}

procedure ResetCCDialog;
{reset the captions and values of the things in the connections dialog box
to their default values - makes things tidy}
Begin
	ChngCnctDlg.First.Caption := '(nothing)';
	ChngCnctDlg.Second.Caption := '(nothing)';
	ChngCnctDlg.Third.Caption := '(nothing)';
	ChngCnctDlg.Fourth.Caption := '(nothing)';
	ChngCnctDlg.Fifth.Caption := '(nothing)';
	ChngCnctDlg.Sixth.Caption := '(nothing)';
	ChngCnctDlg.Seventh.Caption := '(nothing)';
	ChngCnctDlg.Eigth.Caption := '(nothing)';
	ChngCnctDlg.Ninth.Caption := '(nothing)';
	ChngCnctDlg.Tenth.Caption := '(nothing)';
	ChngCnctDlg.Eleventh.Caption := '(nothing)';
	ChngCnctDlg.Twelfth.Caption := '(nothing)';
	ChngCnctDlg.Thirteenth.Caption := '(nothing)';
	ChngCnctDlg.Fourteenth.Caption := '(nothing)';

	ChngCnctDlg.Dest1.Value := 0;
	ChngCnctDlg.Dest2.Value := 0;
	ChngCnctDlg.Dest3.Value := 0;
	ChngCnctDlg.Dest4.Value := 0;
	ChngCnctDlg.Dest5.Value := 0;
	ChngCnctDlg.Dest6.Value := 0;
	ChngCnctDlg.Dest7.Value := 0;
	ChngCnctDlg.Dest8.Value := 0;
	ChngCnctDlg.Dest9.Value := 0;
	ChngCnctDlg.Dest10.Value := 0;
	ChngCnctDlg.Dest11.Value := 0;
	ChngCnctDlg.Dest12.Value := 0;
	ChngCnctDlg.Dest13.Value := 0;
	ChngCnctDlg.Dest14.Value := 0;
End;	{resetdialogbox}

end.
