Unit Main;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * *                                                                   * * * }
{ * * *  The purpose of this unit is to provide the program's main menu   * * *}
{* * *    dialog box, and to branch according to what the user chooses   * * * }
{ * * *   from that menu.  The buttons on the dialog box all have names   * * *}
{* * *    (as can be seen in the 'type' section below.  When clicked,    * * * }
{ * * *   these buttons send an appropriate message to the system, and    * * *}
{* * *    this message will be trapped by the appropriate routine below  * * * }
{ * * *   which will then call the appropriate part of the program.       * * *}
{* * *                                                                   * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Interface

{$IFNDEF DEBUGGING}
Uses
  Globals, SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, VocabMnu, About, ExtCtrls, Buttons, LocMenu,
  MesMenu, ObjMenu, CnctMenu, IntDlg, Test, Actions, Misc;

{$ELSE}
Uses
  Globals, SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, VocabMnu, About, ExtCtrls, Buttons, LocMenu,
  MesMenu, ObjMenu, CnctMenu, IntDlg, Test, Actions, Misc, Debug;
{$ENDIF}

Type
  TMainMenu = Class(TForm)
	GroupBox1  : TGroupBox;
	BitBtn1    : TBitBtn;
	Actions    : TBitBtn;
	Vocab      : TBitBtn;
	Locations  : TBitBtn;
	Objects    : TBitBtn;
	Connexions : TBitBtn;
	Messages   : TBitBtn;
	Internal   : TBitBtn;
	TestButton : TBitBtn;
	BitBtn2: TBitBtn;
	CheckBox1: TCheckBox;
	MiscBtn: TBitBtn;
    Label1: TLabel;
	Procedure VocabClick(Sender: TObject);
	Procedure ShowAbout(Sender: TObject);
	Procedure LocationsClick(Sender: TObject);
	Procedure MessagesClick(Sender: TObject);
	Procedure ObjectsClick(Sender: TObject);
	Procedure FormShow(Sender: TObject);
	Procedure ConnexionsClick(Sender: TObject);
	Procedure InternalClick(Sender: TObject);
	procedure TestButtonClick(Sender: TObject);
	procedure BitBtn2Click(Sender: TObject);
	procedure CheckBox1Click(Sender: TObject);
	procedure ActionsClick(Sender: TObject);
	procedure MiscBtnClick(Sender: TObject);
	procedure FormCreate(Sender: TObject);
	procedure FormDestroy(Sender: TObject);
  Private
	{ Private declarations }
  Public
	{ Public declarations }
  End;

Var
  MainMenu : TMainMenu;

Implementation

{$R *.DFM}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                   Functions start here!                           * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }




{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMainMenu.VocabClick(Sender: TObject);
Begin
{$IFDEF DEBUGGING}
	DebugWindow.AddText('Entering Vocab');
{$ENDIF}
	VocabDlg.ShowModal;
End;	{vocab}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMainMenu.ShowAbout(Sender: TObject);
Begin
{$IFDEF DEBUGGING}
	DebugWindow.AddText('Showing About Box');
{$ENDIF}
	AboutBox.ShowModal;
End;	{about}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMainMenu.LocationsClick(Sender: TObject);
Begin
{$IFDEF DEBUGGING}
	DebugWindow.AddText('Entering Locations');
{$ENDIF}
	LocationDlg.ShowModal;
End;	{locations}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMainMenu.MessagesClick(Sender: TObject);
Begin
{$IFDEF DEBUGGING}
	DebugWindow.AddText('Entering Messages');
{$ENDIF}
	MessageDlg.ShowModal;
End;	{messages}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMainMenu.ObjectsClick(Sender: TObject);
Begin
{$IFDEF DEBUGGING}
	DebugWindow.AddText('Entering Objects');
{$ENDIF}
	ObjectDlg.ShowModal;
End;	{objects}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMainMenu.FormShow(Sender: TObject);
Begin
	Vocab.SetFocus;
{$IFDEF DEBUGGING}
	DebugWindow.Show;
	DebugWindow.AddText('PROGRAM START');
	DebugWindow.AddText(' ');
{$ENDIF}
	Vocab.SetFocus;
End;	{form show}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMainMenu.ConnexionsClick(Sender: TObject);
Begin
{$IFDEF DEBUGGING}
	DebugWindow.AddText('Entering Connections');
{$ENDIF}
	ConnectMenu.ShowModal;
End;	{connections}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMainMenu.InternalClick(Sender: TObject);
Begin
{$IFDEF DEBUGGING}
	DebugWindow.AddText('Entering Internal Messages');
{$ENDIF}
	IntMsgDlg.ShowModal;
End;	{internal}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMainMenu.TestButtonClick(Sender: TObject);
{in order to play the game, the database must contain:
	at least one location
	at least action table
	a verb
	internal messages}
Var
	IntMessPresent, VocabPresent, TablePresent, LocPresent, StartPresent : Boolean;
Begin
	If IntMessages.Count = 0 Then IntMessPresent := False
		Else IntMessPresent := True;

	If LocationList.Count = 0 Then LocPresent := False
		Else LocPresent := True;

	If TableList.Count = 0 Then TablePresent := False
		Else TablePresent := True;

	If VocabList.Count = 0 Then VocabPresent := False
		Else VocabPresent := True;

	If (StartLoc = 0) Then StartPresent := False
		Else StartPresent := True;

	If ((VocabPresent = True) And
		(LocPresent = True) And
		(TablePresent = True) And
		(IntMessPresent = True) And
		(StartPresent = True)) Then
	Begin
{$IFDEF DEBUGGING}
		DebugWindow.AddText('Entering TEST');
{$ENDIF}
		TestUnit.ShowModal
	End Else Begin
		Application.Messagebox(
			'Unable to play the game, because one or more of'+#13+#10+
			'Locations, Internal Messages, Action Tables or Vocabulary'+#10+#13+
			'is missing, or str game''s Starting Location has not been defined.'+#10+#13+
			'Correct the problem and try again',
			'Error',
			mb_OK + mb_IconInformation);
	End;
End;	{test}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

procedure TMainMenu.BitBtn2Click(Sender: TObject);
begin
{$IFDEF DEBUGGING}
	DebugWindow.Close;
{$ENDIF}
	Close;
end;

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{$IFDEF DEBUGGING}
procedure TMainMenu.CheckBox1Click(Sender: TObject);
begin
	DebugStatus := Not(DebugStatus);
	If DebugStatus = True Then DebugWindow.Show
	Else DebugWindow.Hide;
	MainMenu.BringToFront;
end;
{$ELSE}
procedure TMainMenu.CheckBox1Click(Sender: TObject);
begin
{DOES NOTHING}
End;
{$ENDIF}

procedure TMainMenu.ActionsClick(Sender: TObject);
begin
	ActDlg.ShowModal;
end;

procedure TMainMenu.MiscBtnClick(Sender: TObject);
begin
	MiscOpt.ShowModal;
end;

procedure TMainMenu.FormCreate(Sender: TObject);
Var
	MiscFile : File of Word;
begin
{$IFnDEF DEBUGGING}
	CheckBox1.Visible := False;
	Label1.Visible := True;
{$ENDIF}
	If FileExists('PROJECT.MSC') Then
	Begin
		AssignFile(MiscFile,'PROJECT.MSC');
		Reset(MiscFile);

		Read(MiscFile,StartLoc);
		Read(MiscFile,MaxObj);
		Read(MiscFile,MaxWt);

		CloseFile(MiscFile);
	End;
end;

procedure TMainMenu.FormDestroy(Sender: TObject);
Var
	MiscFile : File of Word;
begin
	AssignFile(MiscFile,'PROJECT.MSC');
	ReWrite(MiscFile);

	Write(MiscFile,StartLoc);
	Write(MiscFile,MaxObj);
	Write(MiscFile,MaxWt);

	CloseFile(MiscFile);
end;

End.	{MAIN MENU}
