unit MdyWrd;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls;

type
  TMdyWrdDlg = class(TForm)
    Bevel1: TBevel;
    Edit1: TEdit;
    Word: TLabel;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Label2: TLabel;
    Edit2: TEdit;
    OkBtn: TButton;
    CancelBtn: TButton;
    procedure OKBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MdyWrdDlg: TMdyWrdDlg;

implementation

{$R *.DFM}

{**************************************************************************}
function FindWordInVocab(Word : string) : Boolean;
Begin
     FindWordInVocab:=False;
End;

{**************************************************************************}
function IsValidType(WordType : string) : Boolean;
const
     WordTypes : Array[1..7] of String = ('Verb', 'Noun', 'Adjective', 'Adverb',
               'Conjunction', 'Preposition', 'Other');
var
   Index : Integer;
Begin
     IsValidType:=False;      {assume failure}
     For Index:=1 to 7 Do
         If WordType =WordTypes[Index] Then IsValidType:=True; {gotcha!}
End;

{**************************************************************************}
function IsValueOkay(ValueAsText : string) : Boolean;
Begin
     IsValueOkay:=True;
End;

{**************************************************************************}
function CheckValidInputs(Word, WordType, Value : string) : Boolean;
const
     InvalidTypeMsg = 'is an invalid word type. Types are: Verb, Noun, Adjective, Adverb, Conjunction, Preposition, Other';
var
   Okay : Boolean;
Begin
     Okay := True;  {Assume okay}

     if (FindWordInVocab(Word) = True) Then
     Begin
          Application.MessageBox('Word Entered is already in Vocabulary','Error',mb_OK);
          Okay := False;
     End;

     if (IsValidType(WordType) = False) Then
     Begin
          Application.MessageBox('Invalid Word Type','Error', mb_OK);
          Okay := False;
     End;

     if (IsValueOkay(Value) = False) Then
     Begin
          Application.MessageBox('Value for new word must be between 0 and 65535','Error',mb_OK);
          Okay := False;
     End;

     CheckValidInputs := Okay;          {copy the variable, not assign it 'okay'!}
End;

{**************************************************************************}
procedure TMdyWrdDlg.OKBtnClick(Sender: TObject);
begin
     If (CheckValidInputs(Edit1.Text, ComboBox1.Text, Edit2.Text) = True) Then
        {save word to file?}
        ModalResult:=1      {indicates that we pressed 'ok'}
     else
         ModalResult:=0;    {basically, ignore the button click :) }
end;

end.
