Unit Mesmenu;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * *                                                                   * * * }
{ * * *  The purpose of this unit is to provide the menu for the          * * *}
{* * *    messages part of the program.  It shows the dialog box, and    * * * }
{ * * *   will respond to mouse clicks on the various buttons, in the     * * *}
{* * *    same way as the main menu does.  Five buttons are provided:    * * * }
{ * * *   Add, Delete, Change, and View Messages, and Exit to Main Menu   * * *}
{* * *                                                                   * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Interface

{$IFDEF DEBUGGING}
Uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, ChngLoc, EntrNum, MesStuff, StdCtrls, Buttons, NoMesgs,
	Debug, Globals;
{$ELSE}
Uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, ChngLoc, EntrNum, MesStuff, StdCtrls, Buttons, NoMesgs,
	Globals;
{$ENDIF}

Type
	TMessageDlg = Class(TForm)
		NewMessage    : TBitBtn;
		DelMessage    : TBitBtn;
		ModifyMessage : TBitBtn;
		ViewMessages  : TBitBtn;
		Exit          : TBitBtn;
		Procedure NewMessageClick(Sender: TObject);
		Procedure ModifyMessageClick(Sender: TObject);
		Procedure DelMessageClick(Sender: TObject);
		Procedure ViewMessagesClick(Sender: TObject);
		Procedure FormCreate(Sender: TObject);
		Procedure FormDestroy(Sender: TObject);
		Procedure FormShow(Sender: TObject);
	procedure ExitClick(Sender: TObject);
	Private
		{ Private declarations }
	Public
		{ Public declarations }
	End;

Var
	MessageDlg  : TMessageDlg;

Implementation

{$R *.DFM}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                   Functions start here!                           * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }




{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMessageDlg.NewMessageClick(Sender: TObject);
{called when the user clicks the 'new message' button.
Procedure:	1. Find first free message number
			2. Prompt the user for the message
			3. Enter new message into list
			4. Sort list into numeric order}
Var
	P          : Pchar;
	Index      : Word;
	ErrCode    : Word;			{used to show if string copied okay}
	NewMessage : MGameMessage;
	MesNum     : Word;			{The number of the new message}
Begin
{$IFDEF DEBUGGING}
	DebugWindow.AddText('  New Messages Clicked');
{$ENDIF}
	ChangeLocDlg.Caption:='Add Message';
	ChangeLocDlg.Label1.Caption := 'Message:';
	MesNum := GetFirstFreeMessageNumber;
	If MesNum = 65535 Then		{oops...no more room!}
	Begin
{$IFDEF DEBUGGING}
		DebugWindow.AddText('    Can''t add message');
{$ENDIF}
		NoMoreMessagesDlg.ShowModal
	End Else Begin
		ChangeLocDlg.LocationNumber.Caption := IntToStr(MesNum);
			{print the number of the message text we are changing}
		If (ChangeLocDlg.ShowModal = 1) Then		{show the dialog}
		Begin	{User pressed ok}
			Index:=ChangeLocDlg.Memo1.GetTextLen;	{get the length of the
													text entered}
			If Index = 0 Then
			Begin
{$IFDEF DEBUGGING}
				DebugWindow.AddText('    Message Entered invalid');
{$ENDIF}
				Application.MessageBox(
					'Message Text is zero bytes long.  Message not created.',
					'Messages',
					mb_OK + mb_ICONEXCLAMATION)
			End Else Begin
{$IFDEF DEBUGGING}
				DebugWindow.AddText('    Message entered OK');
{$ENDIF}
				GetMem(P,Index+1);	{allocate a block of Index bytes,
									starting at P, allow for terminating NULL}
				ErrCode:= ChangeLocDlg.Memo1.GetTextBuf(P,Index+1);
									{copy the string to our memory}
				If ErrCode <> Index Then
				Begin
					Application.MessageBox(
						'String copy failed!',
						'Error',
						mb_OK + mb_ICONEXCLAMATION)
				End Else Begin
					NewMessage := MGameMessage.Create(MesNum, P);
													{Create our new message}
					MessageList.Add(NewMessage);	{Add it to the list}

{$IFDEF DEBUGGING}
					DebugWindow.AddText('    Message Entered into List');
{$ENDIF}
					SortList;	{Sort the list into ascending order on
								message number}
				End;	{If}
			End;	{we have text in box}
		End;
		ChangeLocDlg.Memo1.Clear;	{Clear the dialog box's edit box}
		ChangeLocDlg.Label1.Caption := 'Location:';
	End;
{$IFDEF DEBUGGING}
	DebugWindow.AddText('  Return to menu');
	DebugWindow.AddText(' ');
{$ENDIF}
End;	{new message}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMessageDlg.ModifyMessageClick(Sender: TObject);
{called when the user clicks 'modify message'.  Allows the user to change the
text of a message.
Procedure:	1. Get number of message to change.
			2. Retrieve that message, put it into editable form
			3. Allow the user to edit it
			4. Delete message from list
			5. Re-enter (new) message into list

Basically, the procedure retrieves a message, deletes it, and then the message
 is treated as a new message}
Var
	P          : Pchar;
	Index      : Word;
	ErrCode    : Word;			{used to show if string copied okay}
	NewMessage : MGameMessage;
	ListIndex  : Word;			{used to get the index in the list of the
								message we want to modify}
Begin
{$IFDEF DEBUGGING}
	DebugWindow.AddText('  Modify Message Clicked');
{$ENDIF}

	EnterNumberDlg.Caption := 'Enter Message Number';
	EnterNumberDlg.Label1.Caption := 'Enter the number of the message you wish to change.';
	EnterNumberDlg.ShowModal;	{show the 'get number' dialog}
	If (EnterNumberDlg.ModalResult = idOK) Then		{did the user press 'OK'?}
	Begin								{inside the loop - yes}
{$IFDEF DEBUGGING}
		DebugWindow.AddText('    User entered number');
{$ENDIF}

		ListIndex := FindMessage(StrToInt(EnterNumberDlg.SpinEdit1.Text));
		If ListIndex = 65535 Then
		Begin
{$IFDEF DEBUGGING}
			DebugWindow.AddText('      Invalid number entered');
{$ENDIF}
			Application.MessageBox(
				'There is no message with that number',
				'Error',
				mb_OK + mb_ICONEXCLAMATION);
		End Else
		Begin
{$IFDEF DEBUGGING}
			DebugWindow.AddText('      Number entered OK');
{$ENDIF}
			ChangeLocDlg.Label1.Caption := 'Message:';
			ChangeLocDlg.LocationNumber.Caption :=
					EnterNumberDlg.Spinedit1.Text;
					{print the number of the message text we are changing}
			ChangeLocDlg.Caption := 'Modify Message Text';
					{because this dialog box is also used by locations, change
					its title}
			NewMessage:=MessageList.Items[ListIndex];
			ChangeLocDlg.Memo1.Lines.Add(NewMessage.Message.Text);
			If (ChangeLocDlg.ShowModal = 1) Then		{show the dialog}
			Begin	{show the dialog}
{$IFDEF DEBUGGING}
				DebugWindow.AddText('    Message changed');
{$ENDIF}

				ChangeLocDlg.Label1.Caption := 'Location:';
				Index:=ChangeLocDlg.Memo1.GetTextLen;	{get the length of the text
														entered}
				GetMem(P,Index+1);	{allocate a block of Index bytes, starting at P}
				ErrCode:= ChangeLocDlg.Memo1.GetTextBuf(P,Index+1);
									{copy the string to our memory}
				If ErrCode <> Index Then
				Begin
					Application.MessageBox(
						'String copy failed!',
						'Error',
						mb_OK + mb_ICONEXCLAMATION)
				End Else Begin
					NewMessage := MGameMessage.Create(
						StrToInt(EnterNumberDlg.SpinEdit1.Text),
						P);

					MessageList.Delete(ListIndex);
					MessageList.Add(NewMessage);

{$IFDEF DEBUGGING}
					DebugWindow.AddText('    Message entered into list');
{$ENDIF}

					SortList;	{Sort the list into ascending order on message
								number}
				End;	{If}
			End Else	{User pressed ok in change dialog}
{$IFDEF DEBUGGING}
				DebugWindow.AddText('    Message change cancelled');
{$ENDIF}
		End;	{valid message number found}
	End;	{clicked okay in enter num dlg, not cancel}
{$IFDEF DEBUGGING}
	DebugWindow.AddText('  Return to menu');
	DebugWindow.AddText(' ');
{$ENDIF}
End;	{modify message}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMessageDlg.DelMessageClick(Sender: TObject);
{prompt the user for a message number, and then delete it from the list}
Var
	MesNum      : Word;
	MessageText : Array[0..14] of Char;
Begin
{$IFDEF DEBUGGING}
	DebugWindow.AddText('  Delete message clicked');
{$ENDIF}

	If MessageList.Count = 0 Then
	Begin
{$IFDEF DEBUGGING}
		DebugWindow.AddText('    No messages in list');
{$ENDIF}
		Application.MessageBox(
			'There are no messages in the database',
			'Error',
			mb_OK + mb_ICONEXCLAMATION)
	End Else Begin
    	EnterNumberDlg.Caption := 'Enter Message Number';
		EnterNumberDlg.Label1.Caption := 'Enter number of message to delete:';
		EnterNumberDlg.ShowModal;				{show the 'get number' dialog}
		if (EnterNumberDlg.ModalResult = idOK) Then	{did the user press 'OK'?}
		Begin										{inside the loop - yes}
{$IFDEF DEBUGGING}
			DebugWindow.AddText('    Message Entered');
{$ENDIF}
			MesNum := FindMessage(StrToInt(EnterNumberDlg.SpinEdit1.Text));
			If MesNum = 65535 Then	{oops, a message with that number was NOT
									found!!}
			Begin
{$IFDEF DEBUGGING}
				DebugWindow.AddText('      Invalid message number');
{$ENDIF}
				Application.MessageBox(
					'There is no message with that number',
					'Error',
					mb_OK + mb_ICONEXCLAMATION)
			End Else Begin
{$IFDEF DEBUGGING}
				DebugWindow.AddText('      Message number valid');
{$ENDIF}
				StrPCopy(MessageText,'Message '+EnterNumberDlg.SpinEdit1.Text);
				If (Application.MessageBox(
						'Are you sure you want to delete this message?',
						MessageText,
						mb_OKCancel + mb_ICONQUESTION)
					) = 1 Then	{The user pressed OK}
				Begin
{$IFDEF DEBUGGING}
					DebugWindow.AddText('    Message Deleted');
{$ENDIF}
					MessageList.Delete(MesNum)
				End Else
{$IFDEF DEBUGGING}
					DebugWindow.AddText('    Message deletion cancelled');
{$ENDIF}
			End;
		End;
	End;
{$IFDEF DEBUGGING}
	DebugWindow.AddText('  Return to menu');
	DebugWindow.AddText(' ');
{$ENDIF}
End;	{del messages}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMessageDlg.ViewMessagesClick(Sender: TObject);
{will just view the messages one at a time.  just puts a message in the change
dialog box, makes it read only, and shows it then exits, making it
read-write.  Will loop if more than one message}
Var
	Index       : Word;
	ThisMessage : MGameMessage;
Begin
{$IFDEF DEBUGGING}
	DebugWindow.AddText('  View Messages Clicked');
{$ENDIF}

	If MessageList.Count = 0 Then
	Begin
{$IFDEF DEBUGGING}
		DebugWindow.AddText('    No messages in list');
{$ENDIF}
		Application.MessageBox(
			'There are no messages in this game yet!',
			'View Messages',
			mb_OK + mb_ICONINFORMATION);
	End Else
	Begin
{$IFDEF DEBUGGING}
		DebugWindow.AddText('    Show messages');
{$ENDIF}
		For Index:=0 to MessageList.Count-1 Do
		Begin
			ThisMessage := MessageList.Items[Index];

			ChangeLocDlg.Caption := 'View Messages';
			ChangeLocDlg.Label1.Caption := 'Message:';
			ChangeLocDlg.LocationNumber.Caption :=
					IntToStr(ThisMessage.Message.Value);
			ChangeLocDlg.Memo1.ReadOnly := True;
			ChangeLocDlg.Memo1.Lines.Add(ThisMessage.Message.Text);
			ChangeLocDlg.ShowModal;
			ChangeLocDlg.Memo1.ReadOnly := False;
			ChangeLocDlg.Label1.Caption := 'Location:';
			ChangeLocDlg.Memo1.Clear;
		End;
	End;	{else}
{$IFDEF DEBUGGING}
	DebugWindow.AddText('  Return to menu');
	DebugWindow.AddText(' ');
{$ENDIF}
End;	{view messages}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMessageDlg.FormCreate(Sender: TObject);
{this is called at the start of the program when Windows creates the dialog
boxes.  NOTE that they are created on startup, and only shown when necessary.
This is a good time to load the data file}
Var
	MessageFile    : File of Byte;	{The file we will use to store the data}
						{format of data file is:
							Message Number : 2 bytes (1st +256*2nd)
							Length of text : 2 bytes (1st +256*2nd)
							Text : n bytes

							NOTE: Text INCLUDES the terminating NULL}
	NewMessage		: MGameMessage;	{A TObject used to store the message data}
	NewMesValue		: Word;		{Temporary variable to hold new message number}
	TempByte		: Byte;
	MessageText		: AnsiString;	{will hold text}
Begin
	MessageList := Tlist.Create;	{Create a new instance of our list}

	If FileExists('Project.Msg') Then
	Begin
		AssignFile(MessageFile,'Project.Msg');	{this bit loads an existing}
		Reset(MessageFile);						{message file}
		While Not(Eof(MessageFile)) Do
		Begin
			Read(MessageFile,TempByte);
			NewMesValue := TempByte;
			Read(MessageFile, TempByte);
			NewMesValue:=NewMesValue+(256*TempByte);	{now holds message number}

			MessageText := '';
			Read(MessageFile,TempByte);
			While TempByte <> 26 Do
			Begin
				MessageText := MessageText + Chr(TempByte);
				Read(MessageFile,TempByte);
			End;

			NewMessage := MGameMessage.Create(
							NewMesValue,
							MessageText);

			MessageList.Add(NewMessage);
		End;

		CloseFile(MessageFile);
	End;
End;	{formcreate}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMessageDlg.FormDestroy(Sender: TObject);
{similarly to FormCreate above, this is called when the program exits.
Good time to save the data file}
Var
	MessageFile : File of Byte;
	Index,
	Counter     : Word;
	MesNum      : Word;
	TempMes     : MGameMessage;
	TempByte    : Byte;
Begin
	AssignFile(MessageFile,'Project.Msg');
	ReWrite(MessageFile);

	If MessageList.Count <> 0 Then
	{only save the list if it has some items!}
		For Counter:=0 to MessageList.Count-1 Do
		Begin
			TempMes := MessageList.Items[Counter];

			MesNum:=TempMes.Message.Value;			{ write the}
			TempByte:=MesNum MOD 256;				{ number of}
			Write(MessageFile,TempByte);			{ the message}
			TempByte:=MesNum DIV 256;				{ to the}
			Write(MessageFile,TempByte);			{ message file}

			For Index := 1 to Length(TempMes.Message.Text) Do	{ write the}
			Begin												{ message}
				TempByte:=Ord(TempMes.Message.Text[Index]);		{ to}
				Write(MessageFile,TempByte);					{ the}
			End;												{ file}

			TempByte := 26;
			Write(MessageFile,TempByte);
		End;

	CloseFile(MessageFile);
	MessageList.Free;		{Free the message list and its memory}
End;	{formdestroy}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMessageDlg.FormShow(Sender: TObject);
{this is called when the dialog box is made visible.  It is not possible to
predict which part of the box will have the focus, so set the focus to the
New Message button, for neatness}
Begin
	NewMessage.SetFocus;
End;	{form show}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TMessageDlg.ExitClick(Sender: TObject);
{called when the user presses the 'exit' button}
Begin
{$IFDEF DEBUGGING}
	DebugWindow.AddText('Return to Main Menu');
	DebugWindow.AddText(' ');
{$ENDIF}
    Close;
End;	{exit click}

End.	{MESSAGE MENU}
