Unit MesStuff;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * *                                                                   * * * }
{ * * *  The purpose of this unit is to provide a series of routines      * * *}
{* * *    which deal with the messages part of the database.  They       * * * }
{ * * *   provide functions which make accessing the messages easier.     * * *}
{* * *                                                                   * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Interface

Uses
	Classes, SysUtils, Forms, WinTypes, Debug, Graphics, Globals;

Type
	GameMessage = Record
		Value : Word;	{the message's number, 0-65500}
		Text : AnsiString;	{the text, a pointer to its first char}
	End;

	MGameMessage = Class(TObject)
		Message : GameMessage;	{have to overload the class definition}
									{for TObject, to that a TList, i.e. our}
									{list of messages, will hold a Message}
									{as each node}
		Constructor
			Create(Value : Word; Text : AnsiString);	{create our constructor}
		Public
	End;	{MGameMessage}

	Function FindMessage(Number : Word) : Word;
	Function GetFirstFreeMessageNumber : Word;
	Procedure SortList;		{Used to sort the list}

Implementation

Uses
	MesMenu;

Constructor MGameMessage.Create(Value : Word; Text : AnsiString);
{

			no checks are made on the data here

}
Begin
	Message.Value := Value;
	Message.Text := Text;
End;


Function FindMessage(Number : Word) : Word;
{Checks if the message number specified is used already.
Returns:	list index number if so
			65535 if not}
Var
	ThisMessage : MGameMessage;	{temp var}
	Index : Word;		{counter}
	Found : Word;		{local copy of true/false}
Begin
	Found := 65535;		{assume failure}
	If MessageList.Count <> 0 Then
	Begin
		For Index:=0 to MessageList.Count -1 Do	{loop through list, check each message}
		Begin
			ThisMessage := MessageList.Items[Index];
			If ThisMessage.Message.Value = Number Then Found := Index;	{found it}
		End;
	End;

	FindMessage := Found;	{return our true/false status}
End;

{***************************************************************************}
Function GetFirstFreeMessageNumber : Word;
{Using the List of messages, return the first available message number,}
{ in the range 0-65500, or 65535 if there are no free numbers}
Var
	MesNumberArray : PChar;
	Index : Word;
	TempMessage : MGameMessage;
Begin
	If MessageList.Count = 0 Then	{no items in list}
	Begin
		GetFirstFreeMessageNumber := 1;
		Exit;
	End;

	GetMem(MesNumberArray,65502);

	For Index:=0 to 65500 Do
		MesNumberArray[Index] := '0';

	For Index:=0 to MessageList.Count-1 Do
	Begin
		TempMessage:=MessageList.Items[Index];
		MesNumberArray[TempMessage.Message.Value]:='1';
	End;

	For Index:=1 To 65500 Do
	Begin
		If MesNumberArray[Index]='0' Then
		Begin
			GetFirstFreeMessageNumber:=Index;
			FreeMem(MesNumberArray,65502);
			Exit;
		End;
	End;

	FreeMem(MesNumberArray,65502);
	GetFirstFreeMessageNumber := 65535;	{I.e. no room left}
End;	{Get first free message number}


{***************************************************************************}
Procedure SortList;
{sort the list into ascending numerical order}

	Function Sort : Boolean;
	Var
		Done : Boolean;
		Index : Word;
		ThisMessage, NextMessage : MGameMessage;
	Begin
		Done := False;
		If (MessageList.Count = 0) or (MessageList.Count = 1) Then
			Sort := False	{A list with 0 or 1 items is always sorted}
		Else
		Begin
			For Index:=0 to MessageList.Count-2 Do
			Begin
				ThisMessage:=MessageList.Items[Index];
				NextMessage:=MessageList.Items[Index+1];
				If ThisMessage.Message.Value > NextMessage.Message.Value Then
				Begin
					MessageList.Exchange(Index, Index+1);
					Done := True;	{To say that we exchanged at least one item}
				End;
			End;
		End;
		Sort := Done;
	End;

Begin
	Repeat					{just sort and sort until erm, sorted}
	Until Sort = False;		{uses Bubblesort technique}
End;

End.
