unit Newentry;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, VcbStuff;

type
  TNewEntryDlg = class(TForm)
	Label1: TLabel;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    VerbBox: TEdit;
    NounBox: TEdit;
    CancelButton: TBitBtn;
	OkButton: TBitBtn;
	procedure OkButtonClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  NewEntryDlg : TNewEntryDlg;

implementation

{$R *.DFM}

procedure TNewEntryDlg.OkButtonClick(Sender: TObject);
Var
	ValidVerb : Boolean;
	ValidNoun : Boolean;
begin
	ValidVerb := False;
	ValidNoun := False;	{Assume failure}

	If ((VerbBox.Text <> '*') And (VerbBox.Text <> '#')) Then
	Begin
		If (FindWordInVocab(VerbBox.Text) = True) Then
		Begin
			If (GetWordType(VerbBox.Text) <> Verb) Then
			Begin
				Application.MessageBox('The word specified in the ''Verb'' box is not a verb',
										'Error',
										mb_OK + mb_ICONEXCLAMATION);
				VerbBox.SetFocus
			End Else Begin
				ValidVerb := True;
			End;	{if}
		End Else Begin
			Application.MessageBox('The word specified in the ''Verb'' box was not found',
									'Word not found',
									mb_OK + mb_ICONEXCLAMATION);
			VerbBox.SetFocus;
		End;	{If}
	End Else Begin
	{ '*' and '#' are special 'match all' characters, and are always valid}
		ValidVerb := True;
	End;	{if special cases}

	If (ValidVerb = True) Then
	Begin
		If ((NounBox.Text <> '*') And (NounBox.Text <> '#')) Then
		Begin
			If (FindWordInVocab(NounBox.Text) = True) Then
			Begin
				If (GetWordType(NounBox.Text) <> Noun) Then
				Begin
					Application.MessageBox('The word specified in the ''Noun'' box is not a Noun',
											'Error',
											mb_OK + mb_ICONEXCLAMATION);
					NounBox.SetFocus
				End Else Begin
					ValidNoun := True;
				End;	{if}
			End Else Begin
				Application.MessageBox('The word specified in the ''Noun'' box was not found',
										'Word not found',
										mb_OK + mb_ICONEXCLAMATION);
				NounBox.SetFocus;
			End;	{If}
		End Else Begin
		{ '*' and '#' are special 'match all' characters and are always valid}
        	ValidNoun := True;
		End;	{If special cases}
	End;	{if validverb}

	If ((ValidNoun = False) Or (ValidVerb = False)) Then ModalResult := 0;
end;

procedure TNewEntryDlg.FormShow(Sender: TObject);
begin
	VerbBox.SetFocus;
end;

end.
