Unit Objmenu;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * *                                                                   * * * }
{ * * *  The purpose of this unit is to provide the routines needed for   * * *}
{* * *    the menu interface to the object routines in the game.         * * * }
{ * * *                                                                   * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Interface

Uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, NewObj, ObjStuff, EntrNum, LocStuff,
  VcbStuff, Globals, FlagDef;

Type
  TObjectDlg = Class(TForm)
	NewObject: TBitBtn;
	ChngObject: TBitBtn;
	DelObject: TBitBtn;
	ViewObjs: TBitBtn;
	ExitBtn: TBitBtn;
	Procedure NewObjectClick(Sender: TObject);
	Procedure FormCreate(Sender: TObject);
	Procedure FormDestroy(Sender: TObject);
	Procedure ViewObjsClick(Sender: TObject);
	Procedure DelObjectClick(Sender: TObject);
	Procedure ChngObjectClick(Sender: TObject);
	Procedure FormShow(Sender: TObject);
  End;	{TObjectDlg}

Var
  ObjectDlg: TObjectDlg;

Implementation

{$R *.DFM}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                   Functions start here!                           * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }




{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TObjectDlg.NewObjectClick(Sender: TObject);
{create a new object.  Number is allocated automatically.  Rest is up to the
user.  checks are made on the data for validity, e.g. starting location actually
exists, etc.}
Var
	P : Array[0..32000] of Char;
	Index : Word;
	ErrCode : Word;	{used to show if string copied okay}
	ObjNum : Word;				{The number of the new object}
	StartingLoc : Word;
	ShortName : String[50];
	PresentString : String[100];
	ThisNoun, ThisAdjective : Word;
	Weight, Value : Word;
	Container, Wearable, Invisible : Boolean;
	RetCode : Integer;	{to check if create went ok}
Begin
	ResetDialogBox;
	ObjNum := Objects.GetFirstFreeNumber;
	NewObjDlg.ObjNumber.Caption := IntToStr(ObjNum);
	{print the number of the new object}
	If (NewObjDlg.ShowModal = 1) Then		{show the dialog}
	Begin	{User pressed ok}
		StartingLoc := StrToInt(NewObjDlg.StartLoc.Text);
		If (
			(StartingLoc <> 0) And
			(	(StartingLoc <> _WornLoc) Or
				(StartingLoc <> _CarriedLoc) Or
				(StartingLoc <> _NotCreatedLoc)
			)
		   ) Then
		Begin
			If FindLocation(StartingLoc) = 65535 Then
			Begin
				Application.MessageBox('The location specified as Starting Location for this object'+#10+#13+
										'does not exist.  It has been set to (not created).',
										'Notice',
										mb_OK + mb_ICONINFORMATION);
				StartingLoc := 0;
			End;
		End;

		ShortName := NewObjDlg.ShortName.Text;

		PresentString := NewObjDlg.ObjPresent.Text;

		If (NewObjDlg.NounBox.Text = '') Then
			ThisNoun := 0
		Else Begin
			If (GetWordType(NewObjDlg.NounBox.Text) = Noun) Then
			Begin
				ThisNoun := GetWordValue(NewObjDlg.NounBox.Text);
				If ThisNoun = 65535 Then	{noun not in vocab}
				Begin
					Application.MessageBox('Noun not found - it has been set to (none)',
											'Error',
											mb_OK + MB_ICONEXCLAMATION);
					ThisNoun := 0;
				End;
			End Else Begin
				Application.MessageBox('Word entered in noun box is not a noun!'+#13+#10+
										'It has been set to (none)',
										'Notice',
										mb_OK + mb_IconInformation);
				ThisNoun := 0;
			End;	{if word is noun}
		End;	{noun entered, not left blank}

		If (NewObjDlg.AdjectiveBox.Text = '') Then
			ThisAdjective := 0
		Else Begin
			If (GetWordType(NewObjDlg.AdjectiveBox.Text) = Adjective) Then
			Begin
				ThisAdjective := GetWordValue(NewObjDlg.AdjectiveBox.Text);
				If ThisAdjective = 65535 Then	{adjective not found}
				Begin
					Application.MessageBox('Adjective not found - it has been set to (none)',
											'Error',
											mb_OK + MB_ICONEXCLAMATION);
				ThisAdjective := 0;
				End;
			End Else Begin
				Application.MessageBox('Word entered in adjective box is not an adjective!'+#13+#10+
										'It has been set to (none)',
										'Notice',
										mb_OK + mb_IconInformation);
				ThisAdjective := 0;
			End;	{If word is adjective}
		End;	{adjective entered}

		Weight := NewObjDlg.WeightBox.Value;

		Value := NewObjDlg.ValueBox.Value;

		If NewObjDlg.Container.Checked = True Then
			Container := True
		Else
			Container := False;

		If NewObjDlg.Wearable.Checked = True Then
			Wearable := True
		Else
			Wearable := False;

		If NewObjDlg.Invisible.Checked = True Then
			Invisible := True
		Else
			Invisible := False;

		Index:=NewObjDlg.Memo1.GetTextLen;	{get the length of the text entered}
		If Index = 0 Then
		Begin
			NewObjDlg.Memo1.SetTextBuf(' ');	{Can't have zero bytes of text}
			Index := 1;
		End;

		ErrCode:= NewObjDlg.Memo1.GetTextBuf(P,Index+1);	{copy the string to our memory}
		If ErrCode <> Index Then
		Begin
			Application.MessageBox('String copy failed!','Error',mb_OK)
		End Else Begin
			RetCode := Objects.AddObject(ObjNum, StartingLoc, ThisNoun,
										ThisAdjective, Weight, Value, ShortName,
										PresentString, Container, Wearable,
										Invisible, Index, P);	{add the new objects to the list}
			Case RetCode Of
				-2 : Begin
						Application.MessageBox('There was already an object in the game with that number',
												'Create object Failed',
												mb_OK + mb_IconExclamation);
					End;
				-1 : Begin
						Application.MessageBox('There are already 65500 Objects in the game',
												'Create Object Failed',
												mb_OK + mb_IconExclamation);
					End;
				0 : Begin
						Application.MessageBox('Object Created',
												'Success',
												mb_OK + mb_IconInformation);
					End;
			End;	{Case}
		End;	{If}
	End;
End;	{NewObjectClick}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TObjectDlg.FormCreate(Sender: TObject);
{called when the form is created - which is at load time.  we want to load any
existing object file here.  the 'read from file' bit is between 'try...finally'
because if there is an error on loading the file, if the 'finally' isn't there,
it won't get closed at the end of the routine.....so at the end of the program,
we will get an 'i/o error 32' (sharing violation) when we try to re-create the
file, as it is open}
Var
	ObjectFile : File of Byte;
	Index : Word;
	TempByte : Byte;

	ObjNum : Word;
	ShortName : String[50];
	PresentString : String[100];
	StartingLoc : Word;
	ThisNoun, ThisAdjective : Word;
	Value, Weight : Word;
	Container, Invisible, Wearable : Boolean;
	DescLength : Word;
	P : Array[0..32001] Of Char;
Begin
	If FileExists('Project.Obj') Then
	Begin
		AssignFile(ObjectFile,'Project.Obj');
		Reset(ObjectFile);

		Try
			While Not(Eof(ObjectFile)) Do
			Begin
				Read(ObjectFile,TempByte);			{Read object}
				ObjNum := TempByte;					{number}
				Read(ObjectFile,TempByte);			{from}
				ObjNum := ObjNum+(256*TempByte);	{file}

				ShortName := '';							{read object's}
				Read(ObjectFile,TempByte);                  {short name from}
				While TempByte <> 26 Do                     {file until}
				Begin                                       {we get}
					ShortName := ShortName + Chr(TempByte); {to our}
					Read(ObjectFile,TempByte);              {marker - }
				End;                                        {#26}

				PresentString := '';								{read the}
				Read(ObjectFile,TempByte);                          {obj present}
				While TempByte <> 26 Do                             {string from}
				Begin                                               {file until}
					PresentString := PresentString + Chr(TempByte); {we reach}
					Read(ObjectFile,TempByte);                      {our marker}
				End;                                                {#26}

				Read(ObjectFile, TempByte);						{read the}
				StartingLoc := TempByte;						{2 bytes}
				Read(ObjectFile,TempByte);						{of object's}
				StartingLoc := StartingLoc + (256*TempByte);	{starting loc}

				Read(ObjectFile, TempByte);		{read the}
				ThisNoun := TempByte;				{2 bytes}
				Read(ObjectFile, TempByte);		{of object's}
				ThisNoun := ThisNoun + (256*TempByte);	{noun}

				Read(ObjectFile,TempByte);					{read the}
				ThisAdjective := TempByte;						{2 bytes}
				Read(ObjectFile,TempByte);					{of object's}
				ThisAdjective := ThisAdjective + (256 * TempByte);	{adjective}

				Read(ObjectFile,TempByte);				{read the}
				Weight := TempByte;                     {2 bytes}
				Read(ObjectFile,TempByte);              {of object's}
				Weight := Weight + (256 * TempByte);    {weight}

				Read(ObjectFile, TempByte);			{read the}
				Value := TempByte;                  {2 bytes}
				Read(ObjectFile, TempByte);         {of object's}
				Value := Value + (256 * TempByte); {value}

				Read(ObjectFile, TempByte);	{read value}
				If TempByte = 1 Then        {of container}
					Container := True       {flag}
				Else                        {from}
					Container := False;     {file}

				Read(ObjectFile, TempByte);	{read value}
				If TempByte = 1 Then        {of wearable}
					Wearable := True        {flag}
				Else                        {from}
					Wearable := False;      {file}

				Read(ObjectFile, TempByte);	{read value}
				If TempByte = 1 Then        {of invisible}
					Invisible := True         {flag}
				Else                        {from}
					Invisible := False;       {file}

				Read(ObjectFile, TempByte);						{read length}
				DescLength := TempByte;                         {of object's}
				Read(ObjectFile, TempByte);                     {description}
				DescLength := DescLength + (256 * TempByte);    {from file}

				For Index := 0 to DescLength Do		{finally, read}
				Begin                               {the description}
					Read(ObjectFile, TempByte);     {itself}
					P[Index] := Chr(TempByte);      {from}
				End;                                {file}

				Objects.AddObject(ObjNum, StartingLoc, ThisNoun, ThisAdjective,
								Weight,	Value, ShortName, PresentString,
								Container, Wearable, Invisible, DescLength, P);	{create the object}

			end;
		Finally
			CloseFile(ObjectFile);
		End;
	End;
End;	{FormCreate}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TObjectDlg.FormDestroy(Sender: TObject);
{as with 'form create' above.  This is where we save the object list to a file
for later re-use}
Var
	ObjectFile : File of Byte;
	Index,Counter : Word;
	ObjNum : Word;
	TempObj : GameObject;
	TempByte : Byte;
	TextLen : Word;
Begin
	AssignFile(ObjectFile,'Project.Obj');
	ReWrite(ObjectFile);

	If Objects.NumObjects <> 0 Then
	Begin
		For Counter:=0 to Objects.NumObjects -1 Do
		Begin
			TempObj := Objects.GetObjectAtIndex(Counter);

			ObjNum:=TempObj.ObjNumber;	{write}
			TempByte:=ObjNum MOD 256;	{objectt's}
			Write(ObjectFile,TempByte);	{number}
			TempByte:=ObjNum DIV 256;	{to}
			Write(ObjectFile,TempByte);	{file}

			TextLen:=Length(TempObj.ObjShortName);				{write short}
			For Index := 1 to TextLen Do						{name to file}
			Begin                                               {and}
				TempByte :=Ord(TempObj.ObjShortName[Index]);	{append}
				Write(ObjectFile,TempByte);						{with}
			End;												{marker}
			TempByte := 26;
			Write(ObjectFile,TempByte);							{#26}

			TextLen:=Length(TempObj.ObjPresentString);			{write}
			For Index := 1 to TextLen Do						{object}
			Begin												{present}
				TempByte:=Ord(TempObj.ObjPresentString[Index]);	{string}
				Write(ObjectFile,TempByte);						{to file and}
			End;												{append}
			TempByte := 26;										{with}
			Write(ObjectFile,TempByte);								{marker : #26}

			TempByte:=TempObj.ObjStartingLoc MOD 256;	{     <-	}
			Write(ObjectFile,TempByte);					{	  <- write the starting}
			TempByte:=TempObj.ObjStartingLoc DIV 256;	{	  <- location to file}
			Write(ObjectFile,TempByte);					{	  <-	}


			TempByte:=TempObj.ObjNoun MOD 256;	{     <-	}
			Write(ObjectFile,TempByte);			{	  <- write the object's}
			TempByte:=TempObj.ObjNoun DIV 256;	{	  <- noun to file}
			Write(ObjectFile,TempByte);			{	  <-	}

			TempByte:=TempObj.ObjAdjective MOD 256;	{     <-	}
			Write(ObjectFile,TempByte);					{	  <- write the object's}
			TempByte:=TempObj.ObjAdjective DIV 256;	{	  <- adjective to file}
			Write(ObjectFile,TempByte);					{	  <-	}

			TempByte:=TempObj.ObjWeight MOD 256;	{     <-	}
			Write(ObjectFile,TempByte);				{	  <- write the object's}
			TempByte:=TempObj.ObjWeight DIV 256;	{	  <- weight to file}
			Write(ObjectFile,TempByte);				{	  <-	}

			TempByte:=TempObj.ObjValue MOD 256;	{     <-	}
			Write(ObjectFile,TempByte);				{	  <- write the object's}
			TempByte:=TempObj.ObjValue DIV 256;	{	  <- value to file}
			Write(ObjectFile,TempByte);				{	  <-	}

			If TempObj.ObjContainer = True Then
			Begin
				TempByte := 1;                       {	<- write status}
				Write(ObjectFile,TempByte)			{	<- of container}
			End	Else Begin							{	<- flag to file}
				TempByte := 0;                       {	<-	}
				Write(ObjectFile,TempByte);
			End;

			If TempObj.ObjWearable = True Then
			Begin
				TempByte := 1;                           {	<- write status}
				Write(ObjectFile, TempByte)				{	<- of wearable}
			End Else Begin								{	<- flag to file}
				TempByte := 0;                           {	<-	}
				Write(ObjectFile,TempByte);
			End;

			If TempObj.ObjInvisible = True Then
			Begin
				TempByte := 1;						{	<- write status}
				Write(ObjectFile,TempByte)			{	<- of invisible}
			End Else Begin							{	<- flag to file}
				TempByte := 0;                      {	<-	}
				Write(ObjectFile,TempByte);
			End;

			TempByte:=TempObj.ObjDescLength MOD 256;	{ write the length}
			Write(ObjectFile,TempByte);					{of the object's}
			TempByte := TempObj.ObjDescLength DIV 256;	{description to the}
			Write(ObjectFile,TempByte);					{object file}

			For Index := 0 to TempObj.ObjDescLength Do			{finally, write}
			Begin												{the description}
				TempByte:=Ord(TempObj.ObjDescription[Index]);	{itself to the}
				Write(ObjectFile,TempByte);					{file}
			End;
		end;
	End;

	{NOTE for reading the file, order is:
		Number			(2)
		Short Name		(to a #26)
		Present string	(to a #26)
		Start Loc		(2)
		Noun			(2)
		Adjective		(2)
		Weight			(2)
		Value			(2)
		Container		(1)
		Wearable		(1)
		Invisible			(1)
		Length of desc	(2)
		Desc 			(x)

		Reading it in the wrong order will be disastrous! :) }

	CloseFile(ObjectFile);
End;	{FormDestroy}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TObjectDlg.ViewObjsClick(Sender: TObject);
{so that the user can view the objects in the game.  just fills up the 'enter
new object' dialog box with the data for each object, makes it read-only, and
shows it, then loops on to the next object}
Var
	Index:Word;
	ThisObject : GameObject;
Begin
	If Objects.NumObjects = 0 Then
	Begin
		Application.MessageBox('There are no objects in the database',
								'View Objects',
								mb_OK + mb_ICONINFORMATION);
	End Else
	Begin
		For Index:=0 to Objects.NumObjects -1 Do
		Begin
			NewObjDlg.ShortName.ReadOnly := True;
			NewObjDlg.ObjPresent.ReadOnly := True;
			NewObjDlg.Memo1.ReadOnly := True;
			NewObjDlg.StartLoc.ReadOnly := True;
			NewObjDlg.WeightBox.ReadOnly := True;
			NewObjDlg.ValueBox.ReadOnly := True;
			NewObjDlg.NounBox.Enabled := False;
			NewObjDlg.AdjectiveBox.Enabled := False;
			NewObjDlg.Container.Enabled := False;
			NewObjDlg.Invisible.Enabled := False;
			NewObjDlg.Wearable.Enabled := False;

			ThisObject := Objects.GetObjectAtIndex(Index);

			NewObjDlg.Caption := 'View Objects';

			NewObjDlg.ObjNumber.Caption := IntToStr(ThisObject.ObjNumber);
			NewObjDlg.ShortName.Text := ThisObject.ObjShortName;
			NewObjDlg.StartLoc.Value := ThisObject.ObjStartingLoc;
			NewObjDlg.ObjPresent.Text := ThisObject.ObjPresentString;
			NewObjDlg.Memo1.SetTextBuf(ThisObject.ObjDescription);
			If ThisObject.ObjNoun <> 0 Then
				NewObjDlg.NounBox.Text := GetWordFromVocab(ThisObject.ObjNoun, Noun)
			Else
				NewObjDlg.NounBox.Text := '(NONE)';
			If ThisObject.ObjAdjective <> 0 Then
				NewObjDlg.AdjectiveBox.Text := GetWordFromVocab(ThisObject.ObjAdjective, Adjective)
			Else
				NewObjDlg.AdjectiveBox.Text := '(NONE)';
			If ThisObject.ObjContainer = True Then NewObjDlg.Container.Checked := True;
			If ThisObject.ObjWearable = True Then NewObjDlg.Wearable.Checked := True;
			If ThisObject.ObjInvisible = True Then NewObjDlg.Invisible.Checked := True;
			NewObjDlg.WeightBox.Value := ThisObject.ObjWeight;
			NewObjDlg.ValueBox.Value := ThisObject.ObjValue;

			If NewObjDlg.ShowModal = mrCancel Then Break; {Index := ObjectList.Count -1;}
		End;
	End;
	ResetDialogBox;
End;	{ViewObjsClick}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TObjectDlg.DelObjectClick(Sender: TObject);
{prompt the user for an object number, and then delete it from the list}
Var
	IsFound : Boolean;
	ObjectText : Array[0..14] of Char;
Begin
	If Objects.NumObjects = 0 Then
		Application.MessageBox('There are no objects in the database.',
								'Error',
								mb_OK + mb_ICONEXCLAMATION)
	Else Begin
		EnterNumberDlg.Caption := 'Enter Object Number';
		EnterNumberDlg.Label1.Caption := 'Enter number of object to delete:';
		EnterNumberDlg.ShowModal;	{show the 'get number' dialog}
		If (EnterNumberDlg.ModalResult = idOK) Then	{did the user press 'OK'?}
		Begin								{inside the loop - yes}
			IsFound := Objects.FindObject(EnterNumberDlg.SpinEdit1.Value);
			If IsFound = False Then	{oops, an object with that number was NOT found!!}
				Application.MessageBox('There is no object with that number',
										'Error',
										mb_OK)
			Else
			Begin
				StrPCopy(ObjectText,'Object '+EnterNumberDlg.SpinEdit1.Text);
				If (Application.MessageBox('Are you sure you want to delete this object?',
										ObjectText,
										mb_OKCancel + mb_ICONQUESTION)) = 1 Then
				{The user pressed OK}
					Objects.DeleteObject(EnterNumberDlg.SpinEdit1.Value);
			End;
		End;
	End;
End;	{DelObjectClick}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TObjectDlg.ChngObjectClick(Sender: TObject);
{if the user made a mistake on an object, which will allow it to be changed.
basically, it is just a delete followed by a 'create new object'}
Var
	P : Array[0..32000] of Char;
	Index : Word;
	ErrCode : Word;	{used to show if string copied okay}
	NewObject : GameObject;
	ObjNum : Word;				{The number of the new object}
	StartingLoc : Word;
	ShortName : String[50];
	PresentString : String[100];
	ThisNoun, ThisAdjective : Word;
	Weight, Value : Word;
	Container, Wearable, Invisible : Boolean;
	IsFound : Boolean;
	RetCode : Integer;
Begin
	EnterNumberDlg.Caption := 'Enter Object Number';
	EnterNumberDlg.Label1.Caption := 'Enter the number of the object you wish to change.';
	EnterNumberDlg.ShowModal;	{show the 'get number' dialog}
	If (EnterNumberDlg.ModalResult = idOK) Then	{did the user press 'OK'?}
	Begin								{inside the loop - yes}
		IsFound := Objects.FindObject(EnterNumberDlg.SpinEdit1.Value);
		If IsFound = False Then
		Begin
			Application.MessageBox('There is no object with that number',
									'Error',
									mb_OK + mb_IconExclamation)
		End Else
		Begin
			NewObject := Objects.GetObject(EnterNumberDlg.SpinEdit1.Value);

			NewObjDlg.Caption := 'View Objects';

			NewObjDlg.ObjNumber.Caption := IntToStr(NewObject.ObjNumber);
			NewObjDlg.ShortName.Text := NewObject.ObjShortName;
			NewObjDlg.StartLoc.Value := NewObject.ObjStartingLoc;
			NewObjDlg.ObjPresent.Text := NewObject.ObjPresentString;
			NewObjDlg.Memo1.SetTextBuf(NewObject.ObjDescription);
			If NewObject.ObjNoun <> 0 Then
				NewObjDlg.NounBox.Text := GetWordFromVocab(NewObject.ObjNoun, Noun)
			Else
				NewObjDlg.NounBox.Text := '(NONE)';
			If NewObject.ObjAdjective <> 0 Then
				NewObjDlg.AdjectiveBox.Text := GetWordFromVocab(NewObject.ObjAdjective, Adjective)
			Else
				NewObjDlg.AdjectiveBox.Text := '(NONE)';
			If NewObject.ObjContainer = True Then NewObjDlg.Container.Checked := True;
			If NewObject.ObjWearable = True Then NewObjDlg.Wearable.Checked := True;
			If NewObject.ObjInvisible = True Then NewObjDlg.Invisible.Checked := True;
			NewObjDlg.WeightBox.Value := NewObject.ObjWeight;
			NewObjDlg.ValueBox.Value := NewObject.ObjValue;

			If NewObjDlg.ShowModal = 1 Then		{show the dialog}
			Begin	{user pressed ok}
				Objects. DeleteObject(EnterNumberDlg.SpinEdit1.Value);

				ObjNum := StrToInt(NewObjDlg.ObjNumber.Caption);

				StartingLoc := StrToInt(NewObjDlg.StartLoc.Text);
				If (
					(StartingLoc <> 0) And
					(	(StartingLoc <> _CarriedLoc) And
						(StartingLoc <> _WornLoc) And
						(StartingLoc <> _NotCreatedLoc)
					)
				   ) Then
				Begin
					If FindLocation(StartingLoc) = 65535 Then
					Begin
						MessageBeep(0);
						Application.MessageBox('The location specified as Starting Location for this object'+#10+#13+
												'does not exist.  It has been set to (not created).',
												'Notice',
												mb_OK + mb_ICONINFORMATION);
						StartingLoc := 0;
					End;
				End;

				ShortName := NewObjDlg.ShortName.Text;

				PresentString := NewObjDlg.ObjPresent.Text;

				If ((NewObjDlg.NounBox.Text = '') Or
					(NewObjDlg.NounBox.Text = '(NONE)')) Then
					ThisNoun := 0
				Else Begin
					If (GetWordType(NewObjDlg.NounBox.Text) = Noun) Then
					Begin
						ThisNoun := GetWordValue(NewObjDlg.NounBox.Text);
						If ThisNoun = 65535 Then	{noun not in vocab}
						Begin
							Application.MessageBox('Noun not found - it has been set to (none)',
													'Error',
													mb_OK + MB_ICONEXCLAMATION);
							ThisNoun := 0;
						End;
					End Else Begin
						Application.MessageBox('Word entered in noun box is not a noun!'+#13+#10+
												'It has been set to (none)',
												'Notice',
												mb_OK + mb_IconInformation);
						ThisNoun := 0;
					End;	{if word is noun}
				End;	{noun entered, not left blank}

				If ((NewObjDlg.AdjectiveBox.Text = '') Or
					 (NewObjDlg.AdjectiveBox.Text = '(NONE)')) Then
					ThisAdjective := 0
				Else Begin
					If (GetWordType(NewObjDlg.AdjectiveBox.Text) = Adjective) Then
					Begin
						ThisAdjective := GetWordValue(NewObjDlg.AdjectiveBox.Text);
						If ThisAdjective = 65535 Then	{adjective not found}
						Begin
							Application.MessageBox('Adjective not found - it has been set to (none)',
													'Error',
													mb_OK + MB_ICONEXCLAMATION);
						ThisAdjective := 0;
						End;
					End Else Begin
						Application.MessageBox('Word entered in adjective box is not an adjective!'+#13+#10+
												'It has been set to (none)',
												'Notice',
												mb_OK + mb_IconInformation);
						ThisAdjective := 0;
					End;	{If word is adjective}
				End;	{adjective entered}

				Weight := NewObjDlg.WeightBox.Value;

				Value := NewObjDlg.ValueBox.Value;

				If NewObjDlg.Container.Checked = True Then
					Container := True
				Else
					Container := False;

				If NewObjDlg.Wearable.Checked = True Then
					Wearable := True
				Else
					Wearable := False;

				If NewObjDlg.Invisible.Checked = True Then
					Invisible := True
				Else
					Invisible := False;

				Index:=NewObjDlg.Memo1.GetTextLen;	{get the length of the text entered}
				If Index = 0 Then
				Begin
					NewObjDlg.Memo1.SetTextBuf(' ');	{Can't have zero bytes of text}
					Index := 1;
				End;

				ErrCode := NewObjDlg.Memo1.GetTextBuf(P,Index+1);	{copy the string to our memory}

				If ErrCode <> Index Then
				Begin
					Application.MessageBox('String copy failed!','Error',mb_OK)
				End Else Begin
					RetCode := Objects.AddObject(ObjNum, StartingLoc, ThisNoun,
												ThisAdjective, Weight, Value, ShortName,
												PresentString, Container, Wearable,
												Invisible, Index, P);	{add the new objects to the list}
					Case RetCode Of
						-2 : Begin
								Application.MessageBox('There was already an object in the game with that number',
														'Modify object Failed',
														mb_OK + mb_IconExclamation);
							End;
						-1 : Begin
								Application.MessageBox('There are already 65500 Objects in the game',
														'Modify Object Failed',
														mb_OK + mb_IconExclamation);
							End;
						0 : Begin
								Application.MessageBox('Object Modified',
														'Success',
														mb_OK + mb_IconInformation);
							End;
					End;	{Case}
				End;	{If}
			End;	{user pressed on in change dialog box}
		End;	{object exists}
	End;	{user pressed on in enter number dialog box}
	ResetDialogBox;
End;	{ChngObjectClick}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TObjectDlg.FormShow(Sender: TObject);
{when the form is shown, make sure that the 'new object' button has the focus}
Begin
	NewObject.SetFocus;
End;	{FormShow}

End.	{ObjMenu}
