Unit Test;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * *                                                                   * * * }
{ * * *  This is the unit which deals with the 'test' part of the game -  * * *}
{* * *    i.e. it is here where user input is taken, and acted upon      * * * }
{ * * *   to produce a game!  basically, it gets the input and then       * * *}
{* * *    just passes it to the processing routine, which does all the   * * * }
{ * * *   rest of the work.  Routine in here to add text to the window    * * *}
{* * *    is present because no other unit can access this TMemo.        * * * }
{ * * *                                                                   * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Interface

Uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Menus, Text2Num, Debug, GameStuf, Act, FlagDef,
  Globals, Tsmcode;

Type
	TTestUnit = Class(TForm)
		Edit1: TEdit;
    Memo1: TSMemo;
    Memo2: TSMemo;
		Procedure Edit1KeyUp(Sender: TObject; Var Key: Word;
			Shift: TShiftState);
		Procedure FormShow(Sender: TObject);
		Procedure AddText(Text : AnsiString; NL : Boolean);
		Procedure CLS;
	procedure Memo1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure FormActivate(Sender: TObject);
	End;

Var
  TestUnit : TTestUnit;
  Flags : MGameFlags;
  Bulbs : MGameBulbs;
  NewLine : Boolean;	{used to check if the last thing that was printed in the
						window included a newline or not}

Implementation

Uses
	ActStuff;

{$R *.DFM}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                   Functions start here!                           * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }




{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                  Class TestUnit functions                         * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }


{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TTestUnit.Edit1KeyUp(Sender: TObject; var Key: Word;
								Shift: TShiftState);
{This is called whenever the user RELEASES a key, when the edit box has the
focus.  This is in effect when the user presses a key, but the OnKeyPress event
can't handle the RETURN key - which is the one we want to trap.  When the user
presses return, copy the text to the display window, act on the input}
Var
	TextInput : TCaption;
	Done : Boolean;	{Variable to tell if the game is over or not}
	ErrorPosition : Integer;	{Position of an error in the user input string}
Begin
	Done := False;

	If ((Key = VK_RETURN) And (Edit1.Text <> '')) Then	{User pressed return}
	Begin
		ErrorPosition := 0;

		AddText(Edit1.Text,True);
{		Memo1.Lines.Add(Edit1.Text);
		For Index := 0 to Memo2.Lines.Count -1 Do
		Begin
			If Memo1.Lines.Count > Memo1.MaxLinesVisible-2 Then Memo1.Lines.Delete(0);
			Memo1.Lines.Add(Memo2.Lines[0]);
			Memo2.Lines.Delete(0);
		End;
 }

		TextInput := Edit1.Text;

			{*********************************************}
			{** Get to here and we have user input, so  **}
			{**  go act on it!                          **}
			{*********************************************}

		TextInput := TextToKnownWords(TextInput);
		Flags.SetFlagValue(_GameTurns, Flags.GetFlagValue(_GameTurns) +1);
		If EndGame = True Then Done := True;
		If ErrorPosition <> 0 Then
		Begin
			DebugWindow.AddText('*****ERROR FOUND, AFTER WORD '+
								IntToStr(ErrorPosition)+
								'*****');
			AddText('Error found after word '+IntToStr(ErrorPosition), True);
			MessageBeep(0)
		End Else Begin
			Edit1.Text := '';			{ clear the input box }
			ShowPrompt;
		End;	{if errorposition <>0}
	End;	{If}

	If Done = True Then
	If Replay = True Then
	Begin
		Done := False;
		EndGame := False;
		SetupGame;
		DoDesc;
		ShowPrompt;
	End Else Close;
End;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TTestUnit.FormShow(Sender: TObject);
{called when the form is shown.  Basically set up the game, show the first
location, the prompt, process table 1 - in short, make sure everything is ready
for a game to be played}
Begin
	Memo1.GetMaxLines;
	Memo2.Width := Memo1.Width;
	Memo2.Height := Memo1.Height;
	Memo2.Font := Memo1.Font;
	Memo1.GetMaxLines;
	EndGame := False;
	Replay := False;
	Edit1.Align := alBottom;
	NewLine := True;	{make sure the print routine works}
{	SetupGame;
	DoDesc;
	ProcessActionTables(1,True);}
{	If EndGame = True Then Close;}
{	ShowPrompt;}
End;

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TTestUnit.AddText(Text : AnsiString; NL : Boolean);
{routine to add text to the window.  If the value of the 'newline' variable is
False, then the last time text was added to the window, it was not followed by a
newline, so we copy the last line of text in the window, plus the new text, then
delete the last line, and add the new stuff - it is as far as i can see the only
way of doing it!}
Var
	Index : Word;
	CurrentLine : String;
	ThisLine : AnsiString;
	MaxLines : Integer;
Begin
	MaxLines := Memo1.MaxLinesVisible -2;
	If Text = '^^^^^' Then
	{Special case - if the text to be added is '^^^^^', then it means 'add a
	blank line'}
	Begin
		If Memo1.Lines.Count > MaxLines Then Memo1.Lines.Delete(0);
		TestUnit.memo1.Lines.Add(' ');
		Exit;
	End;

	If NewLine = False Then
	{we want the text to be added to the window effectively to be the last line
	in the window plus the new text.  Then delete the last line, and add the new
	text as normal - that is the easiest way of doing it}
	Begin
		CurrentLine := Memo1.Lines[Memo1.Lines.Count];

		Memo1.Lines.Delete(Memo1.Lines.Count);

		ThisLine := CurrentLine + Text;
	End Else Begin
		ThisLine := Text;
	End;

	Memo2.Lines.Add(ThisLine);

	NewLine := NL;

	For Index := 0 to Memo2.Lines.Count -1 Do
	Begin
		If Memo1.Lines.Count > MaxLines Then Memo1.Lines.Delete(0);
		Memo1.Lines.Add(Memo2.Lines[0]);
		Memo2.Lines.Delete(0);
	End;


End;	{AddText}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TTestUnit.Memo1Click(Sender: TObject);
{If the user clicks on the memo box, move the input focus back to the edit box -
i.e. don't let the user click on the memo box!}
Begin
	Edit1.SetFocus;
End;	{Memo1click}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

Procedure TTestUnit.CLS;
{allow a 'clear screen' function, which empties the box}
Begin
	Memo1.Clear;
End;	{cls}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}

procedure TTestUnit.FormResize(Sender: TObject);
begin
	TestUnit.Height := 468;
	Memo2.Width := Memo1.Width;
	Memo1.GetMaxLines;
end;

procedure TTestUnit.FormActivate(Sender: TObject);
begin
	SetupGame;
	DoDesc;
	ProcessActiontables(2,False);
	ShowPrompt;
end;

End.	{Test}
