unit Vcbdlg;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, SysUtils, Spin, VcbStuff, Dialogs;

type
  TAddWordDlg = class(TForm)
	Edit1: TEdit;
	Word: TLabel;
	Label1: TLabel;
	ComboBox1: TComboBox;
	Label2: TLabel;
	Edit2: TSpinEdit;
	Label3: TLabel;
	BitBtn1: TBitBtn;
	BitBtn2: TBitBtn;
	procedure OKBtnClick(Sender: TObject);
	procedure FormShow(Sender: TObject);
  private
	{ Private declarations }
  public
	{ Public declarations }
  end;

var
  AddWordDlg: TAddWordDlg;

implementation

uses
	VocabMnu;

{$R *.DFM}

{**************************************************************************}
function CheckValidInputs(Word, WordType, Value : string) : Boolean;
var
	Okay : Boolean;
Begin
	Okay := True;  {Assume okay}

{check if the word is already in the vocabulary - if so, can't add it again!}

	if (FindWordInVocab(Word) = True) Then
	Begin
		Application.MessageBox('Word Entered is already in Vocabulary','Error',mb_OK);
		Okay := False;
	End;

{check to see if the user has typed in a valid word type}

	if (IsValidType(WordType) = False) Then
	Begin
		Application.MessageBox('Invalid Word Type','Error', mb_OK);
		Okay := False;
	End;

{don't need to check if the word value entered is okay, since the edit box will
	only accept numbers, and only if they are between 1 and 65500}

	CheckValidInputs := Okay;          {copy the variable, not assign it 'okay'!}
End;

{**************************************************************************}
procedure TAddWordDlg.OKBtnClick(Sender: TObject);
var
	NewWord : MGameVocab;
begin
	 If (CheckValidInputs(Edit1.Text, ComboBox1.Text, Edit2.Text) = True) Then
	 begin
		If Edit1.Text = '' Then		{a word must have at least 1 letter!}
			Application.MessageBox('Word has no letters!  Not created',
									'Error',
									mb_OK + MB_ICONEXCLAMATION)
		Else Begin
			NewWord := MGameVocab.Create(Edit1.Text, ComboBox1.Text, Edit2.Text);
			VocabList.Add(NewWord);
			ModalResult:=1;      {indicates that we pressed 'ok'}
		End
	 end else
		ModalResult:=0;    {If we reported an error, ignore the fact that we
							pressed ok, and give the user a chance to correct
							the problem}
end;


procedure TAddWordDlg.FormShow(Sender: TObject);
{When the dialog box is made visible, we set the cursor to be inside the 'word'
edit box, just for neatness}
begin
	Edit1.SetFocus;
end;

end.
