Unit Vocabmnu;

Interface

Uses
	SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, VcbDlg, StdCtrls, Buttons, ViewVcb, VcbStuff, DelWord;

Type
	TVocabDlg = class(TForm)
		NewWordBtn	: TBitBtn;
		ExitBtn		: TBitBtn;
		ViewBtn		: TBitBtn;
		DelWordBtn	: TBitBtn;

		Procedure NewWordBtnClick(Sender: TObject);
		Procedure ViewBtnClick(Sender: TObject);
		Procedure FormCreate(Sender: TObject);
		Procedure FormDestroy(Sender: TObject);
		Procedure DelWordBtnClick(Sender: TObject);
		Procedure FormShow(Sender: TObject);
	End;

Var
	VocabDlg	: TVocabDlg;
	VocabList 	: TList;	{Put it here, so it'll be available only when the
							vocab menu is on the screen - load on create, save
							on destroy}

Implementation

{$R *.DFM}

{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }
{* * *                                                                   * * * }
{* * *                   Functions start here!                           * * * }
{* * *                                                                   * * * }
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }




{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TVocabDlg.NewWordBtnClick(Sender: TObject);
{the user pressed 'new word'..so show the dialog box and add the new word
entered.  NOTE - code for this is in 'VcbDlg.pas'}
Begin
	AddWordDlg.ShowModal;

	{when we have finished, we want to clear the dialog box, or the next time
	the user presses 'new word', the data from the previous word will still
	be there}

	AddWordDlg.Edit1.Text := '';
	AddWordDlg.ComboBox1.Text := '';
	AddWordDlg.Edit2.Text := '';
End;	{NewWord}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TVocabDlg.ViewBtnClick(Sender: TObject);
{the user pressed 'view vocab', so loop through the list of words, and
add each one in turn to a list box (so can't change the data), then
show the dialog}
Var
	Index 			: Word;
	LengthCounter 	: Word;
	TempObject 		: MGameVocab;
	TempString 		: String;
Begin
	If VocabList.Count = 0 Then
	Begin
		Application.MessageBox('There are no words in the vocabulary yet!',
								'View Vocabulary',
								mb_OK + MB_ICONINFORMATION)
	End Else Begin
		For Index := 0 to VocabList.Count-1 Do
		Begin
			TempObject := VocabList.Items[Index];

			TempString:=IntToStr(TempObject.Vocabulary.WordValue);
			For LengthCounter:=Length(TempString) to 7 Do
				TempString:=TempString+' ';
			TempString:=TempString+TempObject.Vocabulary.Word;
			For LengthCounter:=Length(TempString) to 22 Do
				TempString:=TempString+' ';
			TempString:=TempString+
				TempObject.WTypeToString(TempObject.Vocabulary.WordType);
			ViewVcbDlg.ListBox1.Items.Add(TempString);
		End;
		ViewVcbDlg.ShowModal;
		ViewVcbDlg.ListBox1.Clear;	{empty the listbox}
	End;
End;	{View}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TVocabDlg.FormCreate(Sender: TObject);
{when the form is created, this happens EVERY time the program starts, load the
vocabulary file.  NOTE : this also means that if another part of the program
wants to access the data, they can use VocabList, just by including 'VocabMnu'
in the uses part of the unit.}
Var
	VocabFile	: TextFile;
	NewWord		: MGameVocab;
	Index		: Word;
	Temp		: String;
	TempWord	: String;
	TempWType	: String;
	TempVal		: String;
Begin
	VocabList := Tlist.Create;	{create a new instance of the vocab list}

	If FileExists('Project.Vcb') Then	{no point in trying to load a file
										that doesn't exist}
	Begin
		AssignFile(VocabFile,'Project.Vcb');	{this bit loads an existing}
		Reset(VocabFile);						{vocab file}
		While Not(Eof(VocabFile)) Do
		Begin
			ReadLn(VocabFile,Temp);			{saved as word, sp, val, sp, type}
			TempWord := '';
			TempWType := '';
			TempVal := '';
			Index:=1;
			While Temp[Index] <> ' ' Do
			Begin
				TempWord := TempWord+Temp[Index];
				Inc(Index);
			End;
			Inc(Index);		{Skip the separator}
			While Temp[Index] <> ' ' Do
			Begin
				TempVal:=TempVal+Temp[Index];
				Inc(Index);
			End;
			Inc(Index);		{Skip the separator}
			For Index:=Index To Length(Temp) Do
				TempWType:=TempWType+Temp[Index];

			NewWord := MGameVocab.Create(TempWord,TempWType,TempVal);

			VocabList.Add(NewWord);
		End;
		CloseFile(VocabFile);
	End;
End;	{Formcreate}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TVocabDlg.FormDestroy(Sender: TObject);
{similar to the above.  When the program exits, all forms are destroyed, so
we want to save the vocabulary list to a file for later use}
Var
	VocabFile	: TextFile;
	TempWord	: MGameVocab;
	Index		: Word;
Begin
	AssignFile(VocabFile,'Project.vcb');
	ReWrite(VocabFile);
	If VocabList.Count <>0 Then
{only try to save the list if it has some items in it!.  Else have to have an
	empty file}
		For Index:=0 to VocabList.Count-1 Do
		Begin
			TempWord:=VocabList.Items[Index];
			Writeln(VocabFile,TempWord.Vocabulary.Word+' '+
						IntToStr(TempWord.Vocabulary.WordValue)+' '+
						TempWord.WTypeToString(TempWord.Vocabulary.WordType));
		end;
	CloseFile(VocabFile);
	VocabList.Free;
End;	{formdestroy}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TVocabDlg.DelWordBtnClick(Sender: TObject);
{The user pressed 'delete word', so show the delete-a-word dialog box.
NOTE : Code for this is in 'DelWord.pas'}
Begin
	If VocabList.Count <>0 Then
	Begin
		DelWordDlg.ShowModal
	End Else Begin
		Application.MessageBox('There are no words in the database',
								'Error',
								mb_OK + MB_ICONEXCLAMATION);
	End;	{If}
End;	{Delword}

{ * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *}
{* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

Procedure TVocabDlg.FormShow(Sender: TObject);
Begin
	NewWordBtn.SetFocus;
End;	{FormShow}

End.	{VocabMnu}
